/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ManagedObjectMetadataCollectorImplBase
implements ManagedObjectMetadataCollector {
    public static final String ACTION_PARAM_PROFILE_TYPE = "BASE_PROFILE_TYPE";
    static final String PROFILE_TYPE_DMGR = "dmgr";
    static final String PROFILE_TYPE_MANAGED = "managed";
    static final String PROFILE_TYPE_DEFAULT = "default";
    public static final String[] PROFILE_TYPES = new String[]{"dmgr", "managed", "default"};
    private String _prodVersion_PropName;
    private String _prodShortName_PropName;
    private String _extensionID;
    private String[][] _productIDs;
    private String[] _defaultDirFilters;
    private String[] _dmgrDirFilters;
    private String[] _managedDirFilters;
    private WASProductInfo _curProdInfo;
    private String _curProdShortName;
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollector.class, "Admin", null);
    private Properties _inputProps;
    private Properties _metadata;
    private Exception _e = null;

    protected abstract String getProdVersion_PropName();

    protected abstract String getProdShortName_PropName();

    protected abstract String getExtensionID();

    protected abstract String[][] getProductIDs();

    protected abstract String[] getDefaultDirFilters();

    protected abstract String[] getDmgrDirFilters();

    protected abstract String[] getManagedDirFilters();

    public ManagedObjectMetadataCollectorImplBase(Properties properties) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ManagedObjectMetadataCollectorImplBase(Properties)", "Input props: " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)properties));
        }
        this._inputProps = properties;
        this._extensionID = this.getExtensionID();
        this._prodVersion_PropName = this.getProdVersion_PropName();
        this._prodShortName_PropName = this.getProdShortName_PropName();
        this._productIDs = this.getProductIDs();
        this._defaultDirFilters = this.getDefaultDirFilters();
        this._dmgrDirFilters = this.getDmgrDirFilters();
        this._managedDirFilters = this.getManagedDirFilters();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataCollectorImplBase(Properties)");
        }
    }

    protected boolean isProfileAugmentationRequired() {
        return true;
    }

    public void updateMetadata(String string, Hashtable hashtable, Properties properties) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateMetadata", new String[]{"action=" + string, "actionParams=" + hashtable, "metadata(in)=" + properties});
        }
        try {
            if (string == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateMetadata: Null action.  No action taken.");
                }
            } else if (string.equals("Collect Metadata")) {
                this.collectMetadata(properties);
            } else if (string.equals("Add Extension")) {
                if (this.isExtensionIDRecognized(hashtable)) {
                    String string2 = (String)hashtable.get(ACTION_PARAM_PROFILE_TYPE);
                    this.addMetadata(properties, string2);
                }
            } else if (string.equals("Remove Extension")) {
                if (this.isExtensionIDRecognized(hashtable)) {
                    String string3 = (String)hashtable.get(ACTION_PARAM_PROFILE_TYPE);
                    this.removeMetadata(properties, string3);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateMetadata: Action not recognized.  No action taken.");
            }
        }
        catch (Exception exception) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Exception: " + exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateMetadata", new String[]{"metadata(out)=" + properties});
        }
    }

    private boolean isExtensionIDRecognized(Hashtable hashtable) {
        boolean bl = false;
        String string = (String)hashtable.get("param.action.extension.id");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isExtensionIDRecognized: extID = " + string);
        }
        if (string != null && string.equals(this._extensionID)) {
            bl = true;
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isExtensionIDRecognized: Extension ID not recognized or not present.  No action taken.");
        }
        return bl;
    }

    private void collectMetadata(Properties properties) throws AdminException {
        Properties properties2 = new Properties();
        this.getProductInfo();
        if (this.isProfileAugmentationRequired()) {
            if (this.isThisProfileAugmented(properties)) {
                Tr.debug(_tc, "collectMetadata: this profile has been augmented by the extension associated with this collector.");
                this.collectVersionInfo(properties2);
            } else {
                Tr.debug(_tc, "collectMetadata: this profile has not been augmented by the extension associated with this collector.");
            }
        } else {
            Tr.debug(_tc, "collectMetadata: no profile augmentation is required by the extension associated with this collector.");
            properties2.setProperty(this._prodShortName_PropName, this._curProdShortName);
            this.collectVersionInfo(properties2);
        }
        properties.putAll((Map<?, ?>)properties2);
    }

    private void getProductInfo() throws AdminException {
        block8: {
            try {
                WASDirectory wASDirectory = new WASDirectory(this._inputProps.getProperty("was.install.root"));
                if (this._productIDs != null) {
                    int n = 0;
                    if (n >= this._productIDs.length) break block8;
                    WASProductInfo wASProductInfo = wASDirectory.getWASProductInfo(this._productIDs[n][0]);
                    if (wASProductInfo != null) {
                        this._curProdInfo = wASProductInfo;
                        this._curProdShortName = this._productIDs[n][1];
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getProductInfo: Got the product information for " + this._productIDs[n][0] + ".");
                        }
                        break block8;
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "getProductInfo: Caught exception.");
                    }
                    throw new AdminException("Could not obtain product information.");
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "getProductInfo: No produdct ID provided.");
                }
                throw new AdminException("No product ID provided and could not obtain product information.");
            }
            catch (Exception exception) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "getProductInfo: Caught exception.", exception);
                }
                throw new AdminException(exception, "Could not obtain product information.");
            }
        }
    }

    private boolean isThisProfileAugmented(Properties properties) {
        boolean bl = false;
        String string = null;
        if (properties != null) {
            string = properties.getProperty(this._prodShortName_PropName);
        }
        if (string != null && string.equals(this._curProdShortName)) {
            bl = true;
        }
        return bl;
    }

    private void collectVersionInfo(Properties properties) throws AdminException {
        String string = null;
        try {
            if (this._curProdInfo != null && (string = this._curProdInfo.getVersion()) != null) {
                properties.setProperty(this._prodVersion_PropName, string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "collectVersionInfo: Collecting version info is successful.");
                }
            }
        }
        catch (Exception exception) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Caught exception.", exception);
            }
            throw new AdminException(exception, "Could not obtain product version.");
        }
        if (string == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Could not obtain product version.");
            }
            throw new AdminException("Could not obtain product version.");
        }
    }

    private void addMetadata(Properties properties, String string) throws Exception {
        block18: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "addMetadata", new String[]{"metadata(in)=" + properties, "profileType=" + string});
            }
            this.getProductInfo();
            properties.setProperty(this._prodShortName_PropName, this._curProdShortName);
            if (string.equals(PROFILE_TYPE_DMGR) || string.equals(PROFILE_TYPE_DEFAULT)) {
                String string2 = this._inputProps.getProperty("was.install.root");
                if (string2 == null) {
                    AdminException adminException = new AdminException("No install root path provided.");
                    Manager.Ffdc.log((Throwable)adminException, (Object)this, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImplBase.addMetadata", "472", new Object[]{this});
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "addMetadata: No install root path.", adminException);
                    }
                    throw adminException;
                }
                String string3 = string2 + File.separator + "features";
                File file = new File(string3);
                if (!file.exists()) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "addMetadata: No features directory found under the install root directory, " + string2 + ".");
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "addMetadata: No features added.");
                    }
                    return;
                }
                if (!file.isDirectory()) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "appendBaseFeatures: The path \"" + string3 + "\" does not resolve to a directory.");
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "addMetadata: No features added.");
                    }
                    return;
                }
                try {
                    String string4;
                    StringBuffer stringBuffer;
                    String string5 = properties.getProperty("com.ibm.websphere.deployed.features");
                    Set set = this.parseFeaturesProp(string5);
                    String[] stringArray = file.list(new FeatureFileFilter(string));
                    if (string5 == null) {
                        stringBuffer = new StringBuffer();
                        string4 = "";
                    } else {
                        stringBuffer = new StringBuffer(string5);
                        string4 = ",";
                    }
                    int n = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string6 = stringArray[i];
                        if (set.contains(string6)) continue;
                        stringBuffer.append(string4);
                        stringBuffer.append(string6);
                        ++n;
                        string4 = ",";
                    }
                    if (n > 0) {
                        string5 = stringBuffer.toString();
                        Tr.debug(_tc, "addMetadata: setting features list:", "featuresProp=" + string5);
                        properties.setProperty("com.ibm.websphere.deployed.features", string5);
                    } else {
                        Tr.debug(_tc, "addMetadata: No features added.");
                    }
                }
                catch (Exception exception) {
                    if (!_tc.isEventEnabled()) break block18;
                    Tr.event(_tc, "addMetadata: Exception received:", exception);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addMetadata", new String[]{"metadata(out)=" + properties});
        }
    }

    private void removeMetadata(Properties properties, String string) throws Exception {
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "removeMetadata", new String[]{"metadata(in)=" + properties, "profileType=" + string});
            }
            properties.remove(this._prodShortName_PropName);
            properties.remove(this._prodVersion_PropName);
            String string2 = this._inputProps.getProperty("was.install.root");
            if (string.equals(PROFILE_TYPE_DMGR) || string.equals(PROFILE_TYPE_DEFAULT)) {
                try {
                    String string3 = properties.getProperty("com.ibm.websphere.deployed.features");
                    if (string3 != null && string3.length() != 0) {
                        String string4;
                        int n = 0;
                        String string5 = new String("");
                        String[] stringArray = null;
                        stringArray = string.equals(PROFILE_TYPE_DEFAULT) ? this._defaultDirFilters : this._dmgrDirFilters;
                        int n2 = string3.indexOf(44);
                        while (n2 != -1) {
                            boolean bl;
                            string4 = string3.substring(n, n2).trim();
                            if (string4.length() > 0 && (bl = this.isWantedFeature(string4, stringArray))) {
                                string5 = string5 + string4 + ",";
                            }
                            n = n2 + 1;
                            n2 = string3.indexOf(44, n);
                        }
                        string4 = string3.substring(n).trim();
                        string5 = string4.length() > 0 && this.isWantedFeature(string4, stringArray) ? string5 + string4 : string5.substring(0, string5.length() - 1);
                        Tr.debug(_tc, "removeMetadata: setting features list:", "newFeaturesProp=" + string5);
                        properties.setProperty("com.ibm.websphere.deployed.features", string5);
                    } else {
                        Tr.debug(_tc, "remvoeMetadata: No feature removed.");
                    }
                }
                catch (Exception exception) {
                    if (!_tc.isEventEnabled()) break block9;
                    Tr.event(_tc, "removeMetadata: Exception received:", exception);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeMetadata", new String[]{"metadata(out)=" + properties});
        }
    }

    private boolean isWantedFeature(String string, String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            bl = false;
        }
        return bl;
    }

    private Set parseFeaturesProp(String string) {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null || string.length() == 0) {
            return hashSet;
        }
        int n = 0;
        int n2 = string.indexOf(44);
        while (n2 != -1) {
            string2 = string.substring(n, n2).trim();
            if (string2.length() > 0) {
                hashSet.add(string2);
            }
            n = n2 + 1;
            n2 = string.indexOf(44, n);
        }
        string2 = string.substring(n).trim();
        if (string2.length() > 0) {
            hashSet.add(string2);
        }
        return hashSet;
    }

    private class FeatureFileFilter
    implements FilenameFilter {
        private String[] _featureFilters;

        public FeatureFileFilter(String string) {
            if (string.equals(ManagedObjectMetadataCollectorImplBase.PROFILE_TYPE_DEFAULT)) {
                this._featureFilters = ManagedObjectMetadataCollectorImplBase.this._defaultDirFilters;
            } else if (string.equals(ManagedObjectMetadataCollectorImplBase.PROFILE_TYPE_DMGR)) {
                this._featureFilters = ManagedObjectMetadataCollectorImplBase.this._dmgrDirFilters;
            } else if (string.equals(ManagedObjectMetadataCollectorImplBase.PROFILE_TYPE_MANAGED)) {
                this._featureFilters = ManagedObjectMetadataCollectorImplBase.this._managedDirFilters;
            } else {
                Manager.Ffdc.log((Throwable)new AdminException("No feature filters for profile type " + string), (Object)this, "com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorBase.FilenameFilter.FeatureFileFilter", "691", new Object[]{this});
                this._featureFilters = null;
            }
        }

        public boolean accept(File file, String string) {
            if (this._featureFilters == null) {
                return false;
            }
            for (int i = 0; i < this._featureFilters.length; ++i) {
                if (!string.startsWith(this._featureFilters[i])) continue;
                File file2 = new File(file.getAbsolutePath() + File.separator + string);
                return file2.isDirectory();
            }
            return false;
        }
    }
}

