/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControllerAdminService;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.management.collaborator.AgentProxyCollaborator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class AgentProxyServantCollaborator
extends RuntimeCollaborator
implements NotificationListener,
InvocationHandler {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    private static TraceComponent tc = Tr.register(AgentProxyServantCollaborator.class, "Admin", resBundleName);
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private static Method getProxyMethod;
    private Class intf;
    private ObjectName savedTargetON;
    private Proxy proxy = null;
    private ModelMBeanInfo mbeanInfo;
    private ControllerAdminService controllerAdmin = null;

    public AgentProxyServantCollaborator(Class intf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AgentProxyServantCollaborator constructor :" + intf.getName());
        }
        this.intf = intf;
        this.proxy = (Proxy)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AgentProxyServantCollaborator constructor:" + intf.getName());
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void bindMBean(ModelMBeanInfo info, ModelMBean bean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMBean for " + this.intf.getName(), new Object[]{info, bean});
        }
        this.mbeanInfo = info;
        this.modelMBean = bean;
        this.modelMBean.setManagedResource(this.proxy, "ObjectReference");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindMBean for" + this.intf.getName());
        }
    }

    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String msg;
        Class<?> declaringClass = method.getDeclaringClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke: interface: " + this.intf.getName() + " method: " + method.getName() + " declaring class:" + declaringClass.getName());
        }
        if (declaringClass == Object.class) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(proxy);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(proxy, args[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(proxy);
            }
            msg = nls.getFormattedMessage("ADMN1212E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1212E: Internal Error: MBean proxy unable process method {0} for interface {1}");
            AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg, null, true);
        }
        if (declaringClass == this.getClass()) {
            if (method.equals(getProxyMethod)) {
                return proxy;
            }
            msg = nls.getFormattedMessage("ADMN1212E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1212E: Internal Error: MBean proxy unable process method {0} for interface {1}");
            AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg, null, true);
        }
        if (declaringClass == this.intf) {
            String msg2;
            ObjectName sourceON = this.getObjectName();
            if (sourceON == null || this.mbeanInfo == null) {
                msg2 = nls.getFormattedMessage("ADMN1213E", new Object[]{this.intf.getName()}, "ADMN1213E: Internal Error: MBean proxy for interface {1} has not been activated");
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg2, null, true);
            }
            this.initialize();
            if (this.controllerAdmin == null) {
                msg2 = "Servant not yet initialized";
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg2, null, false);
            }
            String methodName = method.getName();
            Class<?>[] signatureClasses = method.getParameterTypes();
            String[] signatures = new String[signatureClasses.length];
            for (int i = 0; i < signatureClasses.length; ++i) {
                signatures[i] = signatureClasses[i].getName();
            }
            if (tc.isDebugEnabled()) {
                String info = "AgentProxyServantCollaborator for interface " + this.intf.getName() + "." + methodName + "(";
                for (int i = 0; i < signatures.length; ++i) {
                    if (i > 0) {
                        info = info + ", ";
                    }
                    info = info + signatures[i];
                }
                info = info + ")";
                Tr.debug(tc, info);
            }
            try {
                return this.controllerAdmin.invoke(sourceON, methodName, args, signatures);
            }
            catch (Exception ex) {
                String msg3 = "MBean Proxy on servant " + sourceON + "caught exception while calling method " + method.getName() + " while calling the control region";
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg3, ex, false);
            }
        }
        msg = nls.getFormattedMessage("ADMN1212E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1212E: Internal Error: MBean proxy unable process method {0} for interface {1}");
        AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg, null, true);
        return null;
    }

    private void initialize() throws ConnectorException, AdminException, InstanceNotFoundException, MalformedObjectNameException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AgentProxyServantCollaborator.initialize");
        }
        if (this.controllerAdmin != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AgentProxyServantCollaborator.initialize");
            }
            return;
        }
        ControllerAdminService ctrl = Utils.getControllerAdminService();
        ObjectName on = this.getObjectName();
        this.controllerAdmin = ctrl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AgentProxyServantCollaborator.initialize exit", on);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification for interface: " + this.intf.getName(), notification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification for interface: " + this.intf.getName());
        }
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", null);
            getProxyMethod = AgentProxyServantCollaborator.class.getMethod("getProxy", null);
        }
        catch (NoSuchMethodException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.collaborator.AgentProxyServantCollaborator", (String)"30");
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

