/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.intf.DCache;
import java.util.HashMap;
import java.util.Properties;

public class DistributedObjectCacheFactory {
    private static TraceComponent tc = Trace.register(DistributedObjectCacheFactory.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String KEY_CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String KEY_DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String KEY_DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String KEY_ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String KEY_ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String KEY_DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String KEY_USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String KEY_FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String KEY_ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String KEY_REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String KEY_DISKCACHE_PERFORMANCE_LEVEL = "com.ibm.ws.cache.CacheConfig.diskCachePerformanceLevel";
    public static final String KEY_DISK_CLEANUP_FREQUENCY = "com.ibm.ws.cache.CacheConfig.htodCleanupFrequency";
    public static final String KEY_DISK_DELAY_OFFLOAD_ENTRIES_LIMIT = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadEntriesLimit";
    public static final String KEY_DISK_DELAY_OFFLOAD_DEPID_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadDepIdBuckets";
    public static final String KEY_DISK_DELAY_OFFLOAD_TEMPLATE_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadTemplateBuckets";
    public static final String KEY_DISKCACHE_EVICTION_POLICY = "com.ibm.ws.cache.CacheConfig.diskCacheEvictionPolicy";
    public static final String KEY_DISKCACHE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheHighThreshold";
    public static final String KEY_DISKCACHE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheLowThreshold";
    public static final String KEY_DISKCACHE_SIZE = "com.ibm.ws.cache.CacheConfig.diskCacheSize";
    public static final String KEY_DISKCACHE_SIZE_GB = "com.ibm.ws.cache.CacheConfig.diskCacheSizeInGB";
    public static final String KEY_DISKCACHE_ENTRY_SIZE_MB = "com.ibm.ws.cache.CacheConfig.diskCacheEntrySizeInMB";
    public static final String KEY_LRU_TO_DISK_TRIGGER_PERCENT = "com.ibm.ws.cache.CacheConfig.lruToDiskTriggerPercent";
    public static final String KEY_MEMORY_CACHE_SIZE_IN_MB = "com.ibm.ws.cache.CacheConfig.memoryCacheSizeInMB";
    public static final String KEY_MEMORY_CACHE_SIZE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.memoryCacheHighThreshold";
    public static final String KEY_MEMORY_CACHE_SIZE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.memoryCacheLowThreshold";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private static HashMap<String, DistributedObjectCache> distributedMaps = new HashMap();
    private static final String FACTORY_PREFIX = "ws/";

    private DistributedObjectCacheFactory() {
    }

    public static DistributedObjectCache getMap(String string) {
        return DistributedObjectCacheFactory.getMap(string, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedObjectCache getMap(String string, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMap() name: (" + string + ") properties:" + properties);
        }
        if (string == null || string.trim().length() == 0) {
            throw new IllegalStateException("Map name can not be null or empty");
        }
        if (!ServerCache.objectCacheEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMap() WebSphere Dynamic Cache instance named " + string + " cannot be used because of Dynamic Object cache service has not be started.");
            }
            return null;
        }
        String string2 = string;
        if (!string.equalsIgnoreCase("default") && !string.equalsIgnoreCase("baseCache")) {
            string = FACTORY_PREFIX + string.trim();
        }
        DistributedObjectCache distributedObjectCache = null;
        HashMap<String, DistributedObjectCache> hashMap = distributedMaps;
        synchronized (hashMap) {
            distributedObjectCache = distributedMaps.get(string);
            if (distributedObjectCache == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getMap() Existing DistributedObjectCache not found for " + string);
                }
                distributedObjectCache = DistributedObjectCacheFactory.createDistributedObjectCache(string, string2, properties);
                distributedMaps.put(string, distributedObjectCache);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMap() Existing DistributedObjectCache found for " + string + " " + distributedObjectCache);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMap() map:" + distributedObjectCache);
        }
        return distributedObjectCache;
    }

    private static DistributedObjectCache createDistributedObjectCache(String string, String string2, Properties properties) {
        Object object;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createDistributedObjectCache() name: " + string + " properties:" + properties);
            }
            if (!ServerCache.objectCacheEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() WebSphere Dynamic Cache instance named " + string + " cannot be used because of Dynamic Object cache service has not be started.");
                }
                return null;
            }
            DCache dCache = ServerCache.getCache((String)string);
            if (dCache == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Existing Cache not found for " + string);
                }
                object = (CacheConfig)ServerCache.cacheService.getCacheConfig().clone();
                properties.put("com.ibm.ws.cache.CacheConfig.cacheName", string);
                properties.put("com.ibm.ws.cache.CacheConfig.cacheNameNonPrefixed", string2);
                object.overrideCacheConfig(properties);
                ServerCache.cacheService.addCacheInstanceConfig(object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDistributedObjectCache() Existing Cache found for " + string + " " + dCache);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDistributedObjectCache() DistributedMap " + string + " created from cache instance " + dCache);
            }
            object = null;
            try {
                object = (DistributedObjectCache)ServerCache.cacheUnit.createObjectCache(string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "createDistributedObjectCache() Exception:" + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDistributedObjectCache() map:" + object);
        }
        return object;
    }
}

