/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.format.jca;

import com.ibm.wsif.format.jca.IRangeObject;

public class ShortRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2002.";
    static final long serialVersionUID = 5533999846555242362L;
    protected short lowerRange_;
    protected short upperRange_;

    public ShortRange() {
        this.lowerRange_ = 0;
        this.upperRange_ = 0;
    }

    public ShortRange(short s, short s2) throws IllegalArgumentException {
        if (s2 < s) {
            throw new IllegalArgumentException(Short.toString(s2));
        }
        this.lowerRange_ = s;
        this.upperRange_ = s2;
    }

    public Object clone() {
        try {
            ShortRange shortRange = (ShortRange)super.clone();
            return shortRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortRange)) {
            return false;
        }
        ShortRange shortRange = (ShortRange)object;
        if (this.lowerRange_ != shortRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == shortRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Short(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Short(this.upperRange_);
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Short)) {
            return false;
        }
        short s = (Short)object;
        return ShortRange.isInRange(this.lowerRange_, this.upperRange_, s);
    }

    public static boolean isInRange(short s, short s2, short s3) throws IllegalArgumentException {
        if (s2 < s) {
            throw new IllegalArgumentException(Short.toString(s2));
        }
        return s3 >= s && s3 <= s2;
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Short)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = (Short)object;
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Short)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = (Short)object;
    }
}

