/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.format.jca;

import com.ibm.wsif.format.jca.IRangeObject;

public class CharacterRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2002.";
    static final long serialVersionUID = -4062258957317422887L;
    protected char lowerRange_;
    protected char upperRange_;

    public CharacterRange() {
        this.lowerRange_ = (char)65;
        this.upperRange_ = (char)65;
    }

    public CharacterRange(char c, char c2) throws IllegalArgumentException {
        if (!Character.isLetter(c)) {
            throw new IllegalArgumentException(new Character(c).toString());
        }
        if (!Character.isLetter(c2)) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        if (c2 < c) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        this.lowerRange_ = c;
        this.upperRange_ = c2;
    }

    public Object clone() {
        try {
            CharacterRange characterRange = (CharacterRange)super.clone();
            return characterRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharacterRange)) {
            return false;
        }
        CharacterRange characterRange = (CharacterRange)object;
        if (this.lowerRange_ != characterRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == characterRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Character(this.lowerRange_);
    }

    public Object[] getRangeValues() {
        int n = 0;
        int n2 = this.lowerRange_;
        while (n2 <= this.upperRange_) {
            if (Character.isLetter((char)n2)) {
                ++n;
            }
            ++n2;
        }
        Object[] objectArray = new Character[n];
        int n3 = this.lowerRange_;
        int n4 = 0;
        while (n3 <= this.upperRange_) {
            if (Character.isLetter((char)n3)) {
                objectArray[n4] = new Character((char)n3);
                ++n4;
            }
            ++n3;
        }
        return objectArray;
    }

    public Object getUpperRange() {
        return new Character(this.upperRange_);
    }

    public static boolean isInRange(char c, char c2, char c3) throws IllegalArgumentException {
        if (!Character.isLetter(c)) {
            throw new IllegalArgumentException(new Character(c).toString());
        }
        if (!Character.isLetter(c2)) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        if (!Character.isLetter(c3)) {
            throw new IllegalArgumentException(new Character(c3).toString());
        }
        if (c2 < c) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        return c3 >= c && c3 <= c2;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Character)) {
            return false;
        }
        char c = ((Character)object).charValue();
        return CharacterRange.isInRange(this.lowerRange_, this.upperRange_, c);
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Character)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = ((Character)object).charValue();
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Character)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = ((Character)object).charValue();
    }
}

