/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.transformer;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.transformer.TransformerAddress;
import com.ibm.wsdl.extensions.transformer.TransformerBinding;
import com.ibm.wsdl.extensions.transformer.TransformerBindingConstants;
import com.ibm.wsdl.extensions.transformer.TransformerOperation;
import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class TransformerBindingSerializer
implements ExtensionDeserializer,
ExtensionSerializer,
Serializable {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2002, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$Port;

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        ExtensibilityElement extensibilityElement = null;
        if (TransformerBindingConstants.Q_ELEM_TRANSFORMER_BINDING.equals(qName)) {
            TransformerBinding transformerBinding = new TransformerBinding();
            return transformerBinding;
        }
        if (TransformerBindingConstants.Q_ELEM_TRANSFORMER_OPERATION.equals(qName)) {
            TransformerOperation transformerOperation = new TransformerOperation();
            Element element2 = DOMUtils.getFirstChildElement(element);
            transformerOperation.setMappingElement(element2);
            return transformerOperation;
        }
        if (TransformerBindingConstants.Q_ELEM_TRANSFORMER_ADDRESS.equals(qName)) {
            TransformerAddress transformerAddress = new TransformerAddress();
            return transformerAddress;
        }
        return extensibilityElement;
    }

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        if (extensibilityElement == null) {
            return;
        }
        if (extensibilityElement instanceof TransformerBinding) {
            TransformerBinding transformerBinding = (TransformerBinding)extensibilityElement;
            printWriter.print("      <transformer:binding");
            Boolean bl = extensibilityElement.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        } else if (extensibilityElement instanceof TransformerOperation) {
            TransformerOperation transformerOperation = (TransformerOperation)extensibilityElement;
            printWriter.print("      <transformer:operation>");
            Boolean bl = extensibilityElement.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            DOM2Writer.serializeAsXML(transformerOperation.getMappingElement(), outputStreamWriter);
            try {
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            printWriter.print(byteArrayOutputStream.toString());
            printWriter.println("      </transformer:operation>");
        } else if (extensibilityElement instanceof TransformerAddress) {
            TransformerAddress transformerAddress = (TransformerAddress)extensibilityElement;
            printWriter.print("      <transformer:address");
            Boolean bl = extensibilityElement.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public void registerSerializer(ExtensionRegistry extensionRegistry) {
        extensionRegistry.registerSerializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = TransformerBindingSerializer.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, TransformerBindingConstants.Q_ELEM_TRANSFORMER_BINDING, this);
        extensionRegistry.registerDeserializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = TransformerBindingSerializer.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, TransformerBindingConstants.Q_ELEM_TRANSFORMER_BINDING, this);
        extensionRegistry.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = TransformerBindingSerializer.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, TransformerBindingConstants.Q_ELEM_TRANSFORMER_OPERATION, this);
        extensionRegistry.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = TransformerBindingSerializer.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, TransformerBindingConstants.Q_ELEM_TRANSFORMER_OPERATION, this);
        extensionRegistry.registerSerializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = TransformerBindingSerializer.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, TransformerBindingConstants.Q_ELEM_TRANSFORMER_ADDRESS, this);
        extensionRegistry.registerDeserializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = TransformerBindingSerializer.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, TransformerBindingConstants.Q_ELEM_TRANSFORMER_ADDRESS, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

