/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.JVMListenerInterface;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ServantJVMListener
implements JVMListenerInterface {
    private static final TraceComponent tc = Tr.register(ServantJVMListener.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private AdminService adminService;
    private MBeanServer mbServer;
    private ObjectName controlMBeanName;

    public ServantJVMListener() {
        block7: {
            this.adminService = null;
            this.mbServer = null;
            this.controlMBeanName = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>");
            }
            try {
                this.adminService = AdminServiceFactory.getAdminService();
                ObjectName queryName = new ObjectName(this.adminService.getDomainName() + ":" + "type=ControlAdminService,*");
                this.mbServer = this.adminService.getMBeanFactory().getMBeanServer();
                Set names = this.mbServer.queryNames(queryName, null);
                if (names.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdminService MBean not registered");
                    }
                } else {
                    Iterator iterator = names.iterator();
                    this.controlMBeanName = (ObjectName)iterator.next();
                }
                AdminHelper.getPlatformHelper().registerListener((JVMListenerInterface)this);
            }
            catch (MalformedObjectNameException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantJVMListener.ServantJVMListener", (String)"119", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "ControlAdminService object name error", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void servantTerminated(String stoken) {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "servantTerminated", stoken);
            }
            if (this.controlMBeanName != null) {
                String stringStoken = null;
                if (stoken != null && stoken.length() > 0) {
                    stringStoken = stoken;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "stringStoken", stringStoken);
                    }
                } else {
                    IllegalArgumentException ex = new IllegalArgumentException("Servant stoken not present");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing illegal argument exception", ex);
                    }
                    throw ex;
                }
                try {
                    this.mbServer.invoke(this.controlMBeanName, "cleanupServantJVM", new Object[]{stringStoken}, new String[]{"java.lang.String"});
                }
                catch (InstanceNotFoundException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantJVMListener.servantTerminated", (String)"201", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to invoke ControlAdminService MBean", ex);
                    }
                }
                catch (MBeanException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantJVMListener.servantTerminated", (String)"207", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to invoke ControlAdminService MBean", ex);
                    }
                }
                catch (ReflectionException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantJVMListener.servantTerminated", (String)"213", (Object)this);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Unable to invoke ControlAdminService MBean", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "servantTerminated");
        }
    }
}

