/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.Serializable;
import java.text.NumberFormat;

public class Day
implements Serializable {
    int day;
    String timezone = null;

    public Day(int n) throws NumberFormatException {
        this.setValue(n);
    }

    public Day(int n, String string) throws NumberFormatException {
        this.setValue(n, string);
    }

    public Day(String string) throws NumberFormatException {
        if (string.length() < 5) {
            throw new NumberFormatException(Messages.getMessage((String)"badDay00", (String)string));
        }
        if (string.charAt(0) != '-' || string.charAt(1) != '-' || string.charAt(2) != '-') {
            throw new NumberFormatException(Messages.getMessage((String)"badDay00", (String)string));
        }
        this.setValue(Integer.parseInt(string.substring(3, 5)), string.substring(5));
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int n) {
        if (n < 1 || n > 31) {
            throw new NumberFormatException(Messages.getMessage((String)"badDay00", (String)String.valueOf(n)));
        }
        this.day = n;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String string) {
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-' ? string.length() != 6 || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5)) : !string.equals("Z")) {
                throw new NumberFormatException(Messages.getMessage((String)"badTimezone00", (String)string));
            }
            this.timezone = string;
        }
    }

    public void setValue(int n, String string) throws NumberFormatException {
        this.setDay(n);
        this.setTimezone(string);
    }

    public void setValue(int n) throws NumberFormatException {
        this.setDay(n);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        String string = "---" + numberFormat.format(this.day);
        if (this.timezone != null) {
            string = string + this.timezone;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Day)) {
            return false;
        }
        Day day = (Day)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl2 = bl = this.day == day.day;
        if (this.timezone != null) {
            bl = bl && this.timezone.equals(day.timezone);
        }
        return bl;
    }
}

