/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.utils.Callback;
import com.ibm.ws.webservices.engine.encoding.utils.CallbackTarget;
import com.ibm.ws.webservices.engine.encoding.utils.Target;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Deserializer
extends DEventProcessor
implements javax.xml.rpc.encoding.Deserializer,
Callback {
    protected static Log log = LogFactory.getLog((String)Deserializer.class.getName());
    protected QName xmlType;
    protected Class javaType;
    protected Object value = null;
    protected Vector targets = null;
    protected QName defaultType = null;
    private boolean componentsReadyFlag = false;
    protected boolean isEnded = false;
    protected boolean isHref = false;
    protected boolean isNil = false;
    protected String id = null;
    private HashSet activeDeserializers = null;

    public Deserializer(Class clazz, QName qName) {
        this.javaType = clazz;
        this.xmlType = qName;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getValue(Object object) {
        return null;
    }

    public void setValue(Object object, Object object2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValue of " + JavaUtils.getObjectIdentity(this) + " value=" + JavaUtils.getObjectIdentity(object) + " hint =" + JavaUtils.getObjectIdentity(object2)));
        }
        if (object2 instanceof Deserializer) {
            if (this.activeDeserializers != null) {
                this.activeDeserializers.remove(object2);
            }
            if (this.componentsReady()) {
                this.valueComplete();
            }
        }
    }

    public void setDefaultType(QName qName) {
        this.defaultType = qName;
    }

    public QName getDefaultType() {
        return this.defaultType;
    }

    public void registerValueTarget(Target target) {
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addElement(target);
    }

    public Vector getValueTargets() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getValueTargets of " + JavaUtils.getObjectIdentity(this)));
        }
        return this.targets;
    }

    public void removeValueTargets() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeValueTargets of " + JavaUtils.getObjectIdentity(this)));
        }
        if (this.targets != null) {
            this.targets.clear();
        }
    }

    public void moveValueTargets(Deserializer deserializer) {
        Vector vector;
        if (log.isDebugEnabled()) {
            log.debug((Object)("moveValueTargets of " + JavaUtils.getObjectIdentity(this) + " other=" + JavaUtils.getObjectIdentity(deserializer)));
        }
        if (deserializer == null || deserializer.getValueTargets() == null) {
            return;
        }
        if (this.targets == null) {
            this.targets = new Vector();
        }
        if ((vector = deserializer.getValueTargets()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.targets.addElement(vector.get(i));
            }
        }
        deserializer.removeValueTargets();
    }

    public boolean componentsReady() {
        return this.componentsReadyFlag || !this.isHref && this.isEnded && (this.activeDeserializers == null || this.activeDeserializers.isEmpty());
    }

    public void valueComplete() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("valueComplete of " + JavaUtils.getObjectIdentity(this) + " componentsReady=" + this.componentsReady()));
        }
        if (this.componentsReady() && this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                Target target = (Target)this.targets.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage((String)"setValueInTarget00", (String)JavaUtils.getObjectIdentity(this.value), (String)("" + JavaUtils.getObjectIdentity(target))));
                }
                target.set(this.value);
            }
            if (this.targets.size() > 0) {
                this.removeValueTargets();
                if (this.id == null) {
                    this.relinquish();
                }
            }
        }
    }

    public void addChildDeserializer(Deserializer deserializer, String string) {
        if (this.activeDeserializers == null) {
            this.activeDeserializers = new HashSet();
        }
        this.activeDeserializers.add(deserializer);
        CallbackTarget callbackTarget = new CallbackTarget(this, deserializer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register callback " + JavaUtils.getObjectIdentity(callbackTarget) + " for child deser " + JavaUtils.getObjectIdentity(deserializer) + " on deserializer " + JavaUtils.getObjectIdentity(this)));
        }
        deserializer.registerValueTarget(callbackTarget);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        this.startElement(string, string2, string3, attributes, mappingScope, deserializationContext, null);
    }

    protected final void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, Boolean bl) throws SAXException {
        String string4;
        if (AttributeUtils.isNil((Attributes)attributes)) {
            this.value = null;
            this.isNil = true;
            return;
        }
        deserializationContext.logBuildNumber(this.getBuildNumber());
        String string5 = this.id = bl == Boolean.TRUE ? null : attributes.getValue("id");
        if (this.id != null) {
            deserializationContext.getHrefTable().addObjectByID(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"deserInitPutValueDebug00", (String)JavaUtils.getObjectIdentity(this.value), (String)this.id));
            }
            deserializationContext.getHrefTable().registerFixupByHref("#" + this.id, this);
        }
        if ((string4 = attributes.getValue("href")) != null) {
            this.isHref = true;
            Object object = deserializationContext.getHrefTable().getObjectByHref(string4);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"gotForID00", (String[])new String[]{JavaUtils.getObjectIdentity(object), string4, object == null ? "*null*" : object.getClass().toString()}));
            }
            if (object == null) {
                deserializationContext.getHrefTable().registerFixupByHref(string4, this);
                return;
            }
            if (object instanceof SOAPElement) {
                deserializationContext.getEventConverter().popDEventProcessor();
                deserializationContext.getEventConverter().pushDEventProcessor(new WrapperProcessor(this));
                ((SOAPElement)object).toEvents((PEventProcessor)deserializationContext.getEventConverter());
                return;
            }
            if (!string4.startsWith("#") && this.defaultType != null && object instanceof Part) {
                Deserializer deserializer = deserializationContext.getDeserializer(null, this.defaultType);
                if (null != deserializer) {
                    deserializer.startElement(string, string2, string3, attributes, mappingScope, deserializationContext);
                    object = deserializer.getValue();
                    deserializationContext.getMessageContext().setProperty("com.ibm.ws.webservices.engine.attachment.style", "HREF");
                }
                this.value = object;
                this.componentsReadyFlag = true;
                this.valueComplete();
                return;
            }
            this.value = object;
            this.componentsReadyFlag = true;
            this.valueComplete();
            return;
        }
        this.isHref = false;
        this.onStartElement(string, string2, string3, attributes, mappingScope, deserializationContext);
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
    }

    public abstract DEventProcessor onStartChild(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public final void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start endElement of " + JavaUtils.getObjectIdentity(this)));
        }
        this.isEnded = true;
        if (!this.isHref) {
            this.onEndElement(string, string2, deserializationContext);
        }
        if (this.id != null) {
            deserializationContext.getHrefTable().addObjectByID(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"deserPutValueDebug00", (String)JavaUtils.getObjectIdentity(this.value), (String)this.id));
            }
        }
        if (this.componentsReady()) {
            this.valueComplete();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end endElement of " + JavaUtils.getObjectIdentity(this)));
        }
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("reusing deserializer " + JavaUtils.getObjectIdentity(this)));
            }
            this.value = null;
            if (this.targets != null) {
                if (log.isDebugEnabled() && this.targets.size() > 0) {
                    log.debug((Object)("PROBLEM: reusing deserializer with targets: " + this.targets.size()));
                }
                this.targets.clear();
            }
            this.defaultType = null;
            this.componentsReadyFlag = false;
            this.isEnded = false;
            this.isHref = false;
            this.isNil = false;
            this.id = null;
            if (this.activeDeserializers != null) {
                if (log.isDebugEnabled() && this.activeDeserializers.size() > 0) {
                    log.debug((Object)("PROBLEM: reusing deserializer with active children deserializers: " + this.activeDeserializers.size()));
                }
                this.activeDeserializers.clear();
            }
        }
        return bl;
    }

    public void relinquish() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("relinquishing deserializer " + JavaUtils.getObjectIdentity(this)));
        }
        this.value = null;
        super.relinquish();
    }

    public String getBuildNumber() {
        return null;
    }
}

