/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.client.ClientProxy;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Stub;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.configuration.SimpleEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.soap.ClientSOAPPort;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WSDLUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class Service
implements javax.xml.rpc.Service,
Serializable,
Referenceable {
    private WebServicesEngine engine;
    private QName serviceName = null;
    private String serviceRefName = null;
    private Map portTypeToPortMapping = null;
    private Map seiToPortTypeMapping = null;
    private Map overriddingEndpointURIs = null;
    private String wsdlLoadStrategyPath = null;
    private URL wsdlLocation = null;
    private String wsdlFileName = null;
    private Definition wsdlDefinition = null;
    private javax.wsdl.Service wsdlService = null;
    private boolean maintainSession = false;
    private HandlerRegistryImpl registry = new HandlerRegistryImpl();
    private Map namespace2packageMapping = null;
    private static Map cachedWSDL = new HashMap();
    private static boolean cachingWSDL = true;
    protected static Log log = LogFactory.getLog((String)Service.class.getName());
    private Map connectionMap = Collections.synchronizedMap(new WeakHashMap());

    Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    javax.wsdl.Service getWSDLService() {
        return this.wsdlService;
    }

    public Service() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service()  ");
        }
        this.initService();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service()  ");
        }
    }

    public Service(QName qName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry Service(QName)  " + qName.toString()));
        }
        this.initService();
        this.serviceName = qName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service(QName)  ");
        }
    }

    public Service(EngineConfiguration engineConfiguration) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service(EngineConfiguration)  ");
        }
        this.engine = ClientEngineFactory.getEngine((EngineConfiguration)engineConfiguration);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service(EngineConfiguration)  ");
        }
    }

    public Service(URL uRL, QName qName) throws ServiceException {
        Definition definition;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry Service(URL, QName)  " + qName.toString()));
        }
        this.serviceName = qName;
        this.wsdlLocation = uRL;
        Definition definition2 = definition = cachingWSDL ? (Definition)cachedWSDL.get(uRL.toString()) : null;
        if (definition == null) {
            Document document = null;
            try {
                document = XMLUtils.newDocument((String)uRL.toString());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Service.initService", (String)"199", (Object)this);
                throw new ServiceException(Messages.getMessage((String)"wsdlError00", (String)"", (String)("\n" + exception)));
            }
            try {
                WSDLFactoryImpl wSDLFactoryImpl = new WSDLFactoryImpl();
                WSDLReader wSDLReader = wSDLFactoryImpl.newWSDLReader();
                wSDLReader.setFeature("javax.wsdl.verbose", false);
                definition = wSDLReader.readWSDL(uRL.toString(), document);
                if (cachingWSDL) {
                    cachedWSDL.put(uRL.toString(), definition);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Service.initService", (String)"293", (Object)this);
                throw new ServiceException(Messages.getMessage((String)"wsdlError00", (String)"", (String)("\n" + exception)));
            }
        }
        this.initService(definition);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service(URL, QName)  ");
        }
    }

    public Service(ClientEngine clientEngine, Definition definition, QName qName, Map map) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service(ClientEngine, Definition, QName, Map)  ");
        }
        this.engine = clientEngine;
        this.serviceName = qName;
        cachingWSDL = false;
        this.wsdlLocation = null;
        this.namespace2packageMapping = map;
        this.initService(definition);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service(ClientEngine, Definition, QName, Map)  ");
        }
    }

    protected void initService() {
        try {
            this.initService(null);
        }
        catch (ServiceException serviceException) {
            FFDCFilter.processException((Throwable)serviceException, (String)"com.ibm.ws.webservices.engine.client.Service.initService", (String)"277", (Object)this);
        }
    }

    protected void initService(Definition definition) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service.initService(Definition)  ");
        }
        if (definition != null) {
            try {
                this.wsdlDefinition = definition;
                this.wsdlService = definition.getService(this.serviceName);
                if (this.wsdlService == null) {
                    throw new ServiceException(Messages.getMessage((String)"noService00", (String)("" + this.serviceName)));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Service.initService", (String)"310", (Object)this);
                throw new ServiceException(Messages.getMessage((String)"wsdlError00", (String)"", (String)("\n" + exception)));
            }
        }
        if (this.engine == null) {
            EngineConfiguration engineConfiguration = EngineConfigurationFactoryFinder.newFactory((Object)AgnosticService.getWhichGlobalHandlersToUseOffThread()).getClientEngineConfig();
            SimpleEngineConfigurationProvider simpleEngineConfigurationProvider = new SimpleEngineConfigurationProvider(engineConfiguration);
            Iterator iterator = this.getPorts();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    QName qName = (QName)iterator.next();
                    ClientSOAPPort clientSOAPPort = new ClientSOAPPort(null, null);
                    clientSOAPPort.setName(qName.getLocalPart());
                    clientSOAPPort.getPortDesc().setWSDLPort(qName);
                    simpleEngineConfigurationProvider.deployPort(clientSOAPPort.getName(), (SOAPPort)clientSOAPPort);
                }
            }
            this.engine = new ClientEngine((EngineConfiguration)simpleEngineConfigurationProvider);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service.initService(Definition)  ");
        }
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        this.assertValidPortName_getPort(qName);
        this.assertValidProxyInterface_getPort(clazz);
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage((String)"wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage((String)"noPort00", (String)("" + qName)));
        }
        return this.getPort(null, qName, clazz);
    }

    public Remote getPort(Class clazz) throws ServiceException {
        this.assertValidProxyInterface_getPort(clazz);
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage((String)"wsdlMissing00"));
        }
        return this.getPort(null, null, clazz);
    }

    private Port findPortForSEI(Class clazz) {
        if (clazz != null) {
            QName qName = null;
            if (this.seiToPortTypeMapping != null) {
                qName = (QName)this.seiToPortTypeMapping.get(clazz.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findPortForSEI(sei): setToPortTypeMapping not null.  After looking in table explicitPortTypeQName = " + qName));
                }
            }
            Iterator iterator = this.wsdlService.getPorts().values().iterator();
            while (iterator.hasNext()) {
                Port port = (Port)iterator.next();
                QName qName2 = port.getBinding().getPortType().getQName();
                if ((qName == null || !qName.equals(qName2)) && !clazz.getName().equals(this.guessAtClassName(qName2))) continue;
                QName qName3 = null;
                if (this.portTypeToPortMapping != null) {
                    qName3 = (QName)this.portTypeToPortMapping.get(qName2);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("findPortForSEI(sei): PortTypeToPortMapping not null, found default port = " + qName3));
                    }
                }
                if (qName3 != null && (!port.getName().equals(qName3.getLocalPart()) || !this.wsdlService.getQName().getNamespaceURI().equals(qName3.getNamespaceURI()))) continue;
                return port;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"findPortForSEI(sei): *** WARNING *** No port found.  Returning null!");
        }
        return null;
    }

    protected boolean isSOAPPort(Port port) {
        boolean bl = false;
        Binding binding = port.getBinding();
        List list = binding.getExtensibilityElements();
        if (list != null && list.size() > 0) {
            bl = list.get(0) instanceof SOAPBinding;
        }
        return bl;
    }

    private String guessAtClassName(QName qName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("guessAtClassName(qName): for Qname localPart = " + qName.getLocalPart() + " and namespaceURI = " + qName.getNamespaceURI()));
        }
        String string = null;
        String string2 = JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug((Object)("guessAtClassName(qName): Class name from JavaUtils = " + string2));
        }
        if (this.namespace2packageMapping != null) {
            string = (String)this.namespace2packageMapping.get(qName.getNamespaceURI());
            if (log.isDebugEnabled()) {
                log.debug((Object)("guessAtClassName(qName): Using namespace2packageMapping found package = " + string));
            }
        }
        if (string == null) {
            string = JavaUtils.makePackageName(qName.getNamespaceURI());
            if (log.isDebugEnabled()) {
                log.debug((Object)("guessAtClassName(qName): Package not found in ns2pkg mapping so JavaUtils.makePackageName returned = " + string));
            }
        }
        if (string != null && string != "") {
            return string + '.' + string2;
        }
        return string2;
    }

    public Remote getPort(String string, Class clazz) throws ServiceException {
        this.assertValidEndpoint_getPort(string);
        this.assertValidProxyInterface_getPort(clazz);
        return this.getPort(string, null, clazz);
    }

    private Remote getPort(String string, QName qName, Class clazz) throws ServiceException {
        Remote remote;
        Port port = null;
        port = qName == null ? this.findPortForSEI(clazz) : this.wsdlService.getPort(qName.getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPort(endpoint, portName, proxyInterface): After looking up port = " + port));
        }
        if (string == null && port != null) {
            if (this.getOverriddingEndpointURIs() != null) {
                string = (String)this.getOverriddingEndpointURIs().get(port.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getPort(endpoint, portName, proxyInterface): overriddingEndpoingURI " + string + " for port " + port.getName()));
                }
            }
            if (string == null) {
                string = WSDLUtils.getAddressFromPort((Port)port);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getPort(endpoint, portName, proxyInterface): endpoint was null.  After getting it from WSDL endpoint = " + string));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPort(endpoint, portName, proxyInterface): Looking for Stub with endpoint = " + string + " port = " + port + " proxyInterface = " + clazz));
        }
        if ((remote = this.getGeneratedStub(string, port, clazz, true)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getPort(endpoint, portName, proxyInterface): No generated JAX-RPC naming style stub found.  Look for non-JAX-RPC stub");
            }
            remote = this.getGeneratedStub(string, port, clazz, false);
        }
        if (remote == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getPort(endpoint, portName, proxyInterface): No generated stubs found.  Try dynamic proxy.");
            }
            remote = this.getDynamicProxy(string, port, clazz);
        }
        return remote;
    }

    private Remote getGeneratedStub(String string, Port port, Class clazz, boolean bl) {
        try {
            if (port == null) {
                return null;
            }
            String string2 = clazz.getName();
            string2 = string2.substring(0, string2.lastIndexOf(46));
            String string3 = port.getBinding().getQName().getLocalPart();
            Class clazz2 = bl ? ClassUtils.forName((String)(string2 + "." + JavaUtils.xmlNameToJavaClass(string3) + "Stub")) : ClassUtils.forName((String)(string2 + "." + JavaUtils.createNonJAXRPCName(string3) + "Stub"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("getGeneratedStub(endpoint, port, proxyInterface, JAXRPCNameMappingScheme): Generated StubClass name = " + clazz2.getName()));
            }
            if (clazz.isAssignableFrom(clazz2)) {
                Class[] classArray = new Class[]{URL.class, javax.xml.rpc.Service.class};
                URL uRL = null;
                uRL = string != null ? new URL(string) : new URL(WSDLUtils.getAddressFromPort((Port)port));
                Object[] objectArray = new Object[]{uRL, this};
                Constructor constructor = clazz2.getConstructor(classArray);
                Stub stub = (Stub)constructor.newInstance(objectArray);
                stub.setPortName(ClientModuleMetaData.clientConfigurationPortName((String)this.getServiceRefName(), (String)port.getName()));
                return (Remote)((Object)stub);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"getGeneratedStub(endpoint, port, proxyInterface, JAXRPCNameMappingScheme): *** WARNING *** Stub not assignable from Proxy");
            }
            return null;
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"com.ibm.ws.webservices.engine.client.Service.getGeneratedStub(endpoint, port, proxyInterface, JAXRPCNameMappingScheme): *** WARNING *** Caught exception.", throwable);
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Remote getDynamicProxy(String string, Port port, Class clazz) throws ServiceException {
        try {
            Call call = null;
            if (port == null) {
                call = (Call)this.createCall();
                if (string == null) throw new ServiceException(Messages.getMessage((String)"noEndpoint"));
                call.setTargetEndpointAddress(new URL(string));
            } else {
                call = (Call)this.createCall(QNameTable.createQName("", port.getName()));
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return (Remote)Proxy.newProxyInstance(classLoader, new Class[]{clazz, javax.xml.rpc.Stub.class}, (InvocationHandler)new ClientProxy(call));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Service.getPort", (String)"441", (Object)this);
            throw new ServiceException(exception.toString());
        }
    }

    public javax.xml.rpc.Call createCall(QName qName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service.createCall(QName)  ");
        }
        this.assertValidPortName_createCall(qName);
        Call call = (Call)this.createCall();
        String string = ClientModuleMetaData.clientConfigurationPortName((String)this.getServiceRefName(), (String)qName.getLocalPart());
        call.setPortName(new QName(string));
        if (this.wsdlDefinition == null) {
            return call;
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage((String)"noPort00", (String)("" + qName)));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new ServiceException(Messages.getMessage((String)"noPortType00", (String)("" + qName)));
        }
        List list = port.getExtensibilityElements();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof SOAPAddress)) continue;
            try {
                SOAPAddress sOAPAddress = (SOAPAddress)e;
                URL uRL = new URL(sOAPAddress.getLocationURI());
                call.setTargetEndpointAddress(uRL);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Service.createCall", (String)"485", (Object)this);
                throw new ServiceException(Messages.getMessage((String)"cantSetURI00", (String)("" + exception)));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service.createCall(QName)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName qName, String string, String string2) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service.createCall(QName, String, String)  ");
        }
        this.assertValidOperationName_createCall(string);
        Call call = null;
        try {
            call = (Call)this.createCall();
            call.setOperation(qName, string, string2);
            if (qName != null) {
                String string3 = ClientModuleMetaData.clientConfigurationPortName((String)this.getServiceRefName(), (String)qName.getLocalPart());
                call.setPortName(QNameTable.createQName(null, string3));
            }
        }
        catch (ServiceException serviceException) {
            FFDCFilter.processException((Throwable)serviceException, (String)"com.ibm.ws.webservices.engine.client.Service.createCall", (String)"916", (Object)this);
            throw serviceException;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service.createCall(QName, String, String)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName qName, String string) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service.createCall(QName, String)  ");
        }
        this.assertValidPortName_createCall(qName);
        this.assertValidOperationName_createCall(string);
        Call call = (Call)this.createCall();
        call.setOperation(qName, string);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service.createCall(QName, String)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName qName, QName qName2) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service.createCall(QName, QName)  ");
        }
        this.assertValidPortName_createCall(qName);
        this.assertValidOperationName_createCall(qName2);
        Call call = (Call)this.createCall();
        call.setOperation(qName, qName2.getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service.createCall(QName, QName)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall() throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry Service.createCall()  ");
        }
        Call call = new Call(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit Service.createCall()  ");
        }
        return call;
    }

    public javax.xml.rpc.Call[] getCalls(QName qName) throws ServiceException {
        if (qName == null) {
            throw new ServiceException(Messages.getMessage((String)"badPort00"));
        }
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage((String)"wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage((String)"noPort00", (String)("" + qName)));
        }
        Binding binding = port.getBinding();
        List list = binding.getBindingOperations();
        Iterator iterator = list.iterator();
        javax.xml.rpc.Call[] callArray = new javax.xml.rpc.Call[list.size()];
        int n = 0;
        while (iterator.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            QName qName2 = QNameTable.createQName("", bindingOperation.getName());
            callArray[n++] = this.createCall(qName, qName2);
        }
        return callArray;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.getEngine().isContainerManaged()) {
            throw new UnsupportedOperationException(Messages.getMessage((String)"jaxRpcGetHandlerRegistry109"));
        }
        return this.registry;
    }

    public void setWSDLDocumentLocation(URL uRL) {
        this.wsdlLocation = uRL;
    }

    public URL getWSDLDocumentLocation() {
        URL uRL = null;
        if (this.wsdlLocation != null) {
            uRL = this.wsdlLocation;
        } else if (this.wsdlFileName != null) {
            String string = null;
            string = this.wsdlFileName.indexOf(":") == -1 ? "file://///./" + this.wsdlFileName : this.wsdlFileName;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public QName getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.wsdlService == null) {
            return null;
        }
        QName qName = this.wsdlService.getQName();
        return QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public Iterator getPorts() throws ServiceException {
        Vector<QName> vector = new Vector<QName>();
        if (this.wsdlService != null && this.wsdlService.getPorts() != null) {
            Iterator iterator = this.wsdlService.getPorts().keySet().iterator();
            while (iterator.hasNext()) {
                vector.add(QNameTable.createQName(null, (String)iterator.next()));
            }
        }
        return vector.iterator();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.getEngine().isContainerManaged()) {
            throw new UnsupportedOperationException(Messages.getMessage((String)"jaxRpcGetTypeMappingRegistry109"));
        }
        return this.getEngine().getTypeMappingRegistry();
    }

    public Reference getReference() {
        String string = this.getClass().getName();
        Reference reference = new Reference(string, "com.ibm.ws.webservices.engine.client.ServiceFactory", null);
        StringRefAddr stringRefAddr = null;
        if (!string.equals("com.ibm.ws.webservices.engine.client.Service")) {
            stringRefAddr = new StringRefAddr("service classname", string);
            reference.add(stringRefAddr);
        } else {
            QName qName;
            if (this.wsdlLocation != null) {
                stringRefAddr = new StringRefAddr("WSDL location", this.wsdlLocation.toString());
                reference.add(stringRefAddr);
            }
            if ((qName = this.getServiceName()) != null) {
                stringRefAddr = new StringRefAddr("service namespace", qName.getNamespaceURI());
                reference.add(stringRefAddr);
                stringRefAddr = new StringRefAddr("service local part", qName.getLocalPart());
                reference.add(stringRefAddr);
            }
        }
        if (this.maintainSession) {
            stringRefAddr = new StringRefAddr("maintain session", "true");
            reference.add(stringRefAddr);
        }
        return reference;
    }

    public WebServicesEngine getEngine() {
        return this.engine;
    }

    public void setEngine(WebServicesEngine webServicesEngine) {
        this.engine = webServicesEngine;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public boolean getCacheWSDL() {
        return cachingWSDL;
    }

    public void setCacheWSDL(boolean bl) {
        cachingWSDL = bl;
    }

    public synchronized Connection getConnection(URL uRL) {
        Connection connection = (Connection)this.connectionMap.get(uRL);
        if (connection == null) {
            if (this.connectionMap.size() >= 15) {
                this.connectionMap.clear();
            }
            connection = new Connection(this, uRL);
            this.connectionMap.put(uRL, connection);
        }
        return connection;
    }

    public synchronized Connection getConnection(Transport transport, URL uRL) {
        Connection connection = (Connection)this.connectionMap.get(transport);
        if (connection == null) {
            URL uRL2 = uRL;
            if (uRL2 == null) {
                try {
                    uRL2 = new URL(transport.getUrl());
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = null;
                }
            }
            if (uRL2 != null) {
                connection = (Connection)this.connectionMap.get(uRL2);
            }
            if (connection == null) {
                if (this.connectionMap.size() >= 25) {
                    this.connectionMap.clear();
                }
                connection = new Connection(this, transport, uRL2);
                this.connectionMap.put(transport, connection);
                if (uRL2 != null) {
                    this.connectionMap.put(uRL2, connection);
                }
            }
        }
        return connection;
    }

    public void setServiceRefName(String string) {
        this.serviceRefName = string;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setPortTypeToPortMapping(Map map) {
        this.portTypeToPortMapping = map;
    }

    public Map getPortTypeToPortMapping() {
        return this.portTypeToPortMapping;
    }

    public void setSEIToPortTypeMapping(Map map) {
        this.seiToPortTypeMapping = map;
    }

    public Map getSEIToPortTypeMapping() {
        return this.seiToPortTypeMapping;
    }

    public void setOverriddingEndpointURIs(Map map) {
        this.overriddingEndpointURIs = map;
    }

    public Map getOverriddingEndpointURIs() {
        return this.overriddingEndpointURIs;
    }

    public void setWSDLFileName(String string) {
        this.wsdlFileName = string;
    }

    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    private void assertValidPortName_getPort(QName qName) throws ServiceException {
        if (qName == null || qName.getLocalPart().length() == 0) {
            throw new ServiceException(Messages.getMessage((String)"noPort00", (String)("" + qName)));
        }
    }

    private void assertValidProxyInterface_getPort(Class clazz) throws ServiceException {
        if (clazz == null || !clazz.isInterface()) {
            throw new ServiceException(Messages.getMessage((String)"mustBeIface00"));
        }
        if (!Remote.class.isAssignableFrom(clazz)) {
            throw new ServiceException(Messages.getMessage((String)"mustExtendRemote00"));
        }
    }

    private void assertValidEndpoint_getPort(String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException(Messages.getMessage((String)"invEndpointCreateCall00", (String)("" + string)));
        }
    }

    private void assertValidPortName_createCall(QName qName) throws ServiceException {
        if (qName == null || qName.getLocalPart().length() == 0) {
            throw new ServiceException(Messages.getMessage((String)"invPortCreateCall00", (String)("" + qName)));
        }
    }

    private void assertValidOperationName_createCall(QName qName) throws ServiceException {
        if (qName == null || qName.getLocalPart().length() == 0) {
            throw new ServiceException(Messages.getMessage((String)"invOperationCreateCall00", (String)("" + qName)));
        }
    }

    private void assertValidOperationName_createCall(String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException(Messages.getMessage((String)"invOperationCreateCall00", (String)("" + string)));
        }
    }

    public String getWsdlLoadStrategyPath() {
        return this.wsdlLoadStrategyPath;
    }

    public void setWsdlLoadStrategyPath(String string) {
        this.wsdlLoadStrategyPath = string;
    }

    static {
        Protocols.init();
    }

    protected class HandlerRegistryImpl
    implements HandlerRegistry {
        protected HandlerRegistryImpl() {
        }

        private SOAPPort getSOAPPort(QName qName) {
            SOAPPort sOAPPort;
            if (qName == null) {
                return null;
            }
            try {
                sOAPPort = Service.this.getEngine().getPort(qName.getLocalPart());
            }
            catch (WebServicesFault webServicesFault) {
                sOAPPort = null;
            }
            if (sOAPPort == null) {
                sOAPPort = this.registerNewPort(qName);
            }
            if (sOAPPort == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error: Cannot find port: " + qName));
                }
                throw new JAXRPCException(Messages.getMessage((String)"noService01"));
            }
            return sOAPPort;
        }

        private SOAPPort registerNewPort(QName qName) {
            EngineConfiguration engineConfiguration = Service.this.engine.getConfiguration();
            if (engineConfiguration instanceof SimpleEngineConfigurationProvider) {
                ClientSOAPPort clientSOAPPort = new ClientSOAPPort(null, null);
                clientSOAPPort.setName(qName.getLocalPart());
                ((SimpleEngineConfigurationProvider)engineConfiguration).deployPort(clientSOAPPort.getName(), (SOAPPort)clientSOAPPort);
                return clientSOAPPort;
            }
            return null;
        }

        public List getHandlerChain(QName qName) {
            SOAPPort sOAPPort = this.getSOAPPort(qName);
            HandlerChain handlerChain = sOAPPort.getHandlerChain();
            if (handlerChain == null) {
                handlerChain = new SOAPHandlerChain(null, null);
                sOAPPort.setHandlerChain(handlerChain);
            }
            return handlerChain;
        }

        public void setHandlerChain(QName qName, List list) {
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.add("");
            this.getSOAPPort(qName).setHandlerChain((HandlerChain)new SOAPHandlerChain(list, treeSet));
        }
    }
}

