/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpInputStream
extends WSServletInputStream {
    protected InputStream in;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int total;
    protected int limit;
    protected int length;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt.http");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.http.HttpInputStream";
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public HttpInputStream(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "HttpInputStream", "Constructor --> " + size);
        }
        this.buf = new byte[size];
    }

    public HttpInputStream() {
        this(512);
    }

    public void init(InputStream in) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "init");
        }
        this.in = in;
        this.next();
    }

    public void next() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "next", "next");
        }
        this.length = -1;
        this.limit = Integer.MAX_VALUE;
        this.total = 0;
        this.count = 0;
        this.pos = 0;
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "finish", "finish");
        }
        if (!SRTServletResponse.isSkipInputStreamRead() && this.length != -1) {
            int n;
            for (int remaining = this.limit - this.total; remaining > 0; remaining -= n) {
                n = (int)this.skip(remaining);
                if (n != 0) continue;
                throw new IOException(nls.getString("Invalid.Content.Length", "Invalid content length"));
            }
        }
    }

    public void resets() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resets", "resets");
        }
        this.in = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setContentLength(int len) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setContentLength", "setContentLength --> " + len);
        }
        if (len < 0) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setContentLength", "Illegal Argument: Invalid Content Length");
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Content.Length", "Illegal Argument: Invalid Content Length"));
        }
        this.length = len;
        if (Integer.MAX_VALUE - this.total > len) {
            this.limit = this.total + len;
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public int read() throws IOException {
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "read", "Over the limit: -1");
            }
            return -1;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "read", this.pos + " >= " + this.count + " : -1");
                }
                return -1;
            }
        }
        ++this.total;
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] read_buffer, int offset, int length) throws IOException {
        int buf_len;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "read", "read length -->" + length);
        }
        if ((buf_len = this.count - this.pos) > 0) {
            if (buf_len >= length) {
                System.arraycopy(this.buf, this.pos, read_buffer, offset, length);
                this.pos += length;
                this.total += length;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "read", "read returning -->" + length);
                }
                return length;
            }
            System.arraycopy(this.buf, this.pos, read_buffer, offset, buf_len);
            this.pos = 0;
            this.count = 0;
            offset += buf_len;
            length -= buf_len;
        }
        int bytes_read = buf_len;
        int rtn = 0;
        if (length > 0) {
            rtn = this.in.read(read_buffer, offset, length);
        }
        if (rtn > 0) {
            bytes_read += rtn;
        }
        this.total += bytes_read;
        if (bytes_read == 0) {
            bytes_read = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "read", "read returning -->" + bytes_read);
        }
        return bytes_read;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "readLine", "readLine");
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "readLine", "readLine Over the limit: -1");
            }
            return -1;
        }
        int remain = 0;
        remain = len;
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "readLine", "readLine avail less than 0: -1");
                }
                return -1;
            }
        }
        int readlen = avail < len ? avail : len;
        int newlen = HttpInputStream.copyLine(this.buf, this.pos, b, off, readlen);
        this.pos += newlen;
        this.total += newlen;
        remain -= newlen;
        int totalread = newlen;
        if (totalread == 0) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "readLine", "readLine totalRead is 0: -1");
            }
            return -1;
        }
        while (remain > 0 && b[off + totalread - 1] != 10) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "readLine", "readLine returning --> " + totalread);
                }
                return totalread;
            }
            readlen = avail < remain ? avail : remain;
            newlen = HttpInputStream.copyLine(this.buf, this.pos, b, off + totalread, readlen);
            this.pos += newlen;
            this.total += newlen;
            remain -= newlen;
            totalread += newlen;
        }
        return totalread;
    }

    private static int copyLine(byte[] src, int srcoff, byte[] dst, int dstoff, int len) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "readLine", "copyLine");
        }
        int off = srcoff;
        while (len-- > 0 && src[off++] != 10) {
        }
        System.arraycopy(src, srcoff, dst, dstoff, off - srcoff);
        return off - srcoff;
    }

    public long skip(long n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "skip", "skip");
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "skip", "Total over limit: 0");
            }
            return 0L;
        }
        long remaining = n;
        while (remaining > 0L) {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "skip", "skip avail < 0: " + (n - remaining));
                    }
                    return n - remaining;
                }
            }
            if (remaining < (long)avail) {
                avail = (int)remaining;
            }
            remaining -= (long)avail;
            this.pos += avail;
            this.total += avail;
        }
        return n;
    }

    public int available() throws IOException {
        return Math.min(this.count - this.pos + this.in.available(), this.limit - this.total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "close", "close");
        }
        try {
            this.finish();
        }
        finally {
            this.in.close();
        }
    }

    protected void fill() throws IOException {
        int len;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "fill", "fill");
        }
        if ((len = Math.min(this.buf.length, this.limit - this.total)) > 0 && (len = this.in.read(this.buf, 0, len)) > 0) {
            this.pos = 0;
            this.count = len;
        }
    }
}

