/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.util.JPAJndiLookupInfo;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class JPAJndiLookupObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = JPAJndiLookupObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JPA", null);
    private static final JPAComponent svJPAComponent = JPAAccessor.getJPAComponent();

    public JPAJndiLookupObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>");
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance : " + obj);
        }
        if (!(obj instanceof Reference)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : Reference object not provided : " + obj);
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : Incorrect factory for Reference : " + obj);
            }
            return null;
        }
        RefAddr addr = ref.get("JPAJndiLookupInfo");
        if (addr == null) {
            NullRefAddrException nex = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + nex.getMessage());
            }
            throw nex;
        }
        Object retObj = null;
        JPAJndiLookupInfo info = (JPAJndiLookupInfo)addr.getContent();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getting EntityManagerFactory for " + info);
        }
        JPAPuId puId = info.getPuId();
        J2EEName j2eeName = info.getJ2EEName();
        String refName = info.getReferenceName();
        if (info.isFactory()) {
            retObj = svJPAComponent.getEntityManagerFactory(puId, j2eeName, info.isSFSB());
        } else {
            Map pCtxtProperties = info.getPersistenceProperties();
            retObj = svJPAComponent.getEntityManager(puId, j2eeName, refName, info.isExtendedContextType(), pCtxtProperties);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance : " + retObj);
        }
        return retObj;
    }
}

