/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.traceinfo.ejbcontainer;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.ResRef;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.traceinfo.ejbcontainer.TEInfoConstants;

public class TEBeanMetaDataInfo
implements TEInfoConstants {
    private static final String CLASS_NAME = TEBeanMetaDataInfo.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "TEExplorer", "com.ibm.ws.traceinfo.ejbcontainer");

    private static String turnNullClass2EmptyString(Class cls) {
        return cls == null ? "N/A" : cls.toString();
    }

    private static String turnNullString2EmptyString(String str) {
        return str == null ? "N/A" : str.toString();
    }

    private static void writeMethodInfo(StringBuffer sbuf, EJBMethodInfo[] methodInfos) {
        if (methodInfos == null) {
            sbuf.append("-1").append(">|<");
        } else {
            int size = methodInfos.length;
            sbuf.append("" + size).append(">|<");
            for (int i = 0; i < size; ++i) {
                EJBMethodInfo info = methodInfos[i];
                sbuf.append(i).append(">|<").append(info.getMethodName()).append(">|<").append(info.getJDIMethodSignature()).append(">|<").append(info.getTransactionAttribute().getValue()).append(">|<").append(info.getActivitySessionAttribute().getValue()).append(">|<").append(info.getIsolationLevel()).append(">|<").append(info.getReadOnlyAttribute() ? "true" : "false").append(">|<");
            }
        }
    }

    public static void writeTraceBeanMetaData(BeanMetaData bmd, int dtdVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(">EJCBMD").append(">|<").append(0).append(">|<").append(dtdVersion).append(">|<").append(bmd.j2eeName).append(">|<").append(bmd.simpleJndiBindingName).append(">|<");
            if (bmd.type == 2) {
                sbuf.append("Stateless").append(" Session Bean").append(">|<");
                if (bmd.getEJBTransactionPolicy() == 1) {
                    sbuf.append("BMT").append(">|<");
                } else {
                    sbuf.append("CMT").append(">|<");
                }
                sbuf.append("N/A").append(">|<");
            } else if (bmd.type == 3) {
                sbuf.append("Stateful").append(" Session Bean").append(">|<");
                if (bmd.getEJBTransactionPolicy() == 1) {
                    sbuf.append("BMT").append(">|<");
                } else {
                    sbuf.append("CMT").append(">|<");
                }
                sbuf.append("N/A").append(">|<");
            } else if (bmd.type == 4) {
                sbuf.append("BMP").append(" Entity Bean").append(">|<").append("CMT").append(">|<").append("N/A").append(">|<");
            } else if (bmd.type == 5) {
                sbuf.append("CMP").append(" Entity Bean").append(">|<").append("CMT").append(">|<");
                int cmpV = bmd.getCMPVersion();
                sbuf.append(cmpV).append(".x").append(">|<");
            } else if (bmd.type == 6) {
                sbuf.append("Message Driven Bean").append(">|<");
                if (bmd.getEJBTransactionPolicy() == 1) {
                    sbuf.append("BMT").append(">|<");
                } else {
                    sbuf.append("CMT").append(">|<");
                }
                sbuf.append("N/A").append(">|<");
            }
            sbuf.append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.homeInterfaceClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.remoteInterfaceClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.remoteImplClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.homeRemoteImplClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.localHomeInterfaceClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.localInterfaceClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.localImplClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.homeLocalImplClass)).append(">|<");
            sbuf.append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.homeBeanClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.enterpriseBeanClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.enterpriseBeanAbstractClass)).append(">|<").append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.pKeyClass)).append(">|<").append(bmd.minPoolSize).append(">|<").append(bmd.maxPoolSize).append(">|<").append(bmd.reentrant).append(">|<").append(bmd.sessionTimeout).append(">|<").append(bmd.isPreFindFlushEnabled).append(">|<").append(bmd.optionACommitOption ? "A" : (bmd.optionBCommitOption ? "B" : (bmd.optionCCommitOption ? "C" : "Unknown"))).append(">|<");
            TEBeanMetaDataInfo.writeMethodInfo(sbuf, bmd.methodInfos);
            TEBeanMetaDataInfo.writeMethodInfo(sbuf, bmd.localMethodInfos);
            TEBeanMetaDataInfo.writeMethodInfo(sbuf, bmd.homeMethodInfos);
            TEBeanMetaDataInfo.writeMethodInfo(sbuf, bmd.localHomeMethodInfos);
            ResRefList resRefList = bmd.getResourceRefList();
            int resourcesDefined = resRefList.size();
            sbuf.append(resourcesDefined).append(">|<");
            for (int i = 0; i < resourcesDefined; ++i) {
                ResRef resRef = resRefList.get(i);
                sbuf.append(TEBeanMetaDataInfo.turnNullString2EmptyString(resRef.getName())).append(">|<").append(TEBeanMetaDataInfo.turnNullString2EmptyString(resRef.getDescription())).append(">|<").append(TEBeanMetaDataInfo.turnNullString2EmptyString(resRef.getJNDIName())).append(">|<").append(TEBeanMetaDataInfo.turnNullString2EmptyString(resRef.getType())).append(">|<").append(resRef.getIsolationLevel()).append(">|<").append(resRef.getSharingScope()).append(">|<").append(resRef.getAuth()).append(">|<");
            }
            sbuf.append(dtdVersion >= 21 && bmd.isTimedObject).append(">|<");
            sbuf.append(TEBeanMetaDataInfo.turnNullString2EmptyString(bmd.ivActivationSpecJndiName)).append(">|<").append(TEBeanMetaDataInfo.turnNullString2EmptyString(bmd.ivMessageDestinationJndiName)).append(">|<");
            TEBeanMetaDataInfo.writeMethodInfo(sbuf, bmd.timedMethodInfos);
            TEBeanMetaDataInfo.writeMethodInfo(sbuf, bmd.wsEndpointMethodInfos);
            sbuf.append(TEBeanMetaDataInfo.turnNullClass2EmptyString(bmd.webserviceEndpointInterfaceClass)).append(">|<");
            Tr.debug(tc, sbuf.toString());
        }
    }

    public static boolean isTraceEnabled() {
        return TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    }
}

