/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.wsadmin;

import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.wsadmin.WsProfileAdminService;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ShutdownWSAdminListener
extends Task {
    private String m_sErrorMessage = "";
    private String m_sIPCFilename = null;
    private static final String S_REQUEST_FILE_EXTENSION = ".request";
    private static final String S_FINISHED_FILE_EXTENSION = ".finished";
    private static final String S_MISSING_IPC_FILENAME_PARAMETER = "The IPCFilename parameter is missing.";
    private static final String S_SHUTDOWN_FAILED = "Shutdown of the wsadmin listener could not be verified. If the wsadmin listener process is running, it will timeout, or can be manually stopped.";
    private static final long L_LOCK_RETRY_INTERVAL = 10L;
    private static final int N_DEFAULT_SHUTDOWN_RETRY_COUNT = 300;
    private static final String S_SHUTDOWN_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_SHUTDOWN_LOCK_RETRY_COUNT";
    private static final Logger LOGGER = LoggerFactory.createLogger(ShutdownWSAdminListener.class);
    private static final String S_CLASS_NAME = ShutdownWSAdminListener.class.getName();
    private static int m_nShutdownRetryCount = 300;

    public void init() throws BuildException {
        super.init();
    }

    public void execute() throws BuildException {
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        this.loadTimeouts();
        if (!this.shutdownListener()) {
            throw new BuildException(S_SHUTDOWN_FAILED, this.getLocation());
        }
    }

    public String getIpcFilename() {
        return this.m_sIPCFilename;
    }

    public void setIpcFilename(String ipcFilename) {
        this.m_sIPCFilename = ipcFilename;
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_sIPCFilename == null) {
            this.m_sErrorMessage = S_MISSING_IPC_FILENAME_PARAMETER;
            return false;
        }
        return true;
    }

    private void loadTimeouts() {
        this.log("setting wsadmin requester timeouts");
        m_nShutdownRetryCount = 300;
        try {
            WSProfileProperties wsppProperties = new WSProfileProperties();
            String sShutdownRetryCount = wsppProperties.getProperty(S_SHUTDOWN_RETRY_COUNT_PROPERTY);
            if (sShutdownRetryCount != null) {
                try {
                    m_nShutdownRetryCount = Integer.parseInt(sShutdownRetryCount);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (FileNotFoundException fne) {
            this.log("wasprofile.properties file not found. Default timeouts will be used");
        }
        catch (IOException ioe) {
            this.log("IOException accessing wasprofile.properties file. Default timeouts will be used");
        }
        this.log("wsadmin listener shutdown retry count = " + m_nShutdownRetryCount);
    }

    private boolean shutdownListener() {
        boolean fIsShutdown = false;
        File fileRequest = new File(this.m_sIPCFilename + S_REQUEST_FILE_EXTENSION);
        File fileFinished = new File(this.m_sIPCFilename + S_FINISHED_FILE_EXTENSION);
        try {
            FileLocker flRequest = new FileLocker(this.m_sIPCFilename + S_REQUEST_FILE_EXTENSION);
            this.sendShutdownMessage(fileRequest, flRequest);
            fIsShutdown = this.waitForListenerShutdown(fileFinished);
        }
        catch (IOException e) {
            fIsShutdown = false;
        }
        catch (FileLockerException e) {
            fIsShutdown = false;
        }
        return fIsShutdown;
    }

    private void sendShutdownMessage(File fileRequest, FileLocker flRequest) throws FileLockerException, IOException {
        try {
            flRequest.acquireFileLock(10L, m_nShutdownRetryCount);
            WsProfileAdminService.writeToFile(fileRequest, "Finished Processing");
            flRequest.releaseFileLock();
        }
        catch (FileLockerException fle) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "sendShutdownMessage", "Could not aquire file lock to file: " + fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "sendShutdownMessage", "Received a FileLockerException: " + fle.getMessage());
            LogUtils.logException(LOGGER, fle);
            throw fle;
        }
        catch (IOException ioe) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "sendShutdownMessage", "Could not aquire file lock to file: " + fileRequest.getAbsolutePath() + " As an IOException was encountered.");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "sendShutdownMessage", "Received an IOException: " + ioe.getMessage());
            LogUtils.logException(LOGGER, ioe);
            throw ioe;
        }
    }

    private boolean waitForListenerShutdown(File fileFinished) {
        boolean fIsShutdown = false;
        long retryInterval = 10L;
        int retryCount = m_nShutdownRetryCount;
        for (int i = 0; i < retryCount; ++i) {
            if (fileFinished.exists()) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "waitForListenerShutdown", "wsadmin listener has finished");
                fileFinished.delete();
                fIsShutdown = true;
                break;
            }
            if (i >= retryCount - 1) continue;
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (!fIsShutdown) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "waitForListenerShutdown", "The wsadmin listener may not be stopped.   If the wsadmin listener process is running, it will timeout, or can be manually stopped.");
        }
        return fIsShutdown;
    }
}

