/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.websphere.product.WASDirectory;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.WSWASProfileConstants;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueInSetValidator
extends GenericValidator {
    private static final String S_RELATIVE_DMGR_TEMPLATE_PATH = ".." + File.separator + "dmgr";
    private static final String S_VALUE_NOT_IN_SET_KEY = "ValueInSetValidator.notInSet";
    private static final Logger LOGGER = LoggerFactory.createLogger(ValueInSetValidator.class);
    private static final String S_CLASS_NAME = ValueInSetValidator.class.getName();

    @Override
    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        boolean fExecResult = false;
        String[] saValidServerTypes = new String[]{};
        String sWAS_HOME = SystemPropertiesUtils.getWasInstallLocation();
        if (sWAS_HOME != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "sWAS_HOME=" + sWAS_HOME);
            WASDirectory wasDir = new WASDirectory(sWAS_HOME);
            if (wasDir != null) {
                if (wasDir.getName("EXPRESS") != null || wasDir.getName("BASE") != null || wasDir.getName("NDDMZ") != null) {
                    saValidServerTypes = WSWASProfileConstants.SA_VALID_SERVER_TYPES_BASE_EXP;
                    LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "WAS Edition is EXPRESS, BASE, or NDDMZ");
                } else if (wasDir.getName("ND") != null) {
                    Vector<String> templateStack = SystemPropertiesUtils.getTemplateStackFromSystemProperties();
                    if (this.isDmgrInTemplateStack(templateStack)) {
                        saValidServerTypes = WSWASProfileConstants.SA_VALID_SERVER_TYPES_ND_DMGR;
                        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "Deployment Manager augmenting template is being used");
                    } else {
                        saValidServerTypes = WSWASProfileConstants.SA_VALID_SERVER_TYPES_ND;
                    }
                    LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "WAS Edition is ND");
                }
            } else {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "wasDir is null");
            }
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "sWAS_HOME is null");
        }
        for (int i = 0; i < saValidServerTypes.length; ++i) {
            if (!saValidServerTypes[i].equals(this.sValidatorArgValue)) continue;
            fExecResult = true;
            break;
        }
        if (!fExecResult) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_VALUE_NOT_IN_SET_KEY, WASUtilities.printArrayToString(saValidServerTypes), ResourceBundle.getBundle("com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"));
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.getErrorOutput());
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return fExecResult;
    }

    private boolean isDmgrInTemplateStack(Vector<String> v_sTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "isDmgrInTemplateStack");
        if (v_sTemplateStack != null && !v_sTemplateStack.isEmpty()) {
            String sBaseTemplate = v_sTemplateStack.firstElement();
            File fileDmgrTemplate = FileUtils.getNormalizedPath(new File(sBaseTemplate + File.separator + S_RELATIVE_DMGR_TEMPLATE_PATH));
            Iterator<String> iteratorTemplate = v_sTemplateStack.iterator();
            while (iteratorTemplate.hasNext()) {
                File fileThisTemplate = new File(iteratorTemplate.next());
                if (!fileThisTemplate.equals(fileDmgrTemplate)) continue;
                LOGGER.exiting(S_CLASS_NAME, "isDmgrInTemplateStack");
                return true;
            }
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isDmgrInTemplateStack", "The template stack cannot be fetched from the system properties.");
        }
        LOGGER.exiting(S_CLASS_NAME, "isDmgrInTemplateStack");
        return false;
    }
}

