/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.ConflictingArgsAreNotSetValidator;
import com.ibm.ws.ssl.utils.ProfileKeystoreUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportCertKSAliasValidator
extends ConflictingArgsAreNotSetValidator {
    private final String S_EMPTY = "";
    private final String S_PARAM_NOT_SPECIFIED = "ImportCertKSAliasValidator.requiredParam.notSpecified";
    private final String S_KEY_STORE_ALIAS_KEY_INVALID = "ImportCertKSAliasValidator.invald.alias";
    private String m_sKeyStoreKey;
    private String m_sKeyStoreTypeKey;
    private String m_sKeyStorePasswordKey;
    private static final Logger LOGGER = LoggerFactory.createLogger(ImportCertKSAliasValidator.class);
    private static final String S_CLASS_NAME = ImportCertKSAliasValidator.class.getName();

    public ImportCertKSAliasValidator() {
        if (this.getValidatorArgKey() != null) {
            if (this.getValidatorArgKey().equals("importPersonalCertKSAlias")) {
                this.m_asConflictingArgs = new String[]{"personalCertDN"};
            } else if (this.getValidatorArgKey().equals("importSigningCertKSAlias")) {
                this.m_asConflictingArgs = new String[]{"signingCertDN"};
            }
        }
        this.S_EMPTY = "";
        this.S_PARAM_NOT_SPECIFIED = "ImportCertKSAliasValidator.requiredParam.notSpecified";
        this.S_KEY_STORE_ALIAS_KEY_INVALID = "ImportCertKSAliasValidator.invald.alias";
        this.m_sKeyStoreKey = "";
        this.m_sKeyStoreTypeKey = "";
        this.m_sKeyStorePasswordKey = "";
    }

    public boolean runValidator() {
        boolean result;
        block10: {
            LOGGER.entering(S_CLASS_NAME, "runValidator");
            result = false;
            if (this.sValidatorArgKey.equals("importPersonalCertKSAlias")) {
                this.m_sKeyStoreKey = "importPersonalCertKS";
                this.m_sKeyStoreTypeKey = "importPersonalCertKSType";
                this.m_sKeyStorePasswordKey = "importPersonalCertKSPassword";
            } else if (this.sValidatorArgKey.equals("importSigningCertKSAlias")) {
                this.m_sKeyStoreKey = "importSigningCertKS";
                this.m_sKeyStoreTypeKey = "importSigningCertKSType";
                this.m_sKeyStorePasswordKey = "importSigningCertKSPassword";
            }
            String sKeyStorePath = System.getProperty(this.m_sKeyStoreKey);
            String sKeyStoreType = System.getProperty(this.m_sKeyStoreTypeKey);
            String sKeyStorePassword = System.getProperty(this.m_sKeyStorePasswordKey);
            if (sKeyStorePath == null || sKeyStorePath.equals("")) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.requiredParam.notSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.m_sKeyStoreKey);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                LOGGER.exiting(S_CLASS_NAME, "runValidator");
                return false;
            }
            if (sKeyStoreType == null || sKeyStoreType.equals("")) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.requiredParam.notSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.m_sKeyStoreTypeKey);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                LOGGER.exiting(S_CLASS_NAME, "runValidator");
                return false;
            }
            if (sKeyStorePassword == null || sKeyStorePassword.equals("")) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.requiredParam.notSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.m_sKeyStorePasswordKey);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                LOGGER.exiting(S_CLASS_NAME, "runValidator");
                return false;
            }
            try {
                ArrayList alValidKeyStoreAliases = ProfileKeystoreUtils.getKeyStoreAliases((String)sKeyStoreType, (String)sKeyStorePath, (String)sKeyStorePassword);
                if (this.sValidatorArgValue == null) break block10;
                for (int i = 0; i < alValidKeyStoreAliases.size(); ++i) {
                    if (!this.sValidatorArgValue.equals((String)alValidKeyStoreAliases.get(i))) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception ex) {
                result = false;
            }
        }
        if (!result) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.invald.alias", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return result;
    }
}

