/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class FileValidator
extends GenericValidator {
    private static String S_FILE_NOT_FILE_ERROR_KEY = "FileValidation.error.fileNotAFile";
    private static String S_FILE_DOES_NOT_EXIST_ERROR_KEY = "FileValidation.error.fileDoesNotExist";
    private static String S_FILE_NOT_READABLE_ERROR_KEY = "FileValidation.error.fileNotReadable";
    private static final Logger LOGGER = LoggerFactory.createLogger(FileValidator.class);

    public boolean doIRun() {
        LOGGER.entering(FileValidator.class.getName(), "doIRun");
        this.bDoIRun = false;
        this.bDoIRun = this.getValidatorArgValue() != null && !this.getValidatorArgValue().equals("");
        LOGGER.exiting(FileValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }

    public boolean runValidator() throws Exception {
        LOGGER.entering(FileValidator.class.getName(), "runValidator");
        boolean result = this.isFileValid(this.getValidatorArgValue());
        LOGGER.exiting(FileValidator.class.getName(), "runValidator");
        return result;
    }

    protected boolean isFileValid(String sFilePath) {
        File fFile = new File(sFilePath);
        if (!fFile.isFile()) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_FILE_NOT_FILE_ERROR_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sFilePath);
            return false;
        }
        if (!fFile.exists()) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_FILE_DOES_NOT_EXIST_ERROR_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sFilePath);
            return false;
        }
        if (!fFile.canRead()) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_FILE_NOT_READABLE_ERROR_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sFilePath);
            return false;
        }
        return true;
    }
}

