/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.websphere.product.WASDirectory;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceBundleUtils {
    private static final String S_RESOURCE_BUNDLE_NAME = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
    private static final String S_DOT = ".";
    private static final String[] SA_WAS_IDS = new String[]{"BASE", "EXPRESS", "ND"};
    private static final Logger LOGGER = LoggerFactory.createLogger(ResourceBundleUtils.class);
    private static final String S_CLASS_NAME = ResourceBundleUtils.class.getName();

    public static String getLocaleString(String sKey, String sParam) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(S_RESOURCE_BUNDLE_NAME, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundleWS, sKey);
            return MessageFormat.format(sString, sParam);
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getLocaleString(String sKey, String[] aParam) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(S_RESOURCE_BUNDLE_NAME, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundleWS, sKey);
            return MessageFormat.format(sString, aParam);
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getLocaleString(String sKey) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(S_RESOURCE_BUNDLE_NAME, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundleWS, sKey);
            return sString;
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getResourceBundleLocaleString(String sKey, String sResourceBundle) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(sResourceBundle, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundleWS, sKey);
            return sString;
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getResourceBundleLocaleString(String sKey, ResourceBundle resourcebundle) {
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundle, sKey);
            return sString;
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getResourceBundleLocaleString(String sKey, String[] asParams, ResourceBundle resourcebundle) {
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundle, sKey);
            return MessageFormat.format(sString, asParams);
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getResourceBundleLocaleString(String sKey, String sParam, ResourceBundle resourcebundle) {
        try {
            String sString = ResourceBundleUtils.getEditionSpecificString(resourcebundle, sKey);
            return MessageFormat.format(sString, sParam);
        }
        catch (Throwable e) {
            return sKey;
        }
    }

    public static String getEditionSpecificString(ResourceBundle resourceBundle, String sMessageKey) {
        String sWAS_HOME = SystemPropertiesUtils.getWasInstallLocation();
        String sEditionSpecificText = null;
        String sWAS_ID = null;
        if (sWAS_HOME != null) {
            WASDirectory wasDir = null;
            try {
                wasDir = new WASDirectory(sWAS_HOME);
            }
            catch (Exception e) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getEditionSpecificString", "WASDirectory exception: " + e);
            }
            if (wasDir != null) {
                for (int i = 0; i < SA_WAS_IDS.length; ++i) {
                    if (wasDir.getName(SA_WAS_IDS[i]) == null) continue;
                    sWAS_ID = SA_WAS_IDS[i];
                    break;
                }
                if (sWAS_ID != null) {
                    try {
                        sEditionSpecificText = resourceBundle.getString(sMessageKey + S_DOT + sWAS_ID);
                        return sEditionSpecificText;
                    }
                    catch (Throwable throwEx) {
                        return resourceBundle.getString(sMessageKey);
                    }
                }
            }
        }
        return resourceBundle.getString(sMessageKey);
    }
}

