/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FreePortDetector {
    private static Exception m_e = null;
    private static String m_sLastErrorText = null;
    private static String S_COULD_NOT_BIND = "Could not bind to port: ";

    public static boolean isPortFree(int nPortNumber) {
        try {
            ServerSocket sockToCheck = new ServerSocket(nPortNumber);
            boolean fResult = sockToCheck.isBound();
            sockToCheck.close();
            if (!fResult) {
                m_sLastErrorText = S_COULD_NOT_BIND + nPortNumber;
            } else {
                fResult = FreePortDetector.isPortFreeLocally(nPortNumber);
            }
            return fResult;
        }
        catch (Exception e) {
            m_e = e;
            m_sLastErrorText = e.getMessage();
            return false;
        }
    }

    private static boolean isPortFreeLocally(int nPortNumber) {
        try {
            Socket sockToCheck = new Socket();
            InetSocketAddress sockAddress = new InetSocketAddress(nPortNumber);
            sockToCheck.bind(sockAddress);
            boolean fResult = sockToCheck.isBound();
            sockToCheck.close();
            if (!fResult) {
                m_sLastErrorText = S_COULD_NOT_BIND + nPortNumber;
            }
            return fResult;
        }
        catch (IOException e) {
            m_e = e;
            m_sLastErrorText = e.getMessage();
            return false;
        }
    }

    public static Exception getLastError() {
        return m_e;
    }

    public static String getLastErrorText() {
        return m_sLastErrorText;
    }
}

