/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.utils.WSProfileUtils;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArgumentsUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(CommandLineArgumentsUtils.class);
    private static final String S_CLASS_NAME = CommandLineArgumentsUtils.class.getName();

    public static Hashtable convertCommandLineToHashtable(String[] asArgs) {
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "convertCommandLineToHashtable");
        Hashtable hashtableArguments = new Hashtable();
        if (asArgs.length == 0) {
            return hashtableArguments;
        }
        if (!asArgs[0].startsWith("-")) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convertCommandLineToHashtable", "Invalid incoming command line");
            LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertCommandLineToHashtable");
            return hashtableArguments;
        }
        int nCounter = 0;
        while (nCounter < asArgs.length) {
            String sArgumentKey = asArgs[nCounter].substring("-".length());
            Vector vsArgumentValues = new Vector(CommandLineArgumentsUtils.getArgumentValues(asArgs, nCounter));
            hashtableArguments.put(sArgumentKey, vsArgumentValues);
            nCounter = nCounter + vsArgumentValues.size() + 1;
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertCommandLineToHashtable");
        return hashtableArguments;
    }

    public static Map<String, List> createMapFromArgs(String sMode, String sProfileName, Vector<String> vsTemplatePath) {
        LOGGER.entering(S_CLASS_NAME, "createMapFromArgs");
        Hashtable<String, Vector> htArgsInMap = new Hashtable<String, Vector>();
        Vector<String> vArgValue = new Vector<String>();
        if (sMode != null && !sMode.equals("")) {
            htArgsInMap.put(sMode, (Vector)vArgValue.clone());
            if (sProfileName != null && !sProfileName.equals("")) {
                vArgValue.clear();
                vArgValue.add(sProfileName);
                htArgsInMap.put("profileName", (Vector)vArgValue.clone());
            }
            if (vsTemplatePath != null && vsTemplatePath.size() >= 1) {
                htArgsInMap.put("templatePath", (Vector)vsTemplatePath.clone());
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "createMapFromArgs");
        return new Hashtable<String, List>(htArgsInMap);
    }

    public static Map<String, List> createMapFromArgs(String sMode, String sProfileName) {
        LOGGER.entering(S_CLASS_NAME, "createMapFromArgs");
        Hashtable<String, Vector> htArgsInMap = new Hashtable<String, Vector>();
        Vector<String> vArgValue = new Vector<String>();
        if (sMode != null && !sMode.equals("")) {
            htArgsInMap.put(sMode, (Vector)vArgValue.clone());
            if (sProfileName != null && !sProfileName.equals("")) {
                vArgValue.clear();
                vArgValue.add(sProfileName);
                htArgsInMap.put("profileName", (Vector)vArgValue.clone());
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "createMapFromArgs");
        return new Hashtable<String, List>(htArgsInMap);
    }

    public static Map<String, List> createArgsForAllMode(String sAllMode, String sProfileName, Vector<String> vsTemplatePath, Map<String, List> mapArgs) {
        LOGGER.entering(S_CLASS_NAME, "createArgsForAllMode");
        if (sAllMode.equals("unaugmentAll")) {
            Hashtable mapArgsForAllMode = (Hashtable)CommandLineArgumentsUtils.createMapFromArgs("unaugment", sProfileName, vsTemplatePath);
            mapArgsForAllMode.putAll(mapArgs);
            mapArgsForAllMode.remove("unaugmentAll");
            LOGGER.exiting(S_CLASS_NAME, "createArgsForAllMode");
            return new Hashtable<String, List>(mapArgsForAllMode);
        }
        if (sAllMode.equals("deleteAll")) {
            Hashtable mapArgsForAllMode = (Hashtable)CommandLineArgumentsUtils.createMapFromArgs("delete", sProfileName);
            mapArgsForAllMode.putAll(mapArgs);
            mapArgsForAllMode.remove("deleteAll");
            LOGGER.exiting(S_CLASS_NAME, "createArgsForAllMode");
            return new Hashtable<String, List>(mapArgsForAllMode);
        }
        LOGGER.exiting(S_CLASS_NAME, "createArgsForAllMode");
        return new Hashtable<String, List>();
    }

    public static Vector getArgumentValues(String[] asArgs, int nCounter) {
        String sArgThis;
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "getArgumentValues");
        Vector<String> vsRet = new Vector<String>();
        for (int i = nCounter + 1; i < asArgs.length && (!(sArgThis = asArgs[i]).startsWith("-") || sArgThis.equals("-")); ++i) {
            vsRet.add(sArgThis);
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "getArgumentValues");
        return vsRet;
    }

    public static Vector convertIncomingCommandLineToCommandLineArguments(String[] asArgs) {
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        if (asArgs.length == 0) {
            return new Vector();
        }
        if (!asArgs[0].startsWith("-")) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convertIncomingCommandLineToCommandLineArguments", "Invalid incoming command line");
            LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
            return new Vector();
        }
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>();
        int nCounter = 0;
        while (nCounter < asArgs.length) {
            String sArgumentKey = asArgs[nCounter].substring("-".length());
            Vector vsArgumentValues = CommandLineArgumentsUtils.getArgumentValues(asArgs, nCounter);
            vclaRet.add(new CommandLineArgument(sArgumentKey, vsArgumentValues));
            nCounter = nCounter + vsArgumentValues.size() + 1;
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return vclaRet;
    }

    public static Vector convertIncomingCommandLineToCommandLineArguments(Map<String, List> map) {
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        if (map.size() == 0) {
            return new Vector();
        }
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>();
        for (String sArgumentKey : map.keySet()) {
            Vector vsArgumentValues = (Vector)map.get(sArgumentKey);
            vclaRet.add(new CommandLineArgument(sArgumentKey, vsArgumentValues));
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return vclaRet;
    }

    public static String[] replaceArgValue(String sArgKey, String[] saArgs, String sArgValue) {
        LOGGER.entering(S_CLASS_NAME, "replaceArgValues");
        LOGGER.exiting(S_CLASS_NAME, "replaceArgValues");
        return CommandLineArgumentsUtils.replaceArgValues(sArgKey, saArgs, new String[]{sArgValue});
    }

    public static String[] replaceArgValues(String sArgKey, String[] saArgs, String[] saArgValues) {
        LOGGER.entering(S_CLASS_NAME, "replaceArgValues");
        Hashtable m_args = CommandLineArgumentsUtils.convertCommandLineToHashtable(saArgs);
        Vector<String> vArgs = new Vector<String>(Arrays.asList(saArgValues));
        m_args.put(sArgKey, vArgs);
        String[] sa_args = WSProfileUtils.getMapAsStringArray(m_args);
        LOGGER.exiting(S_CLASS_NAME, "replaceArgValues");
        return sa_args;
    }
}

