/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.remote;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.remote.TargetSystem;
import com.ibm.ws.profile.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePathProcessor {
    private static final String S_PATH_SEPARATOR = "/";
    private static Logger LOGGER = LoggerFactory.createLogger(TemplatePathProcessor.class);
    private static String S_CLASS_NAME = TemplatePathProcessor.class.getName();

    public static Map<String, List> translateTemplatePath(Map<String, List> arguments) {
        List paths;
        LOGGER.entering(S_CLASS_NAME, "translateTemplatePath");
        if (arguments.containsKey("templatePath") && (paths = arguments.get("templatePath")).size() >= 1) {
            String path = (String)paths.get(0);
            paths.set(0, TemplatePathProcessor.translateTemplatePath(path));
            arguments.put("templatePath", paths);
        }
        LOGGER.exiting(S_CLASS_NAME, "translateTemplatePath");
        return arguments;
    }

    private static String translateTemplatePath(String localTemplatePath) {
        LOGGER.entering(S_CLASS_NAME, "translateTemplatePath");
        String mTranslatedPath = localTemplatePath;
        try {
            mTranslatedPath = TargetSystem.getInstance().getInstallPath() + S_PATH_SEPARATOR + TemplatePathProcessor.getRelativeTemplatePath(localTemplatePath);
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
        }
        LOGGER.exiting(S_CLASS_NAME, "translateTemplatePath");
        return mTranslatedPath;
    }

    private static String getRelativeTemplatePath(String localTemplatePath) throws IOException {
        LOGGER.entering(S_CLASS_NAME, "getRelativeTemplatePath");
        String sCurrent_WAS_HOME = System.getProperty("WAS_HOME");
        localTemplatePath = FileUtils.getNormalizedPath(localTemplatePath);
        LOGGER.exiting(S_CLASS_NAME, "getRelativeTemplatePath");
        return TemplatePathProcessor.getRelativePath(sCurrent_WAS_HOME, localTemplatePath);
    }

    private static List<String> getPathDirectories(File path) throws IOException {
        LOGGER.entering(S_CLASS_NAME, "getPathDirectories");
        LinkedList<String> directories = new LinkedList<String>();
        for (File r = path.getCanonicalFile(); r != null; r = r.getParentFile()) {
            directories.addFirst(r.getName());
        }
        LOGGER.exiting(S_CLASS_NAME, "getPathDirectories");
        return directories;
    }

    private static String getRelativePath(String homeFile, String nestedFile) throws IOException {
        LOGGER.entering(S_CLASS_NAME, "getRelativePath");
        int directories = TemplatePathProcessor.getPathDirectories(new File(homeFile)).size();
        List<String> a_localTemplatePath = TemplatePathProcessor.getPathDirectories(new File(nestedFile));
        String runtimeTemplateRelativePath = "";
        for (int i = directories; i < a_localTemplatePath.size(); ++i) {
            runtimeTemplateRelativePath = runtimeTemplateRelativePath + a_localTemplatePath.get(i);
            if (i + 1 >= a_localTemplatePath.size()) continue;
            runtimeTemplateRelativePath = runtimeTemplateRelativePath + S_PATH_SEPARATOR;
        }
        LOGGER.exiting(S_CLASS_NAME, "getRelativePath");
        return runtimeTemplateRelativePath;
    }
}

