/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.remote;

import com.ibm.tivoli.remoteaccess.ProgramOutput;
import com.ibm.tivoli.remoteaccess.ProtocolSelector;
import com.ibm.tivoli.remoteaccess.RemoteAccess;
import com.ibm.tivoli.remoteaccess.RemoteAccessAuthException;
import com.ibm.tivoli.remoteaccess.SSHProtocol;
import com.ibm.tivoli.remoteaccess.WindowsProtocol;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RXAClient {
    private static RemoteAccess[] protocols = null;
    private RemoteAccess remoteAccess = null;
    private static final String S_CONNECTED = "RXAClient.connected";
    private static Logger LOGGER = LoggerFactory.createLogger(RXAClient.class);
    private static String S_CLASS_NAME = RXAClient.class.getName();

    public void openConnection(String host, String user, String password) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "openConnection");
        if (protocols == null) {
            protocols = new RemoteAccess[2];
            RXAClient.protocols[0] = new WindowsProtocol(user, password.getBytes(), host);
            RXAClient.protocols[1] = new SSHProtocol(user, password.getBytes(), host);
        }
        try {
            this.remoteAccess = ProtocolSelector.selectProtocol((String)host, (RemoteAccess[])protocols);
        }
        catch (Exception e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "openConnection");
            throw new WSProfileException(e.getMessage());
        }
        if (this.remoteAccess == null) {
            LOGGER.exiting(S_CLASS_NAME, "openConnection");
            throw new WSProfileException("A connection to " + host + " could not be opened.  Verify that the machine has network connectivity, and the username and password specified are valid.");
        }
        try {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "openConnection", "Remote OS: " + this.remoteAccess.getOS().toString());
            this.remoteAccess.beginSession();
        }
        catch (ConnectException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "openConnection");
            throw new WSProfileException(e.getMessage());
        }
        catch (RemoteAccessAuthException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "openConnection");
            throw new WSProfileException(e.getMessage());
        }
        OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_CONNECTED, host));
        LOGGER.exiting(S_CLASS_NAME, "openConnection");
    }

    public void putFile(String clientFile, String serverPath) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "putFile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "putFile", "uploading " + clientFile + " to " + serverPath);
        try {
            this.remoteAccess.mkDirs(serverPath);
            this.remoteAccess.putFile(clientFile, serverPath);
        }
        catch (ConnectException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "putFile");
            throw new WSProfileException(e.getMessage());
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "putFile");
            throw new WSProfileException(e.getMessage());
        }
        LOGGER.exiting(S_CLASS_NAME, "putFile");
    }

    public void getFile(String serverFile, String clientPath) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "getFile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getFile", "downloading " + serverFile + "to" + clientPath);
        try {
            this.remoteAccess.getFile(serverFile, clientPath);
        }
        catch (ConnectException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "getFile");
            throw new WSProfileException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "getFile");
            throw new WSProfileException(e.getMessage());
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "getFile");
            throw new WSProfileException(e.getMessage());
        }
        LOGGER.exiting(S_CLASS_NAME, "getFile");
    }

    public void putFiles(List<String> files, String remotePath) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "putFiles");
        Iterator<String> i = files.iterator();
        while (i.hasNext()) {
            this.putFile(i.next(), remotePath);
        }
        LOGGER.exiting(S_CLASS_NAME, "putFiles");
    }

    public int run(String command) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "run");
        ProgramOutput p = null;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "run", "Running " + command);
        try {
            p = this.remoteAccess.run(command);
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "run");
            throw new WSProfileException(e.getMessage());
        }
        if (p == null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "run", "There is no output from the remote command");
            LOGGER.exiting(S_CLASS_NAME, "run");
            return 1;
        }
        if (p.isTimeoutExpired()) {
            LOGGER.exiting(S_CLASS_NAME, "run");
            throw new WSProfileException("The connection has timed out.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "run", "Return code = ", Integer.toString(p.getReturnCode()));
        if (p.getReturnCode() == -9999) {
            LOGGER.exiting(S_CLASS_NAME, "run");
            throw new WSProfileException("The remote command has failed to run: " + command);
        }
        String stdErr = p.getStderr();
        if (stdErr != null && !stdErr.equals("")) {
            LOGGER.exiting(S_CLASS_NAME, "run");
            throw new WSProfileException(stdErr);
        }
        String stdOut = p.getStdout();
        if (stdOut != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "run", "STDOUT: ", stdOut);
            OutputStreamHandler.println(stdOut);
        }
        LOGGER.exiting(S_CLASS_NAME, "run");
        return p.getReturnCode();
    }

    public void closeConnection() {
        LOGGER.entering(S_CLASS_NAME, "closeConnection");
        this.remoteAccess.endSession();
        LOGGER.exiting(S_CLASS_NAME, "closeConnection");
    }
}

