/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.CurrentEnvironment;
import com.ibm.ws.profile.WSProfileJob;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileJobGeneratorPreProcessorTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(WSProfileJobGeneratorPreProcessorTask.class);
    private static String S_CLASS_NAME = WSProfileJobGeneratorPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() != 0) {
            for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
                WSProfileDataStore.addJobsToStore(WSProfileDataStore.getJobGroup(i).convertJobGroupDataToListOfJobs());
            }
        } else {
            WSProfileDataStore.addJobToStore(new WSProfileJob(WSProfileDataStore.getFlowControllingArgsAsArray()));
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runProcessor", "Number of jobs created: " + WSProfileDataStore.getAllStoredJobs().size());
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() == 0) {
            if (WSProfileDataStore.getFlowControllingArgsAsArray() == null || WSProfileDataStore.getFlowControllingArgsAsArray().length < 1) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
                LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
                return false;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return true;
        }
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
            List<WSProfileTemplate> lwsptTemplateStack = WSProfileDataStore.getJobGroup(i).getTemplateStack();
            boolean fIsTemplatePathRequired = wspclimiFlowControlling.isArgumentRequired("templatePath");
            if (wspclimiFlowControlling != null && mSpecifiedArgs != null && mSpecifiedArgs.size() > 0 && (!fIsTemplatePathRequired || lwsptTemplateStack != null && lwsptTemplateStack.size() > 0)) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        boolean doIRun = true;
        if (WSProfileDataStore.isHelpRequested()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false, help is requested");
            doIRun = false;
        } else if (!CurrentEnvironment.isLocal()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false, environment is not local");
            doIRun = false;
        }
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return doIRun;
    }
}

