/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompleteValidationPreProcessorTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(CompleteValidationPreProcessorTask.class);
    private static String S_CLASS_NAME = CompleteValidationPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        boolean fCurrentValidationResult = true;
        boolean fOverallValidationResult = true;
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            List<WSProfileTemplate> lwsptTemplateStack = WSProfileDataStore.getJobGroup(i).getTemplateStack();
            String sRegistryFilePath = lwsptTemplateStack.get(lwsptTemplateStack.size() - 1).getProfileTemplatePath().getAbsolutePath() + File.separator + wspclimiForExecution.getRegistryName();
            Properties currentProps = SystemPropertiesUtils.getCurrentSystemProperties();
            System.setProperty("WS_CMT_ACTION_REGISTRY", sRegistryFilePath);
            SystemPropertiesUtils.setTemplateStackIntoSystemProperties(lwsptTemplateStack);
            ValidationManagerUtils.resetHastableVMCache();
            fCurrentValidationResult = ValidationManagerUtils.areAllArgumentsValid(wspclimiForExecution.getModeFlag(), mSpecifiedArgs, lwsptTemplateStack);
            SystemPropertiesUtils.resetSystemProperties(currentProps);
            if (!fCurrentValidationResult) {
                WSProfileDataStore.addValidationErrorMessages(ValidationManagerUtils.getAllErrorMessages());
            }
            ValidationManagerUtils.reinitialize();
            fOverallValidationResult &= fCurrentValidationResult;
        }
        if (!fOverallValidationResult) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runProcessor", "Validation Failed");
            Hashtable hashtableValidationError = (Hashtable)WSProfileDataStore.getAllValidationErrorMessages();
            ValidationManagerUtils.printOutValidationResults(hashtableValidationError);
        }
        WSProfileDataStore.setValidationResult(fOverallValidationResult);
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return fOverallValidationResult;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
            List<WSProfileTemplate> lwsptTemplateStack = WSProfileDataStore.getJobGroup(i).getTemplateStack();
            if (wspclimiForExecution != null && mSpecifiedArgs != null && mSpecifiedArgs.size() > 0 && lwsptTemplateStack != null && lwsptTemplateStack.size() > 0) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() <= 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            if (wspclimiForExecution == null || wspclimiForExecution.getRegistryName() == null || !wspclimiForExecution.isValidationAllowed()) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + !WSProfileDataStore.isHelpRequested());
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return !WSProfileDataStore.isHelpRequested();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }
}

