/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FindNodeCellNamesUtil {
    private String m_sPath = "";
    private String m_sNodeNameFound = null;
    private String m_sCellNameFound = null;
    private static final String S_BIN = "bin";
    private static final String S_SETUPCMDLINE_BAT = "setupCmdLine.bat";
    private static final String S_SETUPCMDLINE_SH = "setupCmdLine.sh";
    private static final String S_WAS_CELL = "WAS_CELL";
    private static final String S_WAS_NODE = "WAS_NODE";
    private static final Logger LOGGER = LoggerFactory.createLogger(FindNodeCellNamesUtil.class);

    public FindNodeCellNamesUtil(String path) {
        try {
            this.m_sPath = new File(path).getCanonicalPath();
            this.findNodeNamesCellNamesForInstallLocation(this.m_sPath);
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
    }

    public String getNodeNameFound() {
        return this.m_sNodeNameFound;
    }

    public void setNodeNameFound(String sNodeNameFound) {
        this.m_sNodeNameFound = sNodeNameFound;
    }

    public String getCellNameFound() {
        return this.m_sCellNameFound;
    }

    public void setCellNameFound(String sCellNameFound) {
        this.m_sCellNameFound = sCellNameFound;
    }

    private void findNodeNamesCellNamesForInstallLocation(String installLocation) {
        if (installLocation == null) {
            return;
        }
        if (!installLocation.endsWith(File.separator)) {
            installLocation = installLocation + File.separator;
        }
        String S_OS_NAME = System.getProperty("os.name");
        String binDir = new File(installLocation).getAbsolutePath() + File.separator + S_BIN;
        File batFile = new File(binDir + File.separator + S_SETUPCMDLINE_BAT);
        File shFile = new File(binDir + File.separator + S_SETUPCMDLINE_SH);
        File setupCmdLineFile = null;
        setupCmdLineFile = batFile.exists() && !shFile.exists() ? batFile : (!batFile.exists() && shFile.exists() ? shFile : (S_OS_NAME.toLowerCase().indexOf("win") >= 0 ? batFile : shFile));
        try {
            String line;
            FileReader fileReader = new FileReader(setupCmdLineFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean cellNameFound = false;
            boolean nodeNameFound = false;
            while (!((line = bufferedReader.readLine()) == null || cellNameFound && nodeNameFound)) {
                StringTokenizer token = new StringTokenizer(line);
                while (token.hasMoreTokens()) {
                    String nextToken = token.nextToken();
                    if (nextToken.startsWith(S_WAS_NODE)) {
                        this.m_sNodeNameFound = nextToken.substring(S_WAS_NODE.length() + 1);
                        nodeNameFound = true;
                        continue;
                    }
                    if (!nextToken.startsWith(S_WAS_CELL)) continue;
                    this.m_sCellNameFound = nextToken.substring(S_WAS_CELL.length() + 1);
                    cellNameFound = true;
                }
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
    }
}

