/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.WSProfileContext;
import com.ibm.ws.profile.defaulters.FindNodeCellNamesUtil;
import com.ibm.ws.profile.defaulters.UniqueTokenCreatorDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CellNameDefaulter
extends UniqueTokenCreatorDefaulter {
    public static final String S_WSPROFILE_DEFAULTERS_CELL_NAME_OS400_TAIL = "WSProfile.Defaulters.cellNameTail.os400.";
    private static final Logger LOGGER = LoggerFactory.createLogger(CellNameDefaulter.class);
    private static final String S_CLASS_NAME = CellNameDefaulter.class.getName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runDefaulter() throws Exception {
        boolean result;
        block25: {
            String hostName;
            String templateType;
            block26: {
                block27: {
                    LOGGER.entering(CellNameDefaulter.class.getName(), "runDefaulter");
                    result = false;
                    String templatePath = System.getProperty("templatePath");
                    templateType = "";
                    WSProfileTemplate template = new WSProfileTemplate(new File(templatePath));
                    templateType = template.getType();
                    hostName = System.getProperty("hostName");
                    if (hostName == null) {
                        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "hostName was not set in the system properties, will use an empty string");
                        hostName = "";
                    } else {
                        hostName = WASUtilities.getShortHostName(hostName);
                    }
                    if (PlatformConstants.isCurrentPlatformOS400()) {
                        String sProfileName = System.getProperty("profileName");
                        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "using os400 defaulter");
                        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "profileName set to [" + sProfileName + "] in system properties");
                        if (templateType.equals("cell.dmgr") || templateType.equals("dmgr")) {
                            this.sDefaultedValue = sProfileName + ResourceBundleUtils.getResourceBundleLocaleString(S_WSPROFILE_DEFAULTERS_CELL_NAME_OS400_TAIL + templateType, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle");
                            return true;
                        }
                        if (hostName.equals("LOOPBACK")) {
                            this.sDefaultedValue = "LOCAL_" + sProfileName;
                            return true;
                        }
                        this.sDefaultedValue = hostName + "_" + sProfileName;
                        return true;
                    }
                    if (!templateType.equals("management")) break block26;
                    String sServerType = System.getProperty("serverType");
                    if (sServerType == null || sServerType.equals("")) break block27;
                    if (sServerType.equals("ADMIN_AGENT")) {
                        this.setSeed(hostName + "AACell");
                        break block25;
                    } else if (sServerType.equals("DEPLOYMENT_MANAGER")) {
                        this.setSeed(hostName + "Cell");
                        break block25;
                    } else {
                        if (!sServerType.equals("JOB_MANAGER")) {
                            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType=" + sServerType + " has been specified incorrectly.");
                            return false;
                        }
                        this.setSeed(hostName + "JobMgrCell");
                    }
                    break block25;
                }
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType has not been specified.");
                return false;
            }
            this.setSeed(hostName + ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.cellNameSeed." + templateType, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "runDefaulter", "set seed key value:" + this.getSeed());
            this.setTail(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.cellNameTail." + templateType, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "runDefaulter", "set tail key value:" + this.getTail());
        }
        String existingTokens = "";
        LinkedList<String> profileLocationList = new LinkedList<String>();
        String sCurrent_WAS_HOME = System.getProperty("WAS_HOME");
        WSProfileContext currentContext = new WSProfileContext();
        currentContext.saveCurrentContext();
        WASSystem wasSystem = WASSystem.getWASSystemInstance();
        String[] saWASLocations = wasSystem.getNonCachedWASLocations();
        if (saWASLocations.length > 1) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "Located the following WAS home(s): " + StringUtils.convertStringArrayToCommaSeparatedString(saWASLocations));
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "No other WAS home directories have been found");
        }
        for (int wasInstall = 0; wasInstall < saWASLocations.length; ++wasInstall) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "Scanning WAS location:" + saWASLocations[wasInstall]);
            try {
                int i;
                currentContext.switchContext(saWASLocations[wasInstall]);
                List profileNameList = WSProfile.listProfileNames();
                for (i = 0; i < profileNameList.size(); ++i) {
                    profileLocationList.add(WSProfile.getProfileLocation("" + profileNameList.get(i)).getAbsolutePath());
                }
                if (profileLocationList != null) {
                    for (i = 0; i < profileLocationList.size(); ++i) {
                        String name = (String)profileLocationList.get(i);
                        FindNodeCellNamesUtil cellName = new FindNodeCellNamesUtil(name);
                        existingTokens = CellNameDefaulter.addToken(existingTokens, this.getTokensSeparator(), cellName.getCellNameFound());
                    }
                }
            }
            catch (Exception e) {
                try {
                    sCurrent_WAS_HOME = new File(sCurrent_WAS_HOME).getCanonicalPath();
                }
                catch (IOException e1) {
                    sCurrent_WAS_HOME = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Problems occurred when retrieving reference to current install.  Exception follows.");
                    LogUtils.logException(LOGGER, e1);
                    throw e;
                }
                String s_Install_under_review = null;
                try {
                    s_Install_under_review = new File(saWASLocations[wasInstall]).getCanonicalPath();
                }
                catch (IOException e1) {
                    s_Install_under_review = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Problems occurred when retrieving reference to the WAS install:" + saWASLocations[wasInstall]);
                    LogUtils.logException(LOGGER, e1);
                }
                if (sCurrent_WAS_HOME != null && s_Install_under_review != null) {
                    if (sCurrent_WAS_HOME.equals(s_Install_under_review)) {
                        LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "There are problems with the current install: " + saWASLocations[wasInstall]);
                        LogUtils.logException(LOGGER, e);
                        throw e;
                    }
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Ignoring incomplete installation: " + saWASLocations[wasInstall]);
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Ignoring incomplete installation: " + saWASLocations[wasInstall]);
            }
            profileLocationList = new LinkedList();
        }
        currentContext.restoreSavedContext();
        this.setExistingTokens(existingTokens);
        result = this.generateSuggestion();
        if (result) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        }
        LOGGER.exiting(CellNameDefaulter.class.getName(), "runDefaulter");
        return result;
    }

    public boolean runDefaulterDisconnected() {
        this.sDefaultedValue = "";
        return true;
    }
}

