/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIGetProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLISetDefaultProfileNameInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("setDefaultName", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIGetProfileNameInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLISetDefaultProfileNameInvoker.class.getName();
    private static final String S_REGISTRY_CORRUPT = "WSProfile.WSProfileCLISetDefaultProfileNameInvoker.registryCorrupt";

    public WSProfileCLISetDefaultProfileNameInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLISetDefaultProfileNameInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLISetDefaultProfileNameInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLISetDefaultProfileNameInvoker.failureMessage";
    }

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "setDefaultName";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        int nReturnCode = 0;
        String sProfileName = this.getArgumentValue("profileName");
        try {
            WSProfile.setDefaultProfile(sProfileName);
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    public boolean isPublicMode() {
        return this.fIsPublic;
    }
}

