/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIRestoreProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("restoreProfile", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("backupFile", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[0];
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIRestoreProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIRestoreProfileInvoker.class.getName();

    public WSProfileCLIRestoreProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIRestoreProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIRestoreProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIRestoreProfileInvoker.failureMessage";
    }

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        return "restoreProfile";
    }

    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return false;
    }

    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return true;
    }

    public boolean isPublicMode() {
        LOGGER.entering(this.getClass().getName(), "isPublicMode");
        LOGGER.exiting(this.getClass().getName(), "isPublicMode");
        return this.fIsPublic;
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sIncomingBackupFileArg = this.getArgumentValue("backupFile");
        int nReturnCode = 1;
        try {
            nReturnCode = WSProfile.restore(new File(sIncomingBackupFileArg), CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()));
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        if (sIncomingProfileTemplatePath != null) {
            Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
            System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sIncomingProfileTemplatePath, "restoreRegistry.xml").getAbsolutePath());
            List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(sIncomingProfileTemplatePath));
            vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
            this.resetJavaSystemProperties(propertiesCurrentSystem);
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        if (sIncomingProfileTemplatePath != null) {
            Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
            System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sIncomingProfileTemplatePath, "restoreRegistry.xml").getAbsolutePath());
            List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(sIncomingProfileTemplatePath));
            vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
            this.resetJavaSystemProperties(propertiesCurrentSystem);
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArgumetns");
        return vclaRet;
    }

    public String getRegistryName() {
        return "restoreRegistry.xml";
    }
}

