/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLIListAugmentsInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("listAugments", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_NEW_LINE = "\n";
    private static final String S_TAB = "\t";
    private static final String S_NO_REG_AUGMENTS_ARG = "WSProfile.WSProfileCLIListAugmentsInvoker.noRegisteredAugments";
    private static final String S_LIST_AUGMENTS_LABEL_ARG = "listAugments.label";
    private static final String S_REGISTRY_CORRUPT = "WSProfile.WSProfileCLIListAugmentsInvoker.registryCorrupt";
    private static final String S_CLASS_NAME = WSProfileCLIListAugmentsInvoker.class.getName();
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIListAugmentsInvoker.class);

    @Override
    public String getModeFlag() {
        LOGGER.entering(S_CLASS_NAME, "getModeFlag");
        LOGGER.exiting(S_CLASS_NAME, "getModeFlag");
        return "listAugments";
    }

    @Override
    public void printOutExecutionResult(int nReturnCode, Map<String, List> mapArgs) {
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }

    @Override
    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(S_CLASS_NAME, "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        int nReturnCode = 0;
        try {
            OutputStreamHandler.println("augmentList", this.getAugmentDisplay(WSProfile.listAugments(sProfileName, this.getProfileRegistryPath())));
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(S_CLASS_NAME, "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(S_CLASS_NAME, "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(S_CLASS_NAME, "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    private String getAugmentDisplay(List l_augments) {
        String sReturnDisplay = new String();
        if (l_augments == null || l_augments.size() == 0) {
            sReturnDisplay = ResourceBundleUtils.getLocaleString(S_NO_REG_AUGMENTS_ARG);
        } else {
            sReturnDisplay = ResourceBundleUtils.getLocaleString(S_LIST_AUGMENTS_LABEL_ARG);
            for (String thisAugment : l_augments) {
                sReturnDisplay = sReturnDisplay + "\n\t" + thisAugment;
            }
        }
        return sReturnDisplay;
    }
}

