/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIEditProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = false;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("edit", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("setIsDefault", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("setProfileName", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIEditProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIEditProfileInvoker.class.getName();

    public WSProfileCLIEditProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIEditProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIEditProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIEditProfileInvoker.failureMessage";
    }

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "edit";
    }

    public boolean isPublicMode() {
        return this.fIsPublic;
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        Map mapOptionalArgMap = CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments());
        int nReturnCode = 1;
        try {
            if (mapOptionalArgMap.containsKey("setIsDefault")) {
                WSProfile.setDefaultProfile(sProfileName);
            }
            if (mapOptionalArgMap.containsKey("setProfileName")) {
                String newProfileName = this.getArgumentValue("setProfileName");
                WSProfile.setProfileName(sProfileName, newProfileName);
                sProfileName = newProfileName;
            }
            nReturnCode = WSProfile.edit(sProfileName, mapOptionalArgMap, this.getProfileRegistryPath());
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        if (sProfileName != null) {
            try {
                String sTemplatePath = WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getWSProfileTemplate().getProfileTemplatePath().getAbsolutePath();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "editRegistry.xml").getAbsolutePath());
                List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(sTemplatePath));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        if (sProfileName != null) {
            try {
                String sTemplatePath = WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getWSProfileTemplate().getProfileTemplatePath().getPath();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "editRegistry.xml").getAbsolutePath());
                List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(sTemplatePath));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArgumetns");
        return vclaRet;
    }
}

