/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZIPAntTask
extends Task {
    private File m_sDir = null;
    private Vector<File> m_vfilesToExclude = null;
    private File m_sFile = null;
    private String m_sNativeFileLibDirectory = null;
    private String m_sErrorMessage = new String();
    private static final String S_NO_DIR = "Missing dir property";
    private static final String S_NO_FILE = "Missing file property";
    private static final String S_NOT_WRITABLE = "Insufficient permissions to write to dir";
    private static final int N_IO_BUFFER_SIZE = 4096;
    private static final String S_NATIVE_FILE_LIB_DIRECTORY = "com.ibm.io.file.nativefile.libdir";
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_COMMA = ",";
    private static final char CHAR_FORWARD_SLASH = '/';
    private static final Logger LOGGER = LoggerFactory.createLogger(ZIPAntTask.class);
    private static final String S_CLASS_NAME = ZIPAntTask.class.getName();

    @Override
    public void init() throws BuildException {
        super.init();
        this.m_sDir = null;
        this.m_sFile = null;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        try {
            this.zipThisDirectoryToThisZIPFile(this.m_sDir, this.m_sFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException(e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException(e, this.getLocation());
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", " dir: " + this.m_sDir + " ... file: " + this.m_sFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", e.getMessage());
            throw new BuildException(e, this.getLocation());
        }
    }

    public void setDir(File sDir) {
        this.m_sDir = sDir;
    }

    public void setFile(File sFile) {
        this.m_sFile = sFile;
    }

    public void setNativeFileLibDirectory(String sNativeFileLibDirectory) {
        this.m_sNativeFileLibDirectory = sNativeFileLibDirectory;
    }

    public void setFilesToExclude(String sFilesToExclude) {
        this.m_vfilesToExclude = new Vector();
        StringTokenizer st = new StringTokenizer(sFilesToExclude, S_COMMA);
        while (st.hasMoreTokens()) {
            this.m_vfilesToExclude.add(new File(st.nextToken().trim()));
        }
    }

    private void zipThisDirectoryToThisZIPFile(File fileDirToZip, File fileZIP) throws IOException, FileNotFoundException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fileZIP)));
        Vector<File> vfileFilesToZip = this.getFilesInDirectoryRecursive(fileDirToZip);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "Backing up to file: " + fileZIP.getAbsolutePath());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", " Number of files to be zipped is: " + vfileFilesToZip.size());
        for (int i = 0; i < vfileFilesToZip.size(); ++i) {
            File fileToZipThis = vfileFilesToZip.elementAt(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "fileToZip: " + fileToZipThis);
            if (this.m_vfilesToExclude.contains(fileToZipThis)) continue;
            String sThisEntryName = fileToZipThis.getAbsolutePath().substring(fileDirToZip.getAbsolutePath().length() + 1);
            String sThisEntryPermissions = this.getPermissions(fileToZipThis);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "sThisEntryName: " + sThisEntryName);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "sThisEntryPermissions: " + sThisEntryPermissions);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "getBytes: " + sThisEntryPermissions.getBytes(S_UTF_8));
            ZipEntry zipentryThis = new ZipEntry(sThisEntryName.replace(File.separatorChar, '/'));
            zipentryThis.setExtra(sThisEntryPermissions.getBytes(S_UTF_8));
            out.putNextEntry(zipentryThis);
            if (fileToZipThis.isDirectory()) continue;
            FileInputStream in = new FileInputStream(fileToZipThis);
            this.transferInputStreamToOutputStreamCompletely(in, out);
            in.close();
        }
        out.close();
    }

    private String getPermissions(File filePath) throws BuildException {
        try {
            String JNILocation = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(JNILocation), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getPermissions", "NativeFile functionality is not available");
                throw new BuildException();
            }
            NativeFile NativeFileThis = new NativeFile(filePath.getAbsolutePath());
            String sPermissions = Integer.toString(NativeFileThis.getUserPermissions());
            sPermissions = sPermissions + Integer.toString(NativeFileThis.getGroupPermissions());
            sPermissions = sPermissions + Integer.toString(NativeFileThis.getWorldPermissions());
            return sPermissions;
        }
        catch (NativeFileIOException e) {
            throw new BuildException(e);
        }
        catch (Exception e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getPermissions", "Exception caught while getting file permissions!");
            throw new BuildException(e);
        }
    }

    private void transferInputStreamToOutputStreamCompletely(InputStream inputstreamThis, OutputStream outputstreamThis) throws IOException {
        byte[] abBuffer = new byte[4096];
        int nBytesRead = inputstreamThis.read(abBuffer);
        while (nBytesRead != -1) {
            outputstreamThis.write(abBuffer, 0, nBytesRead);
            nBytesRead = inputstreamThis.read(abBuffer);
        }
    }

    private Vector<File> getFilesInDirectoryRecursive(File fileDir) {
        File[] afiles = fileDir.listFiles();
        Vector<File> vfilesReturn = new Vector<File>();
        for (int i = 0; i < afiles.length; ++i) {
            if (afiles[i].isDirectory()) {
                vfilesReturn.add(new File(afiles[i], "/"));
                vfilesReturn.addAll(this.getFilesInDirectoryRecursive(afiles[i]));
                continue;
            }
            vfilesReturn.add(afiles[i]);
        }
        return vfilesReturn;
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_sDir == null) {
            this.m_sErrorMessage = S_NO_DIR;
            return false;
        }
        if (this.m_sFile == null) {
            this.m_sErrorMessage = S_NO_FILE;
            return false;
        }
        if (!this.isWritable(this.m_sFile.getParentFile())) {
            this.m_sErrorMessage = S_NOT_WRITABLE;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Insufficient permissions to write to dir:" + this.m_sFile.getParent());
            return false;
        }
        return true;
    }

    private boolean isWritable(File dir) {
        File temp = new File(dir.getAbsolutePath() + File.separator + "tmp");
        boolean wasWritten = false;
        try {
            wasWritten = temp.createNewFile();
            if (wasWritten) {
                temp.delete();
            }
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWritable", " dir: " + this.m_sDir + " ... file: " + this.m_sFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWritable", e.getMessage());
        }
        return wasWritten;
    }
}

