/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.AccessDeniedException;
import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UNZIPAntTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.createLogger(UNZIPAntTask.class);
    private static final String S_CLASS_NAME = UNZIPAntTask.class.getName();
    private static final String S_FILE_INVALID = "The specified file is invalid: ";
    private static final String S_FILE_PARM_NOT_FOUND = "The specified file parameter is not found.";
    private static final String S_OUTPUT_DIR_PARM_NOT_FOUND = "The specified output directory parameter is not found.";
    private static final String S_NATIVE_FILE_LIB_DIRECTORY = "com.ibm.io.file.nativefile.libdir";
    private static final String S_UTF_8 = "UTF-8";
    public static final int BUFFER_SIZE = 1024;
    private File m_fileZipFile = null;
    private File m_fileOutputDir = null;
    private File m_fileNativeFileLibDirectory = null;
    private String m_sErrorMessage = new String();
    private byte[] buffer = new byte[1024];

    public void init() throws BuildException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "init");
        super.init();
        this.m_fileOutputDir = null;
        this.m_fileZipFile = null;
        this.m_fileNativeFileLibDirectory = null;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Parameter validation failed!");
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Parameter validation passed.");
        try {
            this.unzipToThisDirectory(this.m_fileZipFile, this.m_fileOutputDir);
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", e.getMessage());
            throw new BuildException(e, this.getLocation());
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", e.getMessage());
            throw new BuildException(e, this.getLocation());
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", " Output directory: " + this.m_fileOutputDir + " - Zip file: " + this.m_fileZipFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", e.getMessage());
            throw new BuildException(e, this.getLocation());
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "execute");
    }

    public void setFile(File fileZip) {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setFile");
        this.m_fileZipFile = fileZip;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setFile");
    }

    public void setOutputDir(File fileOutputDir) {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setOutputDir");
        this.m_fileOutputDir = fileOutputDir;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setOutputDir");
    }

    public void setNativeFileLibDirectory(File fileNativeFileLibDir) {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setNativeFileLibDirectory");
        this.m_fileNativeFileLibDirectory = fileNativeFileLibDir;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setNativeFileLibDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipToThisDirectory(File fileZipFile, File fileOutputDirectory) throws IOException, FileNotFoundException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
        ZipFile zipper = new ZipFile(fileZipFile);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipper.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntryThis = enumeration.nextElement();
                this.unzipEntry(zipEntryThis, zipper);
                String sPermissions = new String(zipEntryThis.getExtra(), S_UTF_8);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unzipToThisDirectory", "The permission from the zip entry is " + sPermissions);
                this.setPermissions(new File(this.m_fileOutputDir, zipEntryThis.getName()), sPermissions);
            }
        }
        finally {
            zipper.close();
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipEntry(ZipEntry zipEntry, ZipFile zipper) throws IOException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
        InputStream is = zipper.getInputStream(zipEntry);
        File newFile = new File(this.m_fileOutputDir, zipEntry.getName());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "unzipEntry", "Performing mkdir: Creating parent directories.");
        newFile.getParentFile().mkdirs();
        if (zipEntry.isDirectory()) {
            newFile.mkdir();
            LOGGER.exiting(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
            return;
        }
        FileOutputStream fos = new FileOutputStream(newFile);
        try {
            int numBytes = 0;
            while ((numBytes = is.read(this.buffer)) > -1) {
                fos.write(this.buffer, 0, numBytes);
            }
        }
        finally {
            fos.close();
            is.close();
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
    }

    private void setPermissions(File fileThis, String sPermissions) throws BuildException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setPermissions");
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - file name: " + fileThis.toString());
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - permissions: " + sPermissions);
        try {
            String JNILocation = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(JNILocation), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "NativeFile functionality is not available...Proceeding without proper permissions support.....");
            }
            NativeFile nativeFileThis = new NativeFile(fileThis.getAbsolutePath());
            char[] cArray = sPermissions.toCharArray();
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - permissions as character array: " + String.valueOf(cArray));
            nativeFileThis.setUserPermissions(Character.getNumericValue(cArray[0]));
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - user : " + nativeFileThis.getUserPermissions());
            nativeFileThis.setGroupPermissions(Character.getNumericValue(cArray[1]));
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - group : " + nativeFileThis.getGroupPermissions());
            nativeFileThis.setWorldPermissions(Character.getNumericValue(cArray[2]));
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - world : " + nativeFileThis.getWorldPermissions());
        }
        catch (AccessDeniedException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "Access denied: " + fileThis);
            throw new BuildException(e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "File not found: " + fileThis);
            throw new BuildException(e.getMessage(), e);
        }
        catch (NativeFileIOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "IO exception: " + fileThis);
            throw new BuildException(e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "IO exception: " + fileThis);
            throw new BuildException(e.getMessage(), e);
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setPermissions");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_fileZipFile == null) {
            this.m_sErrorMessage = S_FILE_PARM_NOT_FOUND;
            LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_fileOutputDir == null) {
            this.m_sErrorMessage = S_OUTPUT_DIR_PARM_NOT_FOUND;
            LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (!this.m_fileZipFile.isFile()) {
            this.m_sErrorMessage = S_FILE_INVALID + this.m_fileZipFile.getPath();
            LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

