/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws390.utility.ws390uuid;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateUUIDAnt
extends Task {
    private boolean verbose = false;
    private String pathname = null;
    private File file = null;
    private static final String ENCODING = "ISO8859_1";
    private static final String EYE_CATCHER = "ISHOULDINSERTUUIDHERE";
    private static final int EYE_CATCHER_LENGTH = "ISHOULDINSERTUUIDHERE".length();
    private static Hashtable<String, ws390uuid> keyTable = new Hashtable(11);

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.println("Setting verbose to TRUE");
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.println("Setting pathname to " + pathname);
    }

    public void execute() throws BuildException {
        System.out.println("Creating UUID for file: " + this.pathname);
        this.println("entering execute");
        try {
            this.validatePathname();
            this.findAndReplace();
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            throw new BuildException(t);
        }
        this.println("exiting execute");
    }

    private void validatePathname() throws Exception {
        this.println("Validating pathname: " + this.pathname);
        if (this.pathname == null) {
            throw new Exception("ERROR - pathname not specified");
        }
        this.file = new File(this.pathname);
        if (!this.file.exists() || !this.file.isFile()) {
            throw new Exception("ERROR - File " + this.file + " is not a valid file.");
        }
        this.println("Done validating pathname");
    }

    private void findAndReplace() throws Exception {
        Vector<String> outputVector = new Vector<String>(60, 20);
        boolean change = false;
        this.println("Find And Replace for file: " + this.file);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.file), ENCODING);
        BufferedReader in = new BufferedReader(isr);
        String line = "";
        while ((line = in.readLine()) != null) {
            if (line.indexOf(EYE_CATCHER) != -1) {
                change = true;
                String uuid = this.generateUUID(line);
                this.println("Found Eye Catcher in: " + line);
                line = this.replace(line, uuid);
            }
            this.println("adding line to output: " + line);
            outputVector.add(line);
            this.println(String.valueOf(outputVector.size()));
        }
        this.println("Done replacing.");
        in.close();
        if (change) {
            this.println("Changes made to input file. ");
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ENCODING);
            BufferedWriter out = new BufferedWriter(osr);
            int s = outputVector.size();
            this.println("Size of ov = " + s);
            for (int j = 0; j < s; ++j) {
                line = ((String)outputVector.elementAt(j)).toString();
                out.write(line + "\n");
            }
            out.close();
            this.println("Done outputting. ");
        } else {
            this.println("No Change Needed for file " + this.file);
        }
    }

    private String replace(String s, String uuid) {
        int start = s.indexOf(EYE_CATCHER);
        int end = start + EYE_CATCHER_LENGTH;
        if (s.charAt(end) != '\"') {
            ++end;
        }
        String ret = s.substring(0, start) + uuid + s.substring(end);
        this.println("Ret = " + ret);
        return ret;
    }

    private String generateUUID(String line) {
        int start = line.indexOf(EYE_CATCHER);
        ws390uuid u = null;
        if (line.charAt(start + EYE_CATCHER_LENGTH) != '\"') {
            String eyeCatcher = line.substring(start, start + EYE_CATCHER_LENGTH + 1);
            this.println("Marked EyeCatcher = " + eyeCatcher);
            u = keyTable.get(eyeCatcher);
            if (u == null) {
                u = new ws390uuid();
                keyTable.put(eyeCatcher, u);
                this.println("Generated UUID of " + u);
            } else {
                this.println("Using previously generated UUID: " + u);
            }
        } else {
            u = new ws390uuid();
            this.println("Generated UUID of " + u);
        }
        this.println("uuid is " + u);
        return u.toString();
    }

    private void println(String s) {
        if (this.verbose) {
            System.out.println("-> " + s);
        }
    }
}

