/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.aggregation.tags.InitTag;
import com.ibm.ws.portletcontainer.aggregation.tags.PortletStateHashtable;
import com.ibm.ws.portletcontainer.aggregation.tags.Utils;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class InsertTag
extends TagSupport {
    private static final long serialVersionUID = -7677661301921728389L;
    private static final String CLASS_NAME = InsertTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private ResourceBundle bundle = logger.getResourceBundle();
    private String url;
    private String windowId;
    private String targetWindowId;
    private String targetUrl;
    private String targetUrlWithoutContext;
    private String contentVar;
    private String contentScope;
    private String titleVar;
    private String titleScope;
    private InitTag parent;
    private Map scopeValues;
    private String context;

    public InsertTag() {
        this.init();
    }

    private void init() {
        this.titleScope = null;
        this.titleVar = null;
        this.contentScope = null;
        this.contentVar = null;
        this.targetUrlWithoutContext = null;
        this.targetUrl = null;
        this.windowId = null;
        this.context = null;
        this.url = null;
        this.parent = null;
    }

    public void release() {
        this.init();
    }

    public int doStartTag() throws JspException {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "Enter InsertTag.doStartTag()");
        }
        this.parent = (InitTag)InsertTag.findAncestorWithClass(this, InitTag.class);
        if (this.parent == null) {
            throw new JspTagException(this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.init.tag"));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "parent: [" + this.parent + "]");
        }
        this.scopeValues = Utils.getScopeValues(this.pageContext.getRequest(), this.url);
        if (this.scopeValues != null) {
            this.context = (String)this.scopeValues.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.context");
        }
        if (this.context == null) {
            this.context = this.url.substring(0, this.url.indexOf("/"));
        }
        String key = PortletStateHashtable.createKey(this.url, this.windowId);
        Map stateHashtable = (Map)this.pageContext.getSession().getAttribute(key);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "key: [" + key + "]");
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "stateHashtable: [" + stateHashtable + "]");
        }
        String modeValue = null;
        String stateValue = null;
        Map rparams = null;
        if (stateHashtable != null) {
            modeValue = (String)stateHashtable.get(Utils.modeSuffix);
            stateValue = (String)stateHashtable.get(Utils.stateSuffix);
            rparams = (Map)stateHashtable.get(Utils.rparamSuffix);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "modeValue: [" + modeValue + "] stateValue: [" + stateValue + "] rparams: [" + rparams + "]");
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "about to call Utils.assembleURL...");
        }
        this.targetUrl = Utils.assembleURL(null, this.url, this.windowId, this.parent.getURLVersion(), false, false, modeValue, stateValue, rparams, null, null, null);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "back from Utils.assembleURL, targetUrl: [" + this.targetUrl + "]");
        }
        this.getUrlParts();
        this.targetWindowId = this.parent.getTargetWindowId();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "targetWindowId: [" + this.targetWindowId + "]");
        }
        return 0;
    }

    private void getUrlParts() {
        this.targetUrlWithoutContext = this.targetUrl.substring(this.context.length());
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "targetUrlContext [" + this.context + "], targetUrlWithoutContext [" + this.targetUrlWithoutContext + "]");
        }
    }

    public int doEndTag() throws JspException {
        try {
            String title;
            String responseString = Utils.getResponseAsString(this.pageContext, this.context, this.targetUrlWithoutContext, this.parent.getPortletURLPrefix(), this.parent.getPortletURLSuffix(), this.parent.getPortletURLQueryParams(), this.targetWindowId, this.windowId);
            if (this.contentVar != null) {
                this.pageContext.setAttribute(this.contentVar, responseString, Utils.getScope(this.contentScope));
            } else {
                this.pageContext.getOut().print(responseString);
            }
            if (this.titleVar != null && (title = (String)this.pageContext.getAttribute("javax.portlet.title", 2)) != null) {
                this.pageContext.setAttribute(this.titleVar, title, Utils.getScope(this.titleScope));
            }
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InsertTag.doEndTag", (String)"99", (Object)this);
            this.init();
            throw new JspTagException(ex.toString(), ex);
        }
        this.init();
        return 6;
    }

    public void setUrl(String urlArg) {
        this.url = urlArg;
        if (this.url != null && this.url.startsWith("/")) {
            this.url = this.url.substring(1);
        }
    }

    public void setWindowId(String windowIdArg) {
        this.windowId = windowIdArg;
    }

    public void setContentVar(String contentVarArg) {
        this.contentVar = contentVarArg;
    }

    public void setContentScope(String contentScopeArg) {
        this.contentScope = contentScopeArg;
    }

    public void setTitleVar(String titleVarArg) {
        this.titleVar = titleVarArg;
    }

    public void setTitleScope(String titleScopeArg) {
        this.titleScope = titleScopeArg;
    }

    public String toString() {
        String separatorString = System.getProperty("line.separator");
        String retString = null;
        retString = separatorString + "url =                [" + this.url + "]" + separatorString + "context =            [" + this.context + "]" + separatorString + "windowId =           [" + this.windowId + "]" + separatorString + "contentVar =         [" + this.contentVar + "]" + separatorString + "contentScope =       [" + this.contentScope + "]" + separatorString + "titleVar =           [" + this.titleVar + "]" + separatorString + "titleScope =         [" + this.titleScope + "]";
        return retString;
    }
}

