/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wasresource.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.osgi.framework.Bundle;

public class WASResourceRegistryXSDProcessor {
    private static final TraceComponent tc = Tr.register(WASResourceRegistryXSDProcessor.class, null, null);
    public static WASResourceRegistryXSDProcessor resourceXSDProcessor = new WASResourceRegistryXSDProcessor();
    ResourceSet resourceSet;
    HashMap options;

    private WASResourceRegistryXSDProcessor() {
        block12: {
            this.resourceSet = new ResourceSetImpl();
            this.options = new HashMap();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WASResourceRegistryXSDProcessor");
            }
            this.options.put("EXTENDED_META_DATA", Boolean.TRUE);
            XSDEcoreBuilder xsdEcoreBuilder = new XSDEcoreBuilder();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClassLoader being used is " + loader);
            }
            try {
                URL resourceXSDUrl = null;
                try {
                    resourceXSDUrl = (URL)this.findResourceUsingv6Mechanism("com/ibm/ws/management/wasresource/common/WASResourcesRegistry.xsd").iterator().next();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (resourceXSDUrl == null) {
                    resourceXSDUrl = (URL)this.findResourceUsingCurrentClassLoader("com/ibm/ws/management/wasresource/common/WASResourcesRegistry.xsd").nextElement();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "xsd resource url found is  " + resourceXSDUrl);
                }
                Collection eCorePackages = xsdEcoreBuilder.generate(URI.createURI(resourceXSDUrl.toString()));
                for (EPackage pac : eCorePackages) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ecorepackage is " + pac + " namespace prefix is " + pac.getNsPrefix() + " namespace uri is " + pac.getNsURI());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EClass are " + ((EClass)pac.getEClassifier("ResourceMetadata")).getEStructuralFeature("implClass"));
                    }
                    this.resourceSet.getPackageRegistry().put(pac.getNsURI(), pac);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResoureTypeRegistry.WASResourceRegistryXSDProcessor", (String)"55", (Object)this);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Error while loading resource xchema.   Continue processing...", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WASResourceRegistryXSDProcessor");
        }
    }

    public static WASResourceRegistryXSDProcessor getInstance() {
        return resourceXSDProcessor;
    }

    public List getResources() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResources");
        }
        ArrayList allResources = new ArrayList();
        List resources = this.findResourceUsingv6Mechanism("META-INF/websphere-resources-def.xml");
        for (URL resourceXMLUrl : resources) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource url found is  " + resourceXMLUrl);
            }
            allResources.addAll(this.getResourcesFromXML(resourceXMLUrl.toString()));
        }
        Enumeration e = this.findResourceUsingCurrentClassLoader("META-INF/websphere-resources-def.xml");
        while (e.hasMoreElements()) {
            URL resourceXMLUrl;
            resourceXMLUrl = (URL)e.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource url found is  " + resourceXMLUrl);
            }
            allResources.addAll(this.getResourcesFromXML(resourceXMLUrl.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResources", allResources);
        }
        return allResources;
    }

    public List getResourcesFromXML(String xmlLocationURL) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesFromXML", xmlLocationURL);
        }
        XMLResourceImpl res = new XMLResourceImpl();
        Resource resourceDocument = this.resourceSet.createResource(URI.createURI(xmlLocationURL));
        resourceDocument.load(this.options);
        EObject root = (EObject)resourceDocument.getContents().get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource document root is " + root);
            Iterator rootclassiter = root.eClass().getEStructuralFeatures().iterator();
            while (rootclassiter.hasNext()) {
                Tr.debug(tc, "root sf is " + rootclassiter.next());
            }
            TreeIterator rootallcontentclassiter = root.eAllContents();
            while (rootallcontentclassiter.hasNext()) {
                Tr.debug(tc, "root all contents is " + rootallcontentclassiter.next());
            }
            Iterator rootcontentclassiter = root.eContents().iterator();
            while (rootcontentclassiter.hasNext()) {
                Tr.debug(tc, "root contents is " + rootcontentclassiter.next());
            }
        }
        EObject resources = (EObject)root.eGet(root.eClass().getEStructuralFeature(WASResourcesConstants.REGISTRY_XSD_RESOURCES));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource is " + resources);
            Tr.debug(tc, "Resource eclass is " + resources.eClass());
            Iterator resourcEStructuralFeaturesIter = resources.eClass().getEStructuralFeatures().iterator();
            while (resourcEStructuralFeaturesIter.hasNext()) {
                Tr.debug(tc, "Resource EStructuralFeature is " + resourcEStructuralFeaturesIter.next());
            }
        }
        List resourceList = (List)resources.eGet(resources.eClass().getEStructuralFeature(WASResourcesConstants.REGISTRY_XSD_RESOURCE));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesFromXML", resourceList);
        }
        return resourceList;
    }

    public String getResourceType(EObject resource) {
        String resourceType;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResourceType", resource);
            }
            resourceType = "";
            try {
                resourceType = (String)resource.eGet(resource.eClass().getEStructuralFeature(WASResourcesConstants.REGISTRY_XSD_TYPE));
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to get resource type.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceType", resourceType);
        }
        return resourceType;
    }

    public String getResourceExtType(EObject resource) {
        String resourceType;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResourceExtType", resource);
            }
            resourceType = "";
            try {
                resourceType = (String)resource.eGet(resource.eClass().getEStructuralFeature(WASResourcesConstants.REGISTRY_XSD_EXT_TYPE));
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to get resource type.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceExtType", resourceType);
        }
        return resourceType;
    }

    public String getResourceImplClass(EObject resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceImplClass", resource);
        }
        String resourceImplClass = (String)resource.eGet(resource.eClass().getEStructuralFeature(WASResourcesConstants.REGISTRY_XSD_IMPLCLASS));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceImplClass", resourceImplClass);
        }
        return resourceImplClass;
    }

    public String getResourcePriority(EObject resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcePriority", resource);
        }
        String resourcePrioirty = (String)resource.eGet(resource.eClass().getEStructuralFeature(WASResourcesConstants.REGISTRY_XSD_PRIORITY));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcePriority", resourcePrioirty);
        }
        return resourcePrioirty;
    }

    private Enumeration findResourceUsingCurrentClassLoader(String resourceName) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findResourceUsingCurrentClassLoader", resourceName);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoaderClassLocator locator = new ClassLoaderClassLocator(loader);
        Enumeration e = locator.locateResources(resourceName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceUsingCurrentClassLoader", e);
        }
        return e;
    }

    private List findResourceUsingv6Mechanism(String resourceName) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findResourceUsingv6Mechanism", resourceName);
        }
        ArrayList allResources = new ArrayList();
        try {
            HashSet<Bundle> bundlesProvidingConfig = new HashSet<Bundle>();
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".ws-resources-def";
            IExtensionPoint point = registry.getExtensionPoint(epid);
            IExtension[] extensions = point.getExtensions();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension point " + epid);
                Tr.debug(tc, "There are " + extensions.length + " extensions");
            }
            for (int i = 0; i < extensions.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extension found " + extensions[i]);
                }
                bundlesProvidingConfig.add(Platform.getBundle((String)extensions[i].getNamespace()));
            }
            for (final Bundle bundle : bundlesProvidingConfig) {
                final String resourceNameFinal = resourceName;
                Enumeration e = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            return bundle.getResources(resourceNameFinal);
                        }
                        catch (IOException ioe) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "io exception caught loading resources " + resourceNameFinal);
                            }
                            return null;
                        }
                    }
                });
                while (e != null && e.hasMoreElements()) {
                    allResources.add(e.nextElement());
                }
            }
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception while loading " + resourceName);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResourceRegistryXSDProcessor.findResourceUsingv6Mechanism", (String)"151", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigFile", allResources);
        }
        return allResources;
    }

    private class ClassLoaderClassLocator
    implements ClassLocator {
        private ClassLoader _loader;

        public ClassLoaderClassLocator(ClassLoader loader) {
            this._loader = loader;
        }

        public Class locateClass(final String className) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return ClassLoaderClassLocator.this._loader.loadClass(className);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (ClassNotFoundException)e.getCause();
            }
            return clazz;
        }

        public Enumeration locateResources(final String resourceName) throws IOException {
            Enumeration vEnum;
            try {
                vEnum = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return ClassLoaderClassLocator.this._loader.getResources(resourceName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
            return vEnum;
        }
    }

    private static interface ClassLocator {
        public Class locateClass(String var1) throws ClassNotFoundException;

        public Enumeration locateResources(String var1) throws IOException;
    }
}

