/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.util.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.Subject;

public class RSAPropagationHelper {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static final TraceComponent tc = Tr.register(RSAPropagationHelper.class, null, resBundleName);
    private static final String CLASSNAME = "com.ibm.ws.management.util.RSAPropagationHelper";
    public static final String RSA_AUTH_HEADER = "IBM-WAS-Authorization";
    public static final String RSA_AUTH_ERROR_MSG_HEADER = "IBM-WAS-Authorization-Error-Message";
    public static final String RSA_PUBLIC_CERT_HEADER = "IBM-WAS-RSA_Public-Cert";
    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String RSA_PROPATATION_MECH_OID = "oid:1.3.18.0.2.30.6";
    private static ThreadLocal agentUUIDTL = new ThreadLocal();
    private static ThreadLocal agentCertificateTL = new ThreadLocal();

    public static byte[] retrieveRSACert() throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, CertificateEncodingException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveRSACert");
        }
        boolean isDebug = tc.isDebugEnabled();
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (isDebug) {
            Tr.debug(tc, "adminService = " + adminService);
        }
        String node = adminService.getNodeName();
        if (isDebug) {
            Tr.debug(tc, "node name = " + node);
        }
        String process = adminService.getProcessName();
        if (isDebug) {
            Tr.debug(tc, "process name = " + process);
        }
        ObjectName queryName = new ObjectName(adminService.getDomainName() + ":" + "type=SSLAdmin,node=" + node + ",process=" + process + ",*");
        if (isDebug) {
            Tr.debug(tc, "queryName = " + queryName);
        }
        Set names = adminService.queryNames(queryName, null);
        ObjectName mBeanName = (ObjectName)names.iterator().next();
        if (isDebug) {
            Tr.debug(tc, "mBeanName = " + mBeanName);
        }
        X509Certificate cert = (X509Certificate)adminService.invoke(mBeanName, "getAdminRSAPropagationCertificate", null, null);
        byte[] certbytes = null;
        if (cert != null) {
            certbytes = cert.getEncoded();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cert = ", cert);
        }
        return certbytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRSAAuthHeader(HttpURLConnection conn, X509Certificate targetCert, String hostName) throws Exception {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addRSAAuthHeader");
            }
            try {
                Subject subject;
                if (targetCert == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "targetCert is null");
                    }
                    conn.setRequestProperty(RSA_AUTH_HEADER, RSA_AUTH_HEADER);
                    break block15;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "targetCert is not null");
                }
                if ((subject = SecurityHelper.retrieveSubject()) != null) {
                    try {
                        SecurityHelper.getActualSubject(subject);
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getActualSubject failed getting token Subject.");
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.RSAPropagationHelper.addRSAAuthHeader", (String)"138");
                        subject = null;
                    }
                }
                if (subject == null) break block15;
                WSSecurityContext ctx = WSSecurityContextFactory.getInstance().createContext(RSA_PROPATATION_MECH_OID);
                String realm = SecurityHelper.getHelper().getRealm();
                if (ctx == null) break block15;
                try {
                    RSATokenThreadManager.getInstance().setTargetCertificate(targetCert);
                    byte[] token = ctx.initSecContext(subject, hostName, realm);
                    byte[] tokenEncoded = Base64Coder.base64Encode((byte[])token);
                    String tokenStr = new String(tokenEncoded);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting tokenStr to http header IBM-WAS-Authorization");
                    }
                    conn.setRequestProperty(RSA_AUTH_HEADER, tokenStr);
                }
                finally {
                    RSATokenThreadManager.getInstance().setTargetCertificate(null);
                }
            }
            catch (Exception ex) {
                Tr.error(tc, "ADMN2000E", ex);
                throw ex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRSAAuthHeader");
        }
    }

    public static X509Certificate extractTargetCert(HttpURLConnection conn) throws IOException {
        X509Certificate targetCert;
        String targetCertStr;
        String METHOD = "extractTargetCert";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractTargetCert", conn);
        }
        if ((targetCertStr = conn.getHeaderField(RSA_PUBLIC_CERT_HEADER)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target RSA cert is not null");
            }
            byte[] certBytes = targetCertStr.getBytes();
            certBytes = Base64Coder.base64Decode((byte[])certBytes);
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
                targetCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.util.RSAPropagationHelper.extractTargetCert", (String)"198");
                IOException ioe = new IOException(ex);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractTargetCert", ioe);
                }
                throw ioe;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target RSA cert is null");
            }
            String errorMessage = conn.getHeaderField(RSA_AUTH_ERROR_MSG_HEADER);
            IOException ioe = (errorMessage = Base64Coder.base64Decode((String)errorMessage)) != null ? new IOException(errorMessage) : new IOException("Unable to retrieve target's public certificate");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractTargetCert", ioe);
            }
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractTargetCert", targetCert);
        }
        return targetCert;
    }

    public static String getAgentUUIDThreadLocal() {
        return (String)agentUUIDTL.get();
    }

    public static void setAgentUUIDThreadLocal(String newVal) {
        agentUUIDTL.set(newVal);
    }

    public static X509Certificate getAgentCertificateThreadLocal() {
        return (X509Certificate)agentCertificateTL.get();
    }

    public static void setAgentCertificateThreadLocal(X509Certificate cert) {
        agentCertificateTL.set(cert);
    }
}

