/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.connector.ConnectorHelper;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.tools.WsServerController;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WsServerLauncher
extends WsServerController {
    private static final String DEFAULT_TRACE_FILE = "startServer.log";
    private static TraceComponent tc = Tr.register(WsServerLauncher.class, "Admin", BUNDLE_NAME);
    private String scriptFileName = null;
    private boolean createScript = false;
    private boolean backgroundScript = false;
    private boolean binaryData = false;
    private Vector extraSystemProperties = null;
    private LaunchCommand launcher = null;
    private boolean devOption = false;
    private VariableMap variableMap = null;
    private static boolean forceGenericServerStart = false;
    private boolean recoveryMode = false;

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + this.serverName;
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    public static void main(String[] args) throws AdminException {
        WsServerLauncher wsServerLauncher = new WsServerLauncher();
        if (!WsServerLauncher.isPlatformWindows()) {
            System.exit(wsServerLauncher.executeUtility(args));
        }
        wsServerLauncher.writeExitCode(args, wsServerLauncher.executeUtilityOnWindows(args));
    }

    protected WindowsService getWindowsServiceIfAvailable(String[] args) throws AdminException {
        if (this.createScript) {
            return null;
        }
        WindowsService winSvc = super.getWindowsServiceIfAvailable(args);
        if (winSvc != null) {
            int svcStatus = winSvc.getServiceStatus();
            if (svcStatus == 2) {
                this.issueMessage("ADMU3027E", new Object[]{this.serverName}, null);
                Tr.error(tc, "ADMU3027E", new Object[]{this.serverName});
                System.exit(svcStatus);
            }
            if (svcStatus == 3) {
                winSvc = null;
            }
        }
        return winSvc;
    }

    protected void execWithWinService(WindowsService winSvc) throws AdminException {
        winSvc.doWASServiceAction("start", null);
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-developerscript")) {
            this.createScript = true;
            this.devOption = true;
            this.scriptFileName = "start_" + this.serverName;
            String os = System.getProperty("os.name").toLowerCase();
            LaunchScriptPlatformCollaborator platform = LaunchScriptCollaboratorFactory.getCollaborator(os);
            this.scriptFileName = platform.customizeScriptFilename(this.scriptFileName);
        } else if (option.equals("-script")) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.issueMessage("ADMU4018E", null, null);
                System.exit(-1);
            }
            this.createScript = true;
            if (this.isValidParameter(args, curOption + 1)) {
                this.scriptFileName = args[curOption + 1];
                ++nextOption;
            } else {
                this.scriptFileName = "start_" + this.serverName;
                String os = System.getProperty("os.name").toLowerCase();
                LaunchScriptPlatformCollaborator platform = LaunchScriptCollaboratorFactory.getCollaborator(os);
                this.scriptFileName = platform.customizeScriptFilename(this.scriptFileName);
            }
        } else if (option.equals("-binaryData")) {
            this.binaryData = true;
        } else if (option.equals("-background")) {
            this.backgroundScript = true;
        } else if (option.equals("-forceGenericServerStart")) {
            forceGenericServerStart = true;
        } else if (option.startsWith("-D")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.extraSystemProperties.add(option);
        } else if (option.startsWith("-J")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.extraSystemProperties.add(option.substring(2));
        } else if (option.startsWith("-recovery")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.recoveryMode = true;
            this.extraSystemProperties.add("-Dcom.ibm.ws.server.mode=recovery");
        } else {
            nextOption = super.parseUtilitySpecificOption(args, curOption);
        }
        return nextOption;
    }

    protected void issueUsageMessage() {
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4016I", null, null);
        } else if (this.isDmgr) {
            this.issueMessage("ADMU4017I", null, null);
        } else {
            this.issueMessage("ADMU4001I", null, null);
        }
        this.issueMessage("ADMU4002I", null, null);
        this.issueMessage("ADMU4004I", null, null);
        this.issueMessage("ADMU4010I", null, null);
        this.issueMessage("ADMU4012I", null, null);
        this.issueMessage("ADMU4011I", null, null);
        this.issueMessage("ADMU4005I", null, null);
        this.issueMessage("ADMU4006I", null, null);
        this.issueMessage("ADMU4009I", null, null);
        this.issueMessage("ADMU4026I", null, null);
        this.issueMessage("ADMU4027I", null, null);
        this.issueMessage("ADMU4025I", null, null);
    }

    /*
     * Loose catch block
     */
    protected int runTool() throws Exception {
        int n;
        block39: {
            String pid;
            Process p;
            block37: {
                int n2;
                block38: {
                    ConfigService repository2;
                    block35: {
                        int ostype2222;
                        block36: {
                            block33: {
                                int ostype2222;
                                block34: {
                                    block31: {
                                        int n3;
                                        block32: {
                                            this.issueMessage("ADMU3100I", new Object[]{this.serverName}, null);
                                            repository2 = this.initializeRepositoryAndLauncher();
                                            if (!this.createScript) break block31;
                                            String ostype2222 = System.getProperty("os.name");
                                            if (this.devOption) {
                                                this.launcher.setDevOption(this.devOption);
                                            }
                                            this.launcher.createLaunchScript(ostype2222, this.scriptFileName, this.backgroundScript);
                                            this.issueMessage("ADMU3300I", new Object[]{this.scriptFileName}, null);
                                            n3 = 0;
                                            Object var7_9 = null;
                                            if (this.statusSocket == null) break block32;
                                            try {
                                                this.statusSocket.close();
                                            }
                                            catch (IOException x) {
                                                // empty catch block
                                            }
                                        }
                                        return n3;
                                    }
                                    if (!this.binaryData) break block33;
                                    this.scriptFileName = this.serverName + "_binary.data";
                                    this.launcher.createBinaryData(this.scriptFileName);
                                    ostype2222 = 0;
                                    Object var7_10 = null;
                                    if (this.statusSocket == null) break block34;
                                    try {
                                        this.statusSocket.close();
                                    }
                                    catch (IOException x) {
                                        // empty catch block
                                    }
                                }
                                return ostype2222;
                            }
                            if (!GenericServerProcHelper.isServerAGenericServer(this.createServerIdentifiers())) break block35;
                            ostype2222 = this.doGenericServer();
                            Object var7_11 = null;
                            if (this.statusSocket == null) break block36;
                            try {
                                this.statusSocket.close();
                            }
                            catch (IOException x) {
                                // empty catch block
                            }
                        }
                        return ostype2222;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Launching a new server process: " + this.serverName);
                    }
                    if (!this.nowait) {
                        this.statusPort = this.getStatusPort();
                        this.launcher.setStatusSocketPort(this.statusPort);
                        if (this.statusPort != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "status socket = " + this.statusPort.toString());
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "  The communication with the server was lost due to a commination error.  \nSuch communication error is related to the operating system trying to get a free port.\nPlease check the logs of the server to determine the status of the server.");
                            }
                        }
                    }
                    if (this.serverIsRunning(repository2)) {
                        this.issueMessage("ADMU3027E", new Object[]{this.serverName}, null);
                        throw new AdminException(this.getFormattedMessage("ADMU3027E", new Object[]{this.serverName}, null));
                    }
                    p = this.launcher.launchProcess();
                    pid = p.id();
                    if (!this.nowait) break block37;
                    p.release();
                    this.issueMessage("ADMU3400I", new Object[]{pid}, null);
                    n2 = 0;
                    Object var7_12 = null;
                    if (this.statusSocket == null) break block38;
                    try {
                        this.statusSocket.close();
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                }
                return n2;
            }
            this.issueMessage("ADMU3200I", null, null);
            new ProcessWatcher(p);
            int status = this.waitForServerInit();
            if (status == 0) {
                if (this.recoveryMode) {
                    this.issueMessage("ADMU3001I", new Object[]{this.serverName, pid}, null);
                    status = this.waitForServerInit();
                    if (status == 0) {
                        this.issueMessage("ADMU3013I", new Object[]{this.serverName}, null);
                    } else {
                        this.issueMessage("ADMU3014W", new Object[]{this.serverName}, null);
                    }
                } else {
                    this.issueMessage("ADMU3000I", new Object[]{this.serverName, pid}, null);
                }
            } else if (status == -1 || status == 0) {
                String strServerLogDir = System.getProperty("user.install.root") + File.separator + "logs" + File.separator + this.serverName;
                this.issueMessage("ADMU3011E", new Object[]{strServerLogDir}, null);
            } else {
                String timeString = new Integer(this.statusTimeout / 1000).toString();
                throw new AdminException(this.getFormattedMessage("ADMU3040E", new Object[]{timeString}, "Timed out waiting for server initialization."));
            }
            n = status;
            Object var7_13 = null;
            if (this.statusSocket == null) break block39;
            try {
                this.statusSocket.close();
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        return n;
        catch (Exception e) {
            try {
                Tr.error(tc, "ADMU3002E", this.serverName);
                Tr.error(tc, "ADMU3007E", e);
                throw e;
            }
            catch (Throwable throwable) {
                block40: {
                    Object var7_14 = null;
                    if (this.statusSocket == null) break block40;
                    try {
                        this.statusSocket.close();
                    }
                    catch (IOException x) {}
                }
                throw throwable;
            }
        }
    }

    protected void toolFailed() {
        String command = null;
        if (this.launcher != null) {
            try {
                command = this.launcher.getLaunchCommand().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ManagerAdmin.appendTraceString("*=all=enabled");
        Tr.dump(tc, "LaunchCommand is: ", command);
    }

    private ConfigService initializeRepositoryAndLauncher() throws Exception {
        ConfigObject server = null;
        ConfigService localVarRepository = ConfigServiceFactory.createConfigService((String)this.configRoot, (String)this.cellName, (String)this.nodeName, (String)this.serverName);
        List resContents = localVarRepository.getDocumentObjects(localVarRepository.getScope(4), "server.xml");
        server = (ConfigObject)resContents.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess  server :" + server);
        }
        String clusterName = server.getString("clusterName", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess Cluster  :" + clusterName);
        }
        if (clusterName != null) {
            localVarRepository = ConfigServiceFactory.createConfigService((String)this.configRoot, (String)this.cellName, (String)this.nodeName, (String)this.serverName, (String)clusterName);
        }
        this.variableMap = VariableMapFactory.createVariableMap((ConfigService)localVarRepository);
        this.variableMap.initialize(null);
        this.launcher = new LaunchCommand(localVarRepository, this.variableMap, this.createServerIdentifiers());
        if (this.extraSystemProperties != null) {
            for (int i = 0; i < this.extraSystemProperties.size(); ++i) {
                this.launcher.addSystemProperty((String)this.extraSystemProperties.get(i));
            }
        }
        return localVarRepository;
    }

    protected boolean isFinalStatus(int result) {
        if (result == 0 || result == -1 || result == -2 || result == 0) {
            return true;
        }
        if (result == 2) {
            this.issueMessage("ADMU3220I", null, null);
        }
        return false;
    }

    protected int getFailureStatus() {
        return -1;
    }

    protected int getTimeoutStatus() {
        return -2;
    }

    protected void logUnknownException(Exception exc) {
        Tr.error(tc, "ADMU3009E", exc);
    }

    protected void printEnhancedErrorMessage(Throwable t) {
        if (t instanceof AdminException) {
            AdminException ae = (AdminException)t;
            Throwable throwable = ae.getCause();
        }
    }

    public Vector getLaunchCommand(String[] args) {
        Vector v = null;
        try {
            this.parseArgs(args);
            this.initializeRepositoryAndLauncher();
            v = this.launcher.getLaunchCommand();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return v;
    }

    private static Server getServer(Resource res) throws Exception {
        Server svr = null;
        EList resContents = res.getContents();
        for (int i = 0; i < resContents.size(); ++i) {
            Object resource = resContents.get(i);
            if (!(resource instanceof Server)) continue;
            svr = (Server)resource;
        }
        return svr;
    }

    private boolean serverIsRunning(ConfigService repository2) throws Exception {
        ConnectorHelper helper = new ConnectorHelper(repository2, this.variableMap, null, "localhost", null, false, null, null);
        List runningPorts = helper.getOpenConnectorPorts(false);
        boolean running = runningPorts.size() > 0;
        for (String port : runningPorts) {
            this.issueMessage("ADMU3028I", new Object[]{port, this.serverName}, null);
        }
        return running;
    }

    private int doGenericServer() throws AdminException {
        int retVal = 0;
        String gServerStatus = null;
        try {
            gServerStatus = GenericServerProcHelper.getStatusUsingPidFile(this.createServerIdentifiers());
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        if (gServerStatus.equals("STOPPED")) {
            retVal = GenericServerProcHelper.launchGenericServer(this.launcher, this.createServerIdentifiers());
            if (retVal == 0) {
                this.issueMessage("ADMU7770I", new Object[]{this.serverName}, null);
            }
            return retVal;
        }
        if (!forceGenericServerStart) {
            this.issueMessage("ADMU7771E", new Object[]{this.serverName}, null);
            Tr.error(tc, "ADMU7771E", this.serverName);
            throw new AdminException(this.getFormattedMessage("ADMU7771E", new Object[]{this.serverName}, null));
        }
        retVal = GenericServerProcHelper.launchGenericServer(this.launcher, this.createServerIdentifiers());
        if (retVal == 0) {
            this.issueMessage("ADMU7770I", new Object[]{this.serverName}, null);
        }
        return retVal;
    }

    private class ProcessWatcher
    extends Thread {
        Process process;

        private ProcessWatcher(Process process) {
            this.process = process;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                if (this.process.isAlive()) {
                    this.process.waitForTermination();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Socket soc = new Socket("localhost", WsServerLauncher.this.statusSocket.getLocalPort());
                DataOutputStream dos = new DataOutputStream(soc.getOutputStream());
                dos.writeInt(-1);
                dos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

