/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.net.InetAddress;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class UpdateVirtualHost {
    private static final TraceComponent tc = Tr.register(UpdateVirtualHost.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    protected ConfigService _configService = null;
    protected Session _session = null;

    public UpdateVirtualHost(ConfigService configService) {
        this._configService = configService;
        this._session = new Session();
    }

    public void updateDefaultHostHostAliases(String connHost, String[] hosts, String[] ports) {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateDefaultHostAliases:" + connHost);
            }
            try {
                ObjectName vhDefaultHost = this.queryDefaultHostVirtualHost();
                if (vhDefaultHost != null) {
                    ObjectName[] matches = this.queryHostAliases(vhDefaultHost);
                    boolean bUpdated = this.updateDefaultHostHostAliases(vhDefaultHost, matches, connHost, hosts, ports);
                    if (bUpdated) {
                        this._configService.save(this._session, false);
                    } else {
                        this._configService.discard(this._session);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default_host found in dmgr virtuahosts");
                }
            }
            catch (Exception ec) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Caught exception ", ec);
            }
        }
    }

    public void updateDefaultHostHostAliases(String connHost, List listHosts, List listPorts) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateDefaultHostAliases:" + connHost);
        }
        if (listPorts.size() < 1) {
            return;
        }
        String[] hosts = new String[listHosts.size()];
        String[] ports = new String[listPorts.size()];
        hosts = listHosts.toArray(hosts);
        ports = listPorts.toArray(ports);
        this.updateDefaultHostHostAliases(connHost, hosts, ports);
    }

    private boolean updateDefaultHostHostAliases(ObjectName vhDefaultHost, ObjectName[] matchesHA, String connHost, String[] hosts, String[] ports) throws Exception {
        int iI;
        String dmgrHost = this.getHostName(connHost);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dmgrHost=" + dmgrHost);
        }
        boolean bUpdated = false;
        boolean[] bAlreadyUsed = new boolean[ports.length];
        for (int iI2 = 0; iI2 < bAlreadyUsed.length; ++iI2) {
            bAlreadyUsed[iI2] = false;
        }
        String[] hostnames = this.getHostNames(hosts);
        for (iI = 0; iI < matchesHA.length; ++iI) {
            String strDmgrHostName = (String)this._configService.getAttribute(this._session, matchesHA[iI], "hostname");
            String strDmgrPort = (String)this._configService.getAttribute(this._session, matchesHA[iI], "port");
            if (strDmgrHostName.equals("*")) {
                strDmgrHostName = dmgrHost;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HostAlias DMGR: hostname=" + strDmgrHostName + "  Port:" + strDmgrPort);
            }
            for (int iJ = 0; iJ < ports.length; ++iJ) {
                if (!ports[iJ].equals(strDmgrPort) || !hostnames[iJ].equals(strDmgrHostName)) continue;
                bAlreadyUsed[iJ] = true;
            }
        }
        for (iI = 0; iI < ports.length; ++iI) {
            if (bAlreadyUsed[iI]) continue;
            for (int iJ = iI + 1; iJ < ports.length; ++iJ) {
                if (!ports[iJ].equals(ports[iI]) || !hostnames[iJ].equals(hostnames[iI])) continue;
                bAlreadyUsed[iJ] = true;
            }
        }
        for (iI = 0; iI < ports.length; ++iI) {
            if (bAlreadyUsed[iI]) continue;
            if (hostnames[iI].equals(dmgrHost)) {
                hostnames[iI] = "*";
            }
            this.addNewHostAlias(vhDefaultHost, hostnames[iI], ports[iI]);
            bUpdated = true;
        }
        return bUpdated;
    }

    protected ObjectName queryDefaultHostVirtualHost() throws Exception {
        block4: {
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VirtualHost", "default_host");
                ObjectName[] matches = this._configService.queryConfigObjects(this._session, null, pattern, null);
                if (matches != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found VirtualHost =" + matches[0].toString());
                    }
                    return matches[0];
                }
            }
            catch (Exception ec) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught exception ", ec);
            }
        }
        return null;
    }

    protected ObjectName[] queryHostAliases(ObjectName virtualhost) throws Exception {
        ObjectName[] matches = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "HostAlias", null);
            matches = this._configService.queryConfigObjects(this._session, virtualhost, pattern, null);
            return matches;
        }
        catch (Exception ec) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception ", ec);
            }
            return null;
        }
    }

    protected void addNewHostAlias(ObjectName virtualhost, String host, String port) throws Exception {
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("hostname", host));
        attrList.add(new Attribute("port", port));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addNewHostAlias:" + host + ":" + port);
        }
        this._configService.createConfigData(this._session, virtualhost, "aliases", null, attrList);
    }

    protected String getHostName(String strHost) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHostName:" + strHost);
        }
        InetAddress ipAddr = null;
        try {
            ipAddr = strHost.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(strHost);
            String tmp = ipAddr.getHostAddress();
            String hostname = InetAddress.getByName(tmp).getHostName();
            return hostname.toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return strHost;
        }
    }

    protected String[] getHostNames(String[] hosts) {
        String[] hostnames = new String[hosts.length];
        for (int iI = 0; iI < hostnames.length; ++iI) {
            Object strHost = null;
            hostnames[iI] = hosts[iI].equals("*") ? this.getHostName("localhost") : this.getHostName(hosts[iI]);
        }
        return hostnames;
    }
}

