/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.util.WASEcoreUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class UnmanagedNode {
    private static final String DEFAULT_NODE_VERSION = "7.0.0.0";
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.unnodeutils";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private WorkSpace workSpace = null;
    private Session session = null;
    private String nodeName = null;
    private String hostName = null;
    private String cellName = null;
    private RepositoryContext cellContext = null;
    private RepositoryContext nodeContext = null;
    private static final String nodeXML = "node.xml";
    private static final String serverIndexXML = "serverindex.xml";
    static final String NODE_PROPERTIES = "node-metadata.properties";
    private Properties nodeProperties = new Properties();
    private static TraceComponent tc = Tr.register(UnmanagedNode.class, "Admin", "com.ibm.ws.management.resources.unmgdnodeutils");

    UnmanagedNode(Session session, String nodename) throws WorkSpaceException, AdminException, IOException {
        this.session = session;
        this.nodeName = nodename;
        this.workSpace = WorkspaceHelper.getWorkspace(session);
        this.cellName = UnmanagedNode.getTheCellName(this.workSpace);
        this.removeNode();
    }

    UnmanagedNode(Session session, String nodeName, String hostName, String nodeOperatingSystem) throws WorkSpaceException, FileNotFoundException, IOException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UnmanagedNode()");
        }
        this.session = session;
        this.nodeName = nodeName;
        this.hostName = hostName;
        if (!this.isValidPlatform(nodeOperatingSystem)) {
            throw new AdminException(UnmanagedNode.getFormattedMessage("ADMK0203E", null, null));
        }
        this.nodeProperties.setProperty("com.ibm.websphere.nodeOperatingSystem", nodeOperatingSystem);
        String baseProductVersion = this.getVersion(UnmanagedNode.findDmgrNode(session));
        this.nodeProperties.setProperty("com.ibm.websphere.baseProductVersion", baseProductVersion);
        this.workSpace = WorkspaceHelper.getWorkspace(session);
        this.cellName = UnmanagedNode.getTheCellName(this.workSpace);
        this.addNode();
        this.createManagedObjectMetadataPropertiesFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UnmanagedNode()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManagedObjectMetadataPropertiesFile() throws IOException, FileNotFoundException, WorkSpaceException {
        String metadataFile = this.nodeContext.getPath() + File.separator + NODE_PROPERTIES;
        FileOutputStream fos = new FileOutputStream(metadataFile);
        try {
            this.nodeProperties.store(fos, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
        this.nodeContext.notifyChanged(0, NODE_PROPERTIES);
    }

    private boolean isValidPlatform(String platform) {
        String[] validPlatforms = new String[]{"os400", "aix", "hpux", "linux", "solaris", "windows", "os390"};
        for (int i = 0; i < validPlatforms.length; ++i) {
            if (!platform.equals(validPlatforms[i])) continue;
            return true;
        }
        return false;
    }

    private void addNode() throws WorkSpaceException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNode()");
        }
        String fileUri = nodeXML;
        String siFileUri = serverIndexXML;
        RepositoryContext cellContext = null;
        cellContext = this.workSpace.findContext(this.cellName);
        this.nodeContext = this.workSpace.findContext(this.cellName + "/nodes/" + this.nodeName);
        if (this.nodeContext != null) {
            throw new AdminException(UnmanagedNode.getFormattedMessage("ADMK0204E", null, null));
        }
        try {
            this.nodeContext = cellContext.create(RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes"), this.nodeName);
        }
        catch (Exception jexcptn) {
            Tr.error(tc, "caught exception creating node context: " + jexcptn);
        }
        EPackage pkg = EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi");
        EFactory factory = pkg.getEFactoryInstance();
        EClassifier ctype = pkg.getEClassifier("Node");
        Node newNode = (Node)factory.create((EClass)ctype);
        newNode.setName(this.nodeName);
        String tempResUri = UnmanagedNode.makeTemporary(newNode);
        Node node = (Node)UnmanagedNode.getTemporaryObject(tempResUri);
        String refId = this.jmakeChild(this.workSpace, this.nodeContext.getURI(), nodeXML, node, fileUri);
        pkg = EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        factory = pkg.getEFactoryInstance();
        ctype = pkg.getEClassifier("ServerIndex");
        ServerIndex newServerIndex = (ServerIndex)factory.create((EClass)ctype);
        newServerIndex.setHostName(this.hostName);
        tempResUri = UnmanagedNode.makeTemporary(newServerIndex);
        ServerIndex si = (ServerIndex)UnmanagedNode.getTemporaryObject(tempResUri);
        refId = this.jmakeChild(this.workSpace, this.nodeContext.getURI(), serverIndexXML, si, siFileUri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNode()");
        }
    }

    private String jmakeChild(WorkSpace workSpace, String contextId, String resourceUri, EObject object, String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jmakeChild()");
        }
        RepositoryContext context = null;
        Resource resource = null;
        String refId = null;
        String contextUri = UnmanagedNode.decodeContextUri(contextId);
        try {
            context = workSpace.findContext(contextUri);
        }
        catch (WorkSpaceException wse) {
            Tr.error(tc, "error in finding context " + wse.toString());
            return null;
        }
        Tr.audit(tc, "Context" + context.getURI());
        Tr.audit(tc, "resourceUri " + resourceUri);
        ResourceSet resourceSet = context.getResourceSet();
        if (!context.isAvailable(fileName)) {
            Tr.audit(tc, "File " + fileName + " was not available in context, " + context.getURI());
            Resource.Factory factory = workSpace.getResourceFactoryRegistry().getFactory(URI.createURI(fileName));
            resource = factory.createResource(URI.createURI(fileName));
            resourceSet.getResources().add(resource);
        }
        if (object.eResource() != null) {
            ((XMIResource)object.eResource()).setID(object, null);
        }
        EList collection = resource.getContents();
        collection.add(object);
        try {
            resource.save(new HashMap());
            refId = ((XMIResource)object.eResource()).getID(object);
        }
        catch (Exception e) {
            Tr.error(tc, "error in saving resource for root object " + e.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jmakeChild()");
        }
        return refId;
    }

    private static String decodeContextUri(String contextUri) {
        String newContextUri = null;
        if (contextUri == null) {
            return newContextUri;
        }
        newContextUri = contextUri.replace(':', '/');
        return newContextUri;
    }

    private static EObject getTemporaryObject(String tempResourceUri) {
        EObject eObject = RefObjectHelperFactory.getRefObjectHelper().getTemporaryObject(tempResourceUri);
        return eObject;
    }

    private static String makeTemporary(EObject eObject) {
        String tempResourceUri = RefObjectHelperFactory.getRefObjectHelper().makeTemporary(eObject);
        return tempResourceUri;
    }

    private static String getTheCellName(WorkSpace ws) throws WorkSpaceException {
        RepositoryContextType cellType = ws.getMetaData().getContextType("cells");
        Collection jcellContexts = ws.findContext(cellType);
        Iterator ji = jcellContexts.iterator();
        RepositoryContext jjCellContext = (RepositoryContext)ji.next();
        return jjCellContext.getURI();
    }

    private boolean isManaged(ServerIndex si) {
        boolean managed = false;
        EList list = si.getServerEntries();
        for (int i = 0; i < list.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)list.get(i);
            if (!serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") && !serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
            managed = true;
            break;
        }
        return managed;
    }

    private static String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }

    public static List listUnmanagedNodes(Session session) throws ConfigServiceException, WorkSpaceException, IOException {
        boolean isThisNodeManaged = true;
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ArrayList<String> unmanagedNodes = new ArrayList<String>();
        RepositoryContextType nodeType = workSpace.getMetaData().getContextType("nodes");
        Collection nodeContexts = workSpace.findContext(nodeType);
        for (RepositoryContext nodeContext : nodeContexts) {
            WorkSpaceFile wsf = null;
            try {
                wsf = nodeContext.getFile(serverIndexXML);
            }
            catch (Throwable t) {
                continue;
            }
            if (wsf == null) continue;
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI(serverIndexXML));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            isThisNodeManaged = false;
            EList list = serverIndex.getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                String serverType = serverEntry.getServerType();
                if (serverType.equals("NODE_AGENT")) {
                    isThisNodeManaged = true;
                    break;
                }
                if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
                isThisNodeManaged = true;
                break;
            }
            if (isThisNodeManaged) continue;
            String uri = nodeContext.getURI();
            uri.substring(uri.lastIndexOf("/") + 1);
            unmanagedNodes.add(uri.substring(uri.lastIndexOf("/") + 1));
        }
        return unmanagedNodes;
    }

    public static List listManagedNodes(Session session) throws ConfigServiceException, WorkSpaceException, IOException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ArrayList<String> managedNodes = new ArrayList<String>();
        RepositoryContextType nodeType = workSpace.getMetaData().getContextType("nodes");
        Collection nodeContexts = workSpace.findContext(nodeType);
        for (RepositoryContext nodeContext : nodeContexts) {
            WorkSpaceFile wsf = null;
            try {
                wsf = nodeContext.getFile(serverIndexXML);
            }
            catch (Throwable t) {
                continue;
            }
            if (wsf == null) continue;
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI(serverIndexXML));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList list = serverIndex.getServerEntries();
            boolean isAdminAgentEnv = false;
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                String serverType = serverEntry.getServerType();
                if (serverType.equals("NODE_AGENT")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "It is DeploymentManager environment");
                    }
                    String uri = nodeContext.getURI();
                    uri.substring(uri.lastIndexOf("/") + 1);
                    managedNodes.add(uri.substring(uri.lastIndexOf("/") + 1));
                    break;
                }
                if (serverType.equals("JOB_MANAGER")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "It is JobManager environment");
                    }
                    throw new ConfigServiceException(UnmanagedNode.getFormattedMessage("ADMK0207E", new Object[0], "The command is not supported in job manager. You need to use queryManagedNodes command."));
                }
                if (!serverType.equals("ADMIN_AGENT")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "It is AdminAgent environment");
                }
                isAdminAgentEnv = true;
                managedNodes = new ArrayList();
                break;
            }
            if (!isAdminAgentEnv) continue;
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            CommandProviderHelper helper = cmdMgr.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            ObjectName mnON = ConfigServiceHelper.createObjectName(null, "ManagedNode");
            ObjectName[] managedNodeArray = null;
            try {
                managedNodeArray = configService.queryConfigObjects(session, null, mnON, null);
                if (managedNodeArray.length == 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting all ManagedNode on AdminAgent env");
                }
                for (int i = 0; i < managedNodeArray.length; ++i) {
                    ObjectName mn = managedNodeArray[i];
                    String managedNodeName = (String)configService.getAttribute(session, mn, "name");
                    managedNodes.add(managedNodeName);
                }
            }
            catch (ConnectorException e) {
                e.printStackTrace();
            }
        }
        return managedNodes;
    }

    public static String findDmgrNode(Session session) throws ConfigServiceException, WorkSpaceException, IOException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryContextType nodeType = workSpace.getMetaData().getContextType("nodes");
        Collection nodeContexts = workSpace.findContext(nodeType);
        for (RepositoryContext nodeContext : nodeContexts) {
            WorkSpaceFile wsf = null;
            try {
                wsf = nodeContext.getFile(serverIndexXML);
            }
            catch (Throwable t) {
                continue;
            }
            if (wsf == null) continue;
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI(serverIndexXML));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList list = serverIndex.getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                String serverType = serverEntry.getServerType();
                if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
                String uri = nodeContext.getURI();
                uri.substring(uri.lastIndexOf("/") + 1);
                return uri.substring(uri.lastIndexOf("/") + 1);
            }
        }
        return null;
    }

    private String getVersion(String dmgrNodeName) throws AdminException {
        if (dmgrNodeName == null) {
            return this.localNodeVersion();
        }
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
        Properties tmpProperties = null;
        try {
            managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(tmpProperties);
        }
        catch (AdminException e) {
            e.printStackTrace();
        }
        String prodVersion = null;
        try {
            prodVersion = managedObjectMetadataAccessor.getMetadataProperty(dmgrNodeName, "com.ibm.websphere.baseProductVersion");
        }
        catch (AdminException e1) {
            e1.printStackTrace();
        }
        return prodVersion;
    }

    private String localNodeVersion() {
        return DEFAULT_NODE_VERSION;
    }

    private void removeNode() throws WorkSpaceException, IOException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode()");
        }
        this.cellContext = this.workSpace.findContext(this.cellName);
        this.nodeContext = this.workSpace.findContext(this.cellName + "/nodes/" + this.nodeName);
        this.nodeContext.extract(serverIndexXML, false);
        Resource resource = this.nodeContext.getResourceSet().createResource(URI.createURI(serverIndexXML));
        resource.load(new HashMap());
        ServerIndex si = (ServerIndex)resource.getContents().get(0);
        EList serverEntries = si.getServerEntries();
        if (this.isManaged(si)) {
            throw new AdminException(UnmanagedNode.getFormattedMessage("ADMK0202E", new Object[]{this.nodeName}, null));
        }
        this.removeServers(serverEntries);
        this.nodeContext.delete(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNode()");
        }
    }

    private void removeServers(List serverEntries) throws AdminException, WorkSpaceException, IOException, InvalidParameterValueException, InvalidParameterNameException {
        if (serverEntries.size() > 0) {
            TaskCommand deleteServer = null;
            try {
                deleteServer = (TaskCommand)CommandMgr.getCommandMgr().createCommand("deleteServer");
            }
            catch (Throwable t) {
                throw Utils.makeAdminException(t);
            }
            for (int k = 0; k < serverEntries.size(); ++k) {
                ServerEntry serverEntry = (ServerEntry)serverEntries.get(k);
                String serverName = serverEntry.getServerName();
                RepositoryContext appContext = null;
                EList deployedApplications = serverEntry.getDeployedApplications();
                for (int j = 0; j < deployedApplications.size(); ++j) {
                    appContext = this.cellContext.findContext("applications/" + deployedApplications.get(j));
                    Resource depResource = appContext.getResourceSet().createResource(URI.createURI("deployment.xml"));
                    depResource.load(new HashMap());
                    EList deployments = depResource.getContents();
                    if (deployments == null || deployments.isEmpty() || !(deployments.get(0) instanceof Deployment)) continue;
                    this.removeDeploymentTargets(deployments, this.nodeContext.getName());
                }
                deleteServer.setConfigSession(this.session);
                deleteServer.setParameter("serverName", serverName);
                deleteServer.setParameter("nodeName", this.nodeName);
                deleteServer.execute();
                CommandResult result = deleteServer.getCommandResult();
                if (result.isSuccessful()) continue;
                throw new AdminException(UnmanagedNode.getFormattedMessage("ADMK0202E", new Object[]{this.nodeName}, null));
            }
        }
    }

    private void removeDeploymentTargets(List deplContents, String nodeName) throws AdminException {
        for (int k = 0; k < deplContents.size(); ++k) {
            Deployment deployment = (Deployment)deplContents.get(k);
            EList deploymentTargets = deployment.getDeploymentTargets();
            ServerTarget serverTarget = null;
            DeploymentTarget deploymentTarget = null;
            boolean wereServerTargetsRemoved = false;
            for (int m = 0; m < deploymentTargets.size(); ++m) {
                deploymentTarget = (DeploymentTarget)deploymentTargets.get(m);
                if (!(deploymentTarget instanceof ServerTarget) || !(serverTarget = (ServerTarget)deploymentTarget).getNodeName().equals(nodeName)) continue;
                WASEcoreUtil.remove(deploymentTarget);
                wereServerTargetsRemoved = true;
            }
            if (!wereServerTargetsRemoved) continue;
            try {
                deployment.eResource().save(new HashMap());
            }
            catch (Throwable t) {
                // empty catch block
            }
            wereServerTargetsRemoved = false;
        }
    }
}

