/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import javax.management.InstanceNotFoundException;

public final class NodeCleanupUtility
extends AbstractNodeConfigUtility {
    private static TraceComponent tc = Tr.register(NodeCleanupUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "cleanupNode.log";

    public static void main(String[] args) {
        System.exit(new NodeCleanupUtility().executeUtility(args));
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0600I", null, null);
    }

    protected int parseRequiredArgs(String[] args) {
        int nextArg = 3;
        if (args.length > 3 && !args[3].startsWith("-")) {
            this.connHost = args[3];
            nextArg = 4;
            if (args.length > 4 && !args[4].startsWith("-")) {
                this.connPort = args[4];
                nextArg = 5;
            } else {
                this.connPort = "8879";
            }
        } else {
            this.connHost = "localhost";
            this.connPort = "8879";
        }
        return nextArg;
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected void emitNotification(String key, String msg) {
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU2001I", new Object[]{this.nodeName}, null);
        boolean removed = false;
        try {
            this.adminClient = this.getAdminClient(this.getClientProperties());
            if (this.nodeExistsInCell(this.adminClient)) {
                this.removeFromCell(this.adminClient);
                removed = true;
            } else {
                this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
            }
        }
        catch (Throwable t) {
            throw new AdminException(NodeCleanupUtility.getRootCause(t), t.getMessage());
        }
        if (removed) {
            this.issueMessage("ADMU2024I", new Object[]{this.nodeName}, null);
        }
        return 0;
    }

    private boolean nodeExistsInCell(AdminClient adminClient) throws InstanceNotFoundException, ConnectorException, ConfigServiceException {
        ConfigServiceProxy configService = new ConfigServiceProxy(adminClient);
        Session session = new Session();
        if (configService.resolve(session, "Node=" + this.nodeName).length > 0) {
            configService.discard(session);
            return true;
        }
        configService.discard(session);
        return false;
    }

    protected VariableMap getVariableMap() {
        return null;
    }

    protected Repository getLocalRepository() {
        return null;
    }
}

