/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.util.Properties;

public class DMgrConfigUtils {
    private static TraceComponent tc = Tr.register(DMgrConfigUtils.class, "Admin", "com.ibm.ws.management.resources.adminservice");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doMergeConfig(Properties nodeProperties, Properties adminProperties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doMergeConfigData", nodeProperties);
            Tr.entry(tc, "doMergeConfigData", adminProperties);
        }
        String cellName = nodeProperties.getProperty("CELL_NAME_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName", cellName);
        }
        String nodeName = nodeProperties.getProperty("NODE_NAME_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        String archiveLocation = nodeProperties.getProperty("ADDNODE_ARCHIVE_PATH_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "archiveLocation", archiveLocation);
        }
        String nodeGroupName = adminProperties.getProperty("NODE_Group_NAME_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeGroupName", nodeGroupName);
        }
        String coreGroupName = adminProperties.getProperty("CORE_Group_NAME_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "coreGroupName", coreGroupName);
        }
        adminProperties.setProperty("oldCellName", cellName);
        String value = adminProperties.getProperty("-includebuses");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "-includebuses", value);
        }
        Boolean includebuses = Boolean.FALSE;
        if ("true".equals(value)) {
            includebuses = Boolean.TRUE;
        }
        TaskCommand importNode = (TaskCommand)CommandMgr.getCommandMgr().createCommand("importNode");
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = new Session("addNode", false);
        Object th = null;
        try {
            importNode.setConfigSession(session);
            importNode.setParameter("archive", new UploadFile(archiveLocation));
            importNode.setParameter("nodeName", nodeName);
            importNode.setParameter("nodeGroupName", nodeGroupName);
            importNode.setParameter("options", adminProperties);
            CommandStep step = importNode.getCommandStep("ConfigCoreGroup");
            step.setParameter("coregroupName", coreGroupName);
            try {
                step = importNode.getCommandStep("ImportSIBus");
                step.setParameter("includeBuses", includebuses);
            }
            catch (CommandNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.tools.DMgrConfigUtils", (String)"73", DMgrConfigUtils.class);
            }
            importNode.execute();
            CommandResult result = importNode.getCommandResult();
            if (!result.isSuccessful()) {
                throw new AdminException(result.getException(), "doMergeConfig failed");
            }
            cs.save(session, false);
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            cs.discard(session);
            try {
                new File(archiveLocation).delete();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        cs.discard(session);
        try {
            new File(archiveLocation).delete();
        }
        catch (Exception ex) {}
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doMergeConfigData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUnMergeConfig(Properties nodeProperties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUnMergeConfigData", nodeProperties);
        }
        String cellName = nodeProperties.getProperty("CELL_NAME_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName", cellName);
        }
        String nodeName = nodeProperties.getProperty("NODE_NAME_KEY");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        TaskCommand cleanupNode = (TaskCommand)CommandMgr.getCommandMgr().createCommand("cleanupNode");
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = new Session("removeNode", false);
        Object th = null;
        try {
            cleanupNode.setConfigSession(session);
            cleanupNode.setParameter("nodeName", nodeName);
            cleanupNode.execute();
            CommandResult result = cleanupNode.getCommandResult();
            if (!result.isSuccessful()) {
                throw new AdminException(result.getException(), "doUnMergeConfig failed");
            }
            cs.save(session, false);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            cs.discard(session);
            throw throwable;
        }
        cs.discard(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doUnMergeConfigData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doRenameNode(String nodeName, String newNodeName, String shortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRenameNode", new Object[]{nodeName, newNodeName, shortName});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = new Session("renameNode", false);
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        try {
            TaskCommand cmd = (TaskCommand)cmdMgr.createCommand("renameNode");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("newNodeName", newNodeName);
            cmd.setParameter("shortName", shortName);
            cmd.execute();
            CommandResult cmdResult = cmd.getCommandResult();
            if (!cmdResult.isSuccessful()) {
                throw new AdminException(cmdResult.getException(), "doRenameNode failed");
            }
            configService.save(session, true);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            configService.discard(session);
            throw throwable;
        }
        configService.discard(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRenameNode");
        }
    }
}

