/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.NodeFederationUtility;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class BackupConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register(NodeFederationUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "backupConfig.log";
    public static final String NAME_PREFIX = "WebSphereConfig_";
    private File backupFile;
    private boolean stopServers = true;
    private int numFilesBackedUp = 0;

    public static void main(String[] args) {
        System.exit(new BackupConfigUtility().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU5000I", null, null);
    }

    protected int parseRequiredArgs(String[] args) {
        int nextArg = 3;
        if (args.length > 3 && !args[3].startsWith("-")) {
            this.backupFile = new File(args[3]);
            nextArg = 4;
        } else {
            this.backupFile = new File(this.generateBackupName());
        }
        return nextArg;
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        if (args[curOption].equals("-nostop")) {
            this.stopServers = false;
        } else {
            nextOption = -1;
        }
        return nextOption;
    }

    protected int runTool() throws Exception {
        if (this.backupFile.getCanonicalPath().startsWith(new File(this.configRoot).getCanonicalPath())) {
            this.issueMessage("xxxx", null, "ADMU5002E: Cannot create backup file in config directory");
            return -1;
        }
        this.issueMessage("ADMU5001I", new Object[]{this.configRoot, this.backupFile.getCanonicalPath()}, null);
        try {
            ModelMgr.initialize((String)"ws-server");
            Object stoppedServers = null;
            if (this.stopServers) {
                this.stopAllServers();
            }
            this.compressConfigDir();
            this.issueMessage("ADMU5002I", new Object[]{new Integer(this.numFilesBackedUp)}, null);
            return 0;
        }
        catch (Exception exc) {
            this.backupFile.delete();
            throw exc;
        }
    }

    private String generateBackupName() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        StringBuffer buf = new StringBuffer();
        buf.append(NAME_PREFIX);
        buf.append(String.valueOf(cal.get(1)) + "-");
        buf.append(this.getStringValWithLength2(cal.get(2) + 1) + "-");
        buf.append(this.getStringValWithLength2(cal.get(5)));
        String name = buf.toString();
        return this.makeNameUnique(name) + ".zip";
    }

    private String getStringValWithLength2(int val) {
        if (val < 10) {
            return "0" + String.valueOf(val);
        }
        return String.valueOf(val);
    }

    private String makeNameUnique(String name) {
        String uniqueName = name;
        int uniqueCounter = 1;
        while (new File(uniqueName + ".zip").exists()) {
            uniqueName = name + "_" + String.valueOf(uniqueCounter++);
        }
        return uniqueName;
    }

    private void compressConfigDir() throws IOException {
        this.numFilesBackedUp = this.compressDir(this.configRoot, this.backupFile);
    }
}

