/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusReport;
import com.ibm.ws.management.status.DeploymentManagerStatusReportExt;
import com.ibm.ws.management.status.NodeAgentStatusReport;
import com.ibm.ws.management.status.StatusCacheExtension;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.status.StatusReportExtendedData;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class DeploymentManagerStatusCache
extends AbstractStatusCache {
    private static final TraceComponent tc = Tr.register(DeploymentManagerStatusCache.class, null, null);
    private static final String CLASS_NAME = "com.ibm.ws.management.status.DeploymentManagerStatusCache";
    private static final String DMZ_PRODUCT_SHORT_NAME = "NDDMZ";
    private Map _server_reports = Collections.synchronizedMap(new HashMap());
    private Map _server_state = Collections.synchronizedMap(new HashMap());
    private Map nodeagent_state = Collections.synchronizedMap(new HashMap());
    private Map node_reports = Collections.synchronizedMap(new HashMap());
    private Map cluster_state = Collections.synchronizedMap(new HashMap());
    private Set _off_level_nodes = Collections.synchronizedSet(new HashSet());
    private Map server_type = new HashMap(1);

    protected DeploymentManagerStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentManagerStatusCache");
        }
        this.server_type.put(this._serverName, "DEPLOYMENT_MANAGER");
        this.setDownstreamReportsForExtensions();
        this.refreshNodeCache(false);
        this.refreshClusterCache(false);
        this.constructManagerReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentManagerStatusCache");
        }
    }

    protected void createStatusCacheExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatusCacheExtensions");
        }
        this._statusCacheExtensionClasses = this.createStatusCacheExtensionClassList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numExt=" + this._statusCacheExtensionClasses.length);
        }
        this._statusCacheExtensions = new StatusCacheExtension[this._statusCacheExtensionClasses.length];
        for (int i = 0; i < this._statusCacheExtensionClasses.length; ++i) {
            String className = null;
            try {
                className = this._statusCacheExtensionClasses[i];
                Class<?> extenderClass = Class.forName(className);
                Object o = extenderClass.newInstance();
                if (o instanceof StatusCacheExtension) {
                    this._statusCacheExtensions[i] = (StatusCacheExtension)o;
                    continue;
                }
                Exception e = new Exception("Class \"" + className + "\" does not implement required interface.");
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", (String)"106", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid extension class \"" + className + "\".", e);
                }
                this._statusCacheExtensions[i] = null;
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", (String)"110", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to instantiate extension \"" + className + "\".", e);
                }
                this._statusCacheExtensions[i] = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatusCacheExtensions");
        }
    }

    protected String[] createStatusCacheExtensionClassList() {
        String[] stringArray;
        String prodShortName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatusCacheExtensionClassList");
        }
        try {
            ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
            AdminService adminService = AdminServiceFactory.getAdminService();
            String thisNodeName = adminService.getNodeName();
            prodShortName = metadataHelper.getNodeBaseProductShortName(thisNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Product short name: " + prodShortName);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.createStatusCacheExtensionClassList", (String)"128", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get product short name.  Assuming it's not NDDMZ.", th);
            }
            prodShortName = "";
        }
        if (DMZ_PRODUCT_SHORT_NAME.equals(prodShortName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "com.ibm.ws.management.bla.runtime.DeploymentManagerStatusCacheExtension";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "com.ibm.ws.management.bla.runtime.DeploymentManagerStatusCacheExtension";
            stringArray = stringArray3;
            stringArray3[1] = "com.ibm.ws.webservices.admin.status.DeploymentManagerStatusCacheExtension";
        }
        String[] extClassList = stringArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatusCacheExtensionClassList", extClassList);
        }
        return extClassList;
    }

    protected void setDownstreamReportsForExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDownstreamReportsForExtensions");
        }
        for (StatusCacheExtension statusCacheExt : this._statusCacheExtensions) {
            if (statusCacheExt == null) continue;
            statusCacheExt.setDownstreamReports(this.node_reports);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDownstreamReportsForExtensions");
        }
    }

    public void registerEvents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvents");
        }
        this.listenForJ2EEStateNotifications();
        this.listenForCacheReportNotifications();
        this.listenForLocalApplicationNotifications();
        this.listenForClusterNotifications();
        for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
            if (extension2 == null) continue;
            extension2.registerEvents(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvents");
        }
    }

    private void constructManagerReport() {
        AppServerStatusReport dmgr_report = new AppServerStatusReport(this._app_state);
        dmgr_report.setCell(this._cellName);
        dmgr_report.setNode(this._nodeName);
        dmgr_report.setServer(this._serverName);
        this._server_state.put(this._serverName, "j2ee.state.running");
        this._server_reports.put(this._serverName, dmgr_report);
        NodeAgentStatusReport dmgr_node_report = new NodeAgentStatusReport(this._server_state, this._server_reports, this.server_type);
        dmgr_node_report.setCell(this._cellName);
        dmgr_node_report.setNode(this._nodeName);
        this.nodeagent_state.put(this._nodeName, "j2ee.state.running");
        this.node_reports.put(this._nodeName, dmgr_node_report);
    }

    public synchronized void addToCache(int type, String name, String state) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToCache", new Object[]{new Integer(type), name, state});
        }
        if (type == 1) {
            this.nodeagent_state.put(name, state);
            this.requestReport(name);
            this.sendReport(new Boolean(true));
        } else if (type == 2) {
            this.requestReport(Boolean.TRUE);
        } else if (type == 3) {
            this.cluster_state.put(name, "websphere.cluster.stopped");
            this.sendReport(new Boolean(false));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToCache");
        }
    }

    public synchronized void removeFromCache(int type, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromCache", new Object[]{new Integer(type), name});
        }
        if (type == 1) {
            this.nodeagent_state.put(name, "j2ee.state.stopped");
            this.node_reports.remove(name);
            this.sendReport(new Boolean(true));
        } else if (type == 2) {
            this.requestReport(Boolean.TRUE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromCache");
        }
    }

    public void requestReport(Boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        StringBuffer name = new StringBuffer();
        name.append("WebSphere:type=StatusCache,cell=");
        name.append(this._cellName);
        name.append(",process=nodeagent");
        name.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + name.toString());
        }
        Set nodes = super.getMBeans(name.toString());
        for (ObjectName na : nodes) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking on" + na);
                }
                if (force.equals(Boolean.TRUE)) {
                    super.invoke(na, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
                    continue;
                }
                super.invoke(na, "sendReport", null, null);
            }
            catch (MBeanException bean) {
                FFDCFilter.processException((Throwable)bean, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", (String)"202", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not invoke function sendReport on: " + na);
                Tr.debug(tc, "Exception: " + bean);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", (String)"209", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception in requestReport " + e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void requestReport(String node, Boolean force) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "requestReport");
            }
            StringBuffer name = new StringBuffer();
            name.append("WebSphere:type=StatusCache,cell=");
            name.append(this._cellName);
            name.append(",node=");
            name.append(node);
            name.append(",process=nodeagent");
            name.append(",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestReport: ObjectName " + name.toString());
            }
            ObjectName server = super.getMBean(name.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestReport: server " + server);
            }
            if (server != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invoking on" + server.toString());
                    }
                    if (force.equals(Boolean.TRUE)) {
                        super.invoke(server, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
                    } else {
                        super.invoke(server, "sendReport", null, null);
                    }
                }
                catch (MBeanException bean) {
                    FFDCFilter.processException((Throwable)bean, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", (String)"247", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not invoke function sendReport on: " + server);
                        Tr.debug(tc, "Exception: " + bean);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", (String)"253", (Object)this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception in requestReport " + e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void requestReport(String node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        this.requestReport(node, Boolean.FALSE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void placeReport(StatusReport report) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "placeReport", new Object[]{report});
        }
        if (report instanceof NodeAgentStatusReport) {
            String node = ((NodeAgentStatusReport)report).getNode();
            String state = (String)this.nodeagent_state.get(node);
            if (state == null || "j2ee.state.stopped".equals(state)) {
                boolean routable = RoutingTable.getInstance().isRoutable(node);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "is the NodeAgent is still routable: " + routable);
                }
                if (!routable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + node + " was STOPPED. Ignoring report which isn't routable");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "placeReport");
                    }
                    return;
                }
            }
            this.nodeagent_state.put(node, "j2ee.state.running");
            this.node_reports.put(node, report);
            this._sendReport();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "placeReport");
        }
    }

    public void _sendReport(Boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport - force", new Object[]{force});
        }
        if (force.equals(Boolean.TRUE)) {
            this.refreshClusterCache(true);
            this.refreshNodeCache(true);
            this.refreshCache(true);
            Iterator it = this._nodes.iterator();
            while (it.hasNext()) {
                this.requestReport((String)it.next(), Boolean.TRUE);
            }
        }
        this._sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport - force");
        }
    }

    public void _sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport");
        }
        DeploymentManagerStatusReportExt report = new DeploymentManagerStatusReportExt(this.nodeagent_state, this.node_reports, this.cluster_state);
        report.setCell(this._cellName);
        report.setDeployments(this._app_deployments);
        report.setClusterInfo(this._cluster_xml);
        for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
            StatusReportExtendedData extendedData;
            if (extension2 == null || (extendedData = extension2.getExtendedData(report)) == null) continue;
            report.setExtendedData(extendedData);
        }
        report.generate();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Src: " + this.getObjectName());
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            Notification notif = new Notification("websphere.status.report", this.getObjectName(), this._notif_num++);
            notif.setUserData(report);
            super.sendReportNotification(notif);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Going direct");
            }
            StatusCacheFactory.setReport(report);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, handback});
        }
        if (handback.equals(CONTROL_ADMIN_LISTENER)) {
            if (notification.getType().equals("websphere.ws390.servant.started")) {
                ServantMBeanStatus st = (ServantMBeanStatus)notification.getUserData();
                this._servant_up = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New Servant, refreshing the cache");
                }
                this.refreshCache(true);
                this.refreshNodeCache(true);
                this.refreshClusterCache(true);
                this.sendReport();
                return;
            }
        } else if (handback.equals(LOCAL_APP_LISTENER)) {
            ObjectName source = (ObjectName)notification.getSource();
            String appname = source.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application changed is: " + appname);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Type: " + notification.getType());
            }
            if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STOPPED");
                }
                this._app_state.put(appname, "j2ee.state.stopped");
            } else if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STOPPING");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STOPPED");
                }
                this._app_state.put(appname, "j2ee.state.stopped");
                this.constructManagerReport();
            } else if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STARTING");
                }
                this._app_state.put(appname, "j2ee.state.starting");
            } else if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now RUNNING");
                }
                this._app_state.put(appname, "j2ee.state.running");
            } else if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now FAILED");
                }
                this._app_state.put(appname, "j2ee.state.failed");
            }
            this.constructManagerReport();
        } else if (handback.equals(NODE_AGENT_LISTENER)) {
            ObjectName source = (ObjectName)notification.getSource();
            String sname = source.getKeyProperty("name");
            String node = source.getKeyProperty("node");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node);
            }
            if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + "is now STOPPING");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is now STOPPED");
                }
                this.nodeagent_state.put(node, "j2ee.state.stopped");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is stopped, deleting report");
                }
                this.node_reports.remove(node);
            } else if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is now STOPPED");
                }
                this.nodeagent_state.put(node, "j2ee.state.stopped");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is stopped, deleting report");
                }
                this.node_reports.remove(node);
            } else if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is now STARTING");
                }
                this.nodeagent_state.put(node, "j2ee.state.starting");
            } else if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is now RUNNING");
                }
                this.nodeagent_state.put(node, "j2ee.state.running");
            } else if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + sname + " on " + node + " is now FAILED");
                }
                this.nodeagent_state.put(node, "j2ee.state.failed");
            }
        } else if (handback.equals(STATUS_CACHE_LISTENER)) {
            if (notification.getType().equals("websphere.status.report")) {
                ObjectName source = (ObjectName)notification.getSource();
                String process = source.getKeyProperty("process");
                String node = source.getKeyProperty("node");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got a Report from node: " + node);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got a Report from process: " + process);
                }
                if (process.equals("nodeagent")) {
                    NodeAgentStatusReport report = (NodeAgentStatusReport)notification.getUserData();
                    String state = (String)this.nodeagent_state.get(node);
                    if (state == null || "j2ee.state.stopped".equals(state)) {
                        boolean routable = RoutingTable.getInstance().isRoutable(node);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "is the NodeAgent is still routable: " + routable);
                        }
                        if (!routable) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The " + node + " was STOPPED, I recived a report but it wasn't routable, so I'm ignoring it");
                            }
                            return;
                        }
                    }
                    this.nodeagent_state.put(node, "j2ee.state.running");
                    this.node_reports.put(node, report);
                }
            }
        } else if (handback.equals(CLUSTER_LISTENER)) {
            ObjectName source = (ObjectName)notification.getSource();
            String cname = source.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster changed is: " + cname);
            }
            if (notification.getType().equals("websphere.cluster.partial.start")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + cname + " is now TYPE_CLUSTER_PARTIAL_START");
                }
                this.cluster_state.put(cname, "websphere.cluster.partial.start");
            } else if (notification.getType().equals("websphere.cluster.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + cname + " is now TYPE_CLUSTER_STARTING");
                }
                this.cluster_state.put(cname, "websphere.cluster.partial.start");
            } else if (notification.getType().equals("websphere.cluster.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + cname + " is now TYPE_CLUSTER_RUNNING");
                }
                this.cluster_state.put(cname, "websphere.cluster.running");
            } else if (notification.getType().equals("websphere.cluster.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + cname + " is now TYPE_CLUSTER_STOPPING");
                }
                this.cluster_state.put(cname, "websphere.cluster.stopping");
            } else if (notification.getType().equals("websphere.cluster.partial.stop")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + cname + " is now TYPE_CLUSTER_PARTIAL_STOP");
                }
                this.cluster_state.put(cname, "websphere.cluster.partial.stop");
            } else if (notification.getType().equals("websphere.cluster.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + cname + " is now TYPE_CLUSTER_STOPPED");
                }
                this.cluster_state.put(cname, "websphere.cluster.stopped");
            }
        } else {
            boolean handled = false;
            for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
                if (extension2 == null) continue;
                handled |= extension2.handleNotification(notification, handback);
            }
            if (handled) {
                this.sendReport();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
            return;
        }
        this.sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void refreshClusterCache(boolean force_refresh) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshClusterCache");
        }
        if (this._clusters == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not refreshCache, _clusters was null");
            }
            return;
        }
        Set cache_cluster = this.cluster_state.keySet();
        Iterator cache_it = cache_cluster.iterator();
        while (cache_it.hasNext()) {
            String n = (String)cache_it.next();
            if (this._clusters.contains(n)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove Cluster: " + n + " from Cache as it is no longer on the HFS");
            }
            force_refresh = true;
            cache_it.remove();
        }
        for (String n : this._clusters) {
            if (cache_cluster.contains(n)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add Cluster: " + n + " to Cache as it is on the HFS");
            }
            force_refresh = true;
            this.cluster_state.put(n, "j2ee.state.stopped");
        }
        if (force_refresh) {
            StringBuffer name = new StringBuffer("WebSphere:type=Cluster");
            name.append(",process=");
            name.append(this._serverName);
            name.append(",*");
            Set active = this.getMBeans(name.toString());
            Iterator act = active.iterator();
            while (act.hasNext()) {
                String cluster_name = null;
                String cluster_stat = null;
                try {
                    ObjectName on = (ObjectName)act.next();
                    cluster_name = (String)AdminServiceFactory.getAdminService().getAttribute(on, "clusterName");
                    cluster_stat = (String)AdminServiceFactory.getAdminService().getAttribute(on, "state");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding cluster: " + cluster_name + " to Cache as it is running " + this.cluster_state);
                    }
                    this.cluster_state.put(cluster_name, cluster_stat);
                }
                catch (Exception mbe) {
                    FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshClusterCache", (String)"570", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshClusterCache " + mbe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshClusterCache");
        }
    }

    private void refreshNodeCache(boolean force_refresh) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshNodeCache");
        }
        Set cache_nodes = this.nodeagent_state.keySet();
        Iterator cache_it = cache_nodes.iterator();
        while (cache_it.hasNext()) {
            String n = (String)cache_it.next();
            if (this._nodes.contains(n)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove Node: " + n + " from Cache as it is no longer on the HFS");
            }
            force_refresh = true;
            cache_it.remove();
            this.node_reports.remove(n);
        }
        for (String n : this._nodes) {
            if (cache_nodes.contains(n)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add Node: " + n + " to Cache as it is on the HFS");
            }
            force_refresh = true;
            this.nodeagent_state.put(n, "j2ee.state.stopped");
        }
        if (force_refresh) {
            StringBuffer name = new StringBuffer("WebSphere:type=Server");
            name.append(",process=nodeagent");
            name.append(",*");
            Set active = this.getMBeans(name.toString());
            Iterator act = active.iterator();
            while (act.hasNext()) {
                String node_name = null;
                try {
                    node_name = (String)AdminServiceFactory.getAdminService().getAttribute((ObjectName)act.next(), "nodeName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding node: " + node_name + " to Cache as it is running");
                    }
                    this.nodeagent_state.put(node_name, "j2ee.state.running");
                }
                catch (Exception mbe) {
                    FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshNodeCache", (String)"633", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshNodeCache " + mbe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshCache(boolean force_refresh) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshCache");
        }
        ConfigObject serverEntry = null;
        try {
            Object var5_3;
            try {
                serverEntry = this.findServerEntry();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshCache", (String)"652", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find Server Entry", serverEntry);
                }
                var5_3 = null;
                if (serverEntry == null) {
                    return;
                }
            }
            var5_3 = null;
            if (serverEntry == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (serverEntry == null) {
                return;
            }
            throw throwable;
        }
        Set cache_apps = this._app_state.keySet();
        Set se_apps = this.buildAppList(serverEntry);
        Iterator cache_it = cache_apps.iterator();
        while (cache_it.hasNext()) {
            String app = (String)cache_it.next();
            if (se_apps.contains(app)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove App: " + app + " from Cache as it is no longer in Server Entry");
            }
            force_refresh = true;
            cache_it.remove();
        }
        for (String app : se_apps) {
            if (cache_apps.contains(app)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add App: " + app + " to Cache as it is new in Server Entry");
            }
            force_refresh = true;
            this._app_state.put(app, "j2ee.state.stopped");
        }
        if (force_refresh) {
            StringBuffer name = new StringBuffer("WebSphere:type=Application,node=");
            name.append(this._nodeName);
            name.append(",process=");
            name.append(this._serverName);
            name.append(",*");
            Set active = this.getMBeans(name.toString());
            Iterator act = active.iterator();
            while (act.hasNext()) {
                String appname = null;
                try {
                    appname = (String)AdminServiceFactory.getAdminService().getAttribute((ObjectName)act.next(), "name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding App: " + appname + " to Cache as it is running");
                    }
                    this._app_state.put(appname, "j2ee.state.running");
                }
                catch (Exception mbe) {
                    FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshCache", (String)"701", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshCache " + mbe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    protected void listenForClusterNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForClusterNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                StringBuffer name = new StringBuffer("WebSphere:type=Cluster,");
                name.append("node=");
                name.append(this._nodeName);
                name.append(",*");
                ObjectName cluster = new ObjectName(name.toString());
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("websphere.cluster.partial.start");
                filter.enableType("websphere.cluster.running");
                filter.enableType("websphere.cluster.starting");
                filter.enableType("websphere.cluster.stopping");
                filter.enableType("websphere.cluster.partial.stop");
                filter.enableType("websphere.cluster.stopped");
                adminService.addNotificationListenerExtended(cluster, this, filter, CLUSTER_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForClusterNotifications", (String)"734", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForClusterNotifications " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForClusterNotifications");
        }
    }

    protected void listenForJ2EEStateNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForJ2EEStateNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName appserver = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("j2ee.state.stopping");
                filter.enableType("j2ee.state.stopped");
                filter.enableType("j2ee.state.starting");
                filter.enableType("j2ee.state.running");
                filter.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(appserver, this, filter, NODE_AGENT_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForJ2EEStateNotifications", (String)"755", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForClusterNotifications " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForJ2EEStateNotifications");
        }
    }

    protected void listenForCacheReportNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForCacheReportNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName nodeagent = new ObjectName("WebSphere:*,type=StatusCache,process=nodeagent");
                adminService.addNotificationListenerExtended(nodeagent, this, null, STATUS_CACHE_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForCacheReportNotifications", (String)"769", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForCacheReportNotifications " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForCacheReportNotifications");
        }
    }

    protected void listenForLocalApplicationNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForLocalApplicationNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String dmgrName = adminService.getProcessName();
                StringBuffer query_name = new StringBuffer("WebSphere:type=Application,node=");
                query_name.append(this._nodeName);
                query_name.append(",process=" + dmgrName);
                query_name.append(",*");
                ObjectName app = new ObjectName(query_name.toString());
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("j2ee.state.stopping");
                filter.enableType("j2ee.state.stopped");
                filter.enableType("j2ee.state.starting");
                filter.enableType("j2ee.state.running");
                filter.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(app, this, filter, LOCAL_APP_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForLocalApplicationNotifications", (String)"795", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForLocalApplicationNotifications " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForLocalApplicationNotifications");
        }
    }

    protected void listenForMessageListenerNotifications() {
    }

    public void childAdded(ServerInfo info) {
        this.addToCache(1, info.getNode(), "j2ee.state.running");
        this.requestReport(info.getNode());
    }

    public void childRemoved(ServerInfo info) {
        this.removeFromCache(1, info.getNode());
        this.sendReport();
    }

    public String dumpCache() {
        StringBuffer buff = new StringBuffer();
        buff.append("Deployment Manager: ");
        buff.append("\n");
        buff.append("---------------------\n");
        Set entrySet = this._app_state.entrySet();
        for (Map.Entry me : entrySet) {
            buff.append("App: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\n");
            buff.append("\n");
        }
        Set nodeEntrySet = this.nodeagent_state.entrySet();
        for (Map.Entry me : nodeEntrySet) {
            buff.append("\nNode: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\nReport: ");
            buff.append(this.node_reports.get(me.getKey()));
            if (this.node_reports.get(me.getKey()) != null) {
                buff.append(((StatusReport)this.node_reports.get(me.getKey())).print());
            }
            buff.append("\n");
            buff.append("\n");
        }
        buff.append("END OF DUMP");
        return buff.toString();
    }
}

