/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileDocument;
import com.ibm.ws.management.repository.ServantFileRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ServantFileDocument {
    private String repositoryRoot;
    private String repositoryTemp;
    private String repositoryBackup;
    private FileTransferConfig repositoryFTConfig;
    private FileTransferOptions repositoryFTOptions;
    private HashMap locks = new HashMap();
    private Integer mkdirsLock = new Integer(0);
    private static TraceComponent tc = Tr.register(ServantFileDocument.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");

    ServantFileDocument() {
    }

    protected Object getDirLock() {
        return this.mkdirsLock;
    }

    protected synchronized void setRepository(ServantFileRepository r) {
        this.repositoryRoot = r.getRepositoryDir();
        this.repositoryTemp = r.getTempDir();
        this.repositoryBackup = r.getBackupDir();
        this.repositoryFTOptions = r.getFileTransferOptions();
        this.repositoryFTConfig = r.getFileTransferConfig();
    }

    protected DocumentDigestImpl getDigest(String docURI) throws DocumentIOException {
        DocumentDigestImpl digest = null;
        File digestFile = this.getFileForURI(docURI + ".digest");
        digest = digestFile.exists() ? this.readDigest(docURI + ".digest", digestFile) : this.calcDigest(docURI);
        return digest;
    }

    protected DocumentDigestImpl calcDigest(String docURI) throws DocumentIOException {
        DocumentDigestImpl digest;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "calcDigest: " + docURI);
        }
        File f = this.getFileForURI(docURI);
        boolean locked = false;
        try {
            try {
                digest = new DocumentDigestImpl();
                this.lockForReading(docURI);
                locked = true;
                digest.calc(new FileInputStream(f));
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"146", FileDocument.class);
                Tr.error(tc, "ADMR0104E", new Object[]{docURI, ioe});
                throw new DocumentIOException(ioe, docURI);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"152", FileDocument.class);
                Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
                throw this.getDocumentIOException(e, docURI);
            }
            Object var7_5 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
            throw throwable;
        }
        return digest;
    }

    /*
     * Loose catch block
     */
    private DocumentDigestImpl readDigest(String digestURI, File digestFile) throws DocumentIOException {
        DocumentDigestImpl digest;
        block17: {
            boolean locked;
            ObjectInputStream objIn;
            FileInputStream in;
            block14: {
                IOException e22;
                block13: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readDigest: " + digestURI);
                    }
                    digest = null;
                    in = null;
                    objIn = null;
                    locked = true;
                    this.lockForReading(digestURI);
                    locked = true;
                    in = new FileInputStream(this.repositoryRoot + File.separator + digestURI);
                    objIn = new ObjectInputStream(in);
                    digest = (DocumentDigestImpl)objIn.readObject();
                    Object var9_7 = null;
                    try {
                        objIn.close();
                    }
                    catch (IOException e22) {
                        FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"214", null);
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Error while closing object stream: " + e22);
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e22) {
                    FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"223", null);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Error while closing file input stream: " + e22);
                }
            }
            if (locked) {
                this.unlockForReading(digestURI);
            }
            break block17;
            {
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"152", FileDocument.class);
                    Tr.error(tc, "ADMR0104E", new Object[]{digestURI, t});
                    throw this.getDocumentIOException(t, digestURI);
                }
            }
            catch (Throwable throwable) {
                block16: {
                    IOException e22;
                    block15: {
                        Object var9_8 = null;
                        try {
                            objIn.close();
                        }
                        catch (IOException e22) {
                            FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"214", null);
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "Error while closing object stream: " + e22);
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e22) {
                        FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"223", null);
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Error while closing file input stream: " + e22);
                    }
                }
                if (locked) {
                    this.unlockForReading(digestURI);
                }
                throw throwable;
            }
        }
        return digest;
    }

    /*
     * Loose catch block
     */
    private DocumentDigestImpl copyDocument(InputStream from, OutputStream to, boolean getDigest) throws IOException {
        DocumentDigestImpl digest;
        block18: {
            Exception e2;
            block17: {
                block16: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "copyDocument");
                    }
                    InputStream fromFilter = null;
                    digest = null;
                    if (getDigest) {
                        digest = new DocumentDigestImpl();
                        fromFilter = digest.startInputFilter(from);
                    } else {
                        fromFilter = from;
                    }
                    byte[] data = new byte[4096];
                    int bytesRead = fromFilter.read(data);
                    while (bytesRead != -1) {
                        to.write(data, 0, bytesRead);
                        bytesRead = fromFilter.read(data);
                    }
                    if (!getDigest) break block16;
                    digest.stopInputFilter();
                }
                Object var9_9 = null;
                try {
                    to.close();
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Error while closing to stream: " + e2);
                }
            }
            try {
                from.close();
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while closing from stream: " + e2);
                }
                break block18;
            }
            {
                catch (IOException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"851", FileDocument.class);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                block20: {
                    block19: {
                        Object var9_10 = null;
                        try {
                            to.close();
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                            if (!tc.isDebugEnabled()) break block19;
                            Tr.debug(tc, "Error while closing to stream: " + e2);
                        }
                    }
                    try {
                        from.close();
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "Error while closing from stream: " + e2);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDocument");
        }
        return digest;
    }

    protected DocumentContentSource read(String docURI) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading " + docURI);
        }
        FileInputStream data = null;
        FileOutputStream out = null;
        FileDownloadInputStream source = null;
        DocumentDigestImpl digest = null;
        File documentFile = this.getFileForURI(docURI);
        File tempFile = this.createTempFile(docURI);
        try {
            data = new FileInputStream(documentFile);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"351", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
            throw new DocumentIOException(e, "Unable to create input stream on document file: " + docURI);
        }
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"363", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
            throw new DocumentIOException(e, "Unable to create output stream on temp file: " + tempFile.getPath());
        }
        long lastModified = 0L;
        boolean locked = false;
        try {
            try {
                this.lockForReading(docURI);
                locked = true;
                digest = this.copyDocument(data, out, true);
                lastModified = documentFile.lastModified();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"375", FileDocument.class);
                Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
                throw this.getDocumentIOException(e, "Unable to copy document to temp file: " + docURI);
            }
            Object var13_12 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
            throw throwable;
        }
        source = new FileDownloadInputStream(tempFile);
        source.setFileTransferConfig(this.repositoryFTConfig);
        source.setOptions(this.repositoryFTOptions);
        source.setSrcPath(tempFile.getAbsolutePath().substring(this.repositoryTemp.length()));
        Document doc = new Document(docURI, (DocumentDigest)digest);
        DocumentContentSource dcs = new DocumentContentSource(doc, (InputStream)source);
        dcs.setLastModified(lastModified);
        return dcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(String docURI) throws DocumentIOException {
        File baseFile = new File(this.repositoryTemp + docURI);
        String tempFileName = baseFile.getName().replace('%', '_');
        if (tempFileName.length() < 3) {
            tempFileName = new String(tempFileName + "__");
        }
        File tempFileDir = baseFile.getParentFile();
        File tempFile = null;
        try {
            Integer n = this.mkdirsLock;
            synchronized (n) {
                tempFileDir.mkdirs();
                tempFile = File.createTempFile(tempFileName, null, tempFileDir);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileDocument.createTempFile", (String)"404", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{docURI, t});
            throw new DocumentIOException(t, "Unable to create temp file for document: " + docURI);
        }
        return tempFile;
    }

    private void lockForReading(String docURI) throws DocumentIOException {
        try {
            this.getLock(docURI).startReading();
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.lockForWriting", (String)"640", FileDocument.class);
            throw new DocumentIOException(e, "Unable to get read lock for document " + docURI);
        }
    }

    private void unlockForReading(String docURI) {
        WriterPriorityReadersWriterLock lock = this.getLock(docURI);
        lock.stopReading();
        this.releaseLock(docURI, lock);
    }

    private synchronized WriterPriorityReadersWriterLock getLock(String docURI) {
        WriterPriorityReadersWriterLock lock = (WriterPriorityReadersWriterLock)this.locks.get(docURI);
        if (lock == null) {
            lock = new WriterPriorityReadersWriterLock();
            this.locks.put(docURI, lock);
        }
        return lock;
    }

    private synchronized void releaseLock(String docURI, WriterPriorityReadersWriterLock lock) {
        if (!lock.hasReaderOrWriter()) {
            this.locks.remove(docURI);
        }
    }

    private File getFileForURI(String uri) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFileForURI", new Object[]{this.repositoryRoot, uri});
        }
        return new File(this.repositoryRoot + File.separator + uri);
    }

    private DocumentIOException getDocumentIOException(Throwable t, String msg) {
        if (t instanceof DocumentIOException) {
            return (DocumentIOException)t;
        }
        return new DocumentIOException(t, msg);
    }
}

