/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.remote;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.remote.AdminServiceForwarder;
import com.ibm.ws.orb.GlobalORBFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RMIServer
implements JMXConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RMIServer.class, "Admin", "com.ibm.ws.management.resources.connector");
    private JMXConnectorServer jmxConnectorServer = null;
    private AdminServiceForwarder adminService = null;
    private boolean jmxConnectorEnabled = false;
    Properties connectorProps = null;
    private String jndiPath = "/jndi/JMXConnector";
    private String profileKey;
    private int port;
    private String createOrbListener;
    private String oldStylePath;
    private boolean started = false;

    public void initialize(Properties _props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", _props);
        }
        this.connectorProps = _props;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.connectorProps);
        }
    }

    public void start() throws ConnectorException {
        ORB orb;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            if (this.started) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start - Connector already sta ted");
                }
                return;
            }
            String host = this.connectorProps.getProperty("host");
            if (host.equals("*")) {
                host = null;
            }
            this.port = Integer.parseInt(this.connectorProps.getProperty("port"));
            this.profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "profileKey=" + this.profileKey);
            }
            this.createOrbListener = (String)this.connectorProps.get("createOrbListener");
            MBeanServer mbeanServer = AdminServiceFactory.getMBeanFactory().getMBeanServer();
            HashMap<String, Object> env = new HashMap<String, Object>();
            orb = GlobalORBFactory.globalORB();
            env.put("java.naming.corba.orb", orb);
            env.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
            env.put("jmx.remote.x.server.connection.timeout", new Long(Long.MAX_VALUE));
            env.put("jmx.remote.jndi.rebind", "true");
            String jndiBindPath = this.connectorProps.getProperty("jndi", this.jndiPath);
            this.oldStylePath = jndiBindPath.substring(6);
            jndiBindPath = jndiBindPath + this.port;
            String bindPath = jndiBindPath.substring(6);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JSR160RMI server stub will be bound at " + jndiBindPath);
                }
                JMXServiceURL url = new JMXServiceURL("iiop", host, this.port, jndiBindPath);
                this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbeanServer);
                this.adminService = new AdminServiceForwarder();
                this.jmxConnectorServer.setMBeanServerForwarder(this.adminService);
                this.jmxConnectorServer.start();
                this.jmxConnectorEnabled = true;
                if (this.profileKey != null && this.profileKey.length() >= 1) break block14;
                try {
                    Properties p = new Properties();
                    p.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
                    InitialContext ic = new InitialContext(p);
                    Object server_stub = ic.lookup(bindPath);
                    ic.rebind(this.oldStylePath, server_stub);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The server stub is also bound to " + this.oldStylePath, server_stub);
                    }
                }
                catch (NamingException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.remote.RMIServer.start", (String)"144", (Object)this);
                    Tr.warning(tc, "Exception during JSR160RMI server start ", ex);
                }
            }
            catch (IOException io) {
                throw new ConnectorException(io);
            }
        }
        if (this.profileKey != null && this.createOrbListener != null && this.createOrbListener.equals("true")) {
            orb.createListener(this.port);
        }
        this.started = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMX Connector is available at serviceURL address", this.jmxConnectorServer.getAddress());
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop - RMI Connector already topped");
            }
            return;
        }
        if (this.jmxConnectorServer != null && this.jmxConnectorEnabled) {
            try {
                this.jmxConnectorServer.stop();
            }
            catch (IOException io) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.getType() + " could not stop due to " + io);
                }
                FFDCFilter.processException((Throwable)io, (String)"com.ibm.ws.management.remote.RMIServer.stop", (String)"182", (Object)this);
            }
        }
        if (this.profileKey == null || this.profileKey.length() < 1) {
            try {
                InitialContext ic = new InitialContext();
                if (this.oldStylePath != null && this.oldStylePath.length() > 0) {
                    ic.unbind(this.oldStylePath);
                }
            }
            catch (NamingException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.remote.RMIServer.stop", (String)"194", (Object)this);
                Tr.warning(tc, "Exception during JSR160RMI server stop ", ex);
            }
        }
        try {
            if (this.profileKey != null) {
                if ("true".equals(this.createOrbListener)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempting to stop JSR160RMI port " + this.port);
                    }
                    ORB orb = GlobalORBFactory.globalORB();
                    orb.destroyListener(this.port);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopped JSR160RMI port " + this.port);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.remote.RMIServer.stop", (String)"212", (Object)this);
        }
        this.started = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public Properties getProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", this.connectorProps);
        }
        return this.connectorProps;
    }

    public String getType() {
        return this.connectorProps.getProperty("type");
    }

    public String getName() {
        return "type=" + this.connectorProps.getProperty("type") + ";" + "host" + "=" + this.connectorProps.getProperty("host") + ";" + "port" + "=" + this.connectorProps.getProperty("port");
    }
}

