/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import java.util.Properties;

public class NodeAgentCollector
implements RoutingListener {
    private static TraceComponent _tc = Tr.register(NodeAgentCollector.class, "Admin", null);
    private static boolean _metadataSentToDmgr = false;

    public NodeAgentCollector() {
        block7: {
            block6: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "NodeAgentCollector");
                }
                try {
                    ManagedObjectMetadataCollectorManager collectorMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null);
                    Properties properties = collectorMgr.updateMetadata("Collect Metadata", null);
                }
                catch (Throwable t) {
                    if (!_tc.isEventEnabled()) break block6;
                    Tr.event(_tc, "Could not run local metadata collection.", t);
                }
            }
            try {
                RoutingTable rt = RoutingTable.getInstance();
                rt.addRoutingListener(this);
            }
            catch (Throwable t) {
                if (!_tc.isEventEnabled()) break block7;
                Tr.event(_tc, "Could not register as RoutingTableListener.", t);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "NodeAgentCollector");
        }
    }

    public static synchronized void collectMetadataAndSendToDmgr(AdminClient dmgrAdminClient) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "collectMetadataAndSendToDmgr");
        }
        if (_metadataSentToDmgr) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "collectMetadataAndSendToDmgr: Already done.");
            }
            return;
        }
        Properties newMetadata = null;
        try {
            ManagedObjectMetadataCollectorManager collMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null, dmgrAdminClient);
            newMetadata = collMgr.updateMetadata("Collect Metadata", null);
            _metadataSentToDmgr = true;
        }
        catch (Exception e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "collectMetadataAndSendToDmgr: Metadata collection unsuccessful.", e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "collectMetadataAndSendToDmgr", newMetadata);
        }
    }

    public void childAdded(ServerInfo serverInfo) {
    }

    public void childRemoved(ServerInfo serverInfo) {
    }

    public void parentAdded(ServerInfo serverInfo) {
        block6: {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "parentAdded");
            }
            AdminClient adminClient = null;
            try {
                adminClient = serverInfo.getAdminClient();
            }
            catch (Exception e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "parentAdded", new Object[]{"AdminClient connection to deployment manager is unavailable.", e});
                }
                return;
            }
            try {
                NodeAgentCollector.collectMetadataAndSendToDmgr(adminClient);
            }
            catch (Throwable t) {
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "parentAdded", "Metadata collection exception received: " + t);
            }
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
    }
}

