/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class ManagedObjectMetadataAccessorImpl
implements ManagedObjectMetadataAccessor,
ConfigRepositoryListener {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataAccessorImpl.class, "Admin", null);
    private static final String INSTALL_ROOT_PROPERTY_NAME = "was.install.root";
    private boolean _isServerProcess;
    private String _serverCellName;
    private String _repoRoot;
    private String _cellName;
    private String _cellConfigPath;
    private HashMap _cache;

    public ManagedObjectMetadataAccessorImpl(Properties props) throws AdminException {
        block18: {
            AdminService adminService;
            this._isServerProcess = false;
            this._repoRoot = null;
            this._cache = new HashMap();
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "ManagedObjectMetadataAccessorImpl", "Accessor props: " + props);
            }
            if ((adminService = AdminServiceFactory.getAdminService()) != null) {
                this._isServerProcess = true;
            }
            this._repoRoot = props.getProperty("was.repository.root");
            if (!(this._isServerProcess || this._repoRoot != null && this._repoRoot.length() != 0)) {
                AdminException ae = new AdminException("Property \"was.repository.root\" not defined or has a zero-length value.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "ManagedObjectMetadataAccessorImpl: Exception", ae);
                }
                throw ae;
            }
            this._cellName = props.getProperty("local.cell");
            if (this._cellName == null || this._cellName.length() == 0) {
                if (this._isServerProcess) {
                    this._cellName = adminService.getCellName();
                } else {
                    AdminException ae = new AdminException("Property \"local.cell\" not defined or has a zero-length value.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "ManagedObjectMetadataAccessorImpl: Exception", ae);
                    }
                    throw ae;
                }
            }
            if (this._isServerProcess) {
                this._serverCellName = adminService.getCellName();
                if (this._cellName.equals(this._serverCellName)) {
                    try {
                        Properties rProps = new Properties();
                        String pKey = AdminContext.peek();
                        if (pKey == null) {
                            rProps.setProperty("location", "local");
                        } else {
                            rProps.setProperty("location", "profilekey");
                            rProps.setProperty("profileKey", pKey);
                        }
                        ConfigRepository repo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)rProps);
                        repo.addListener((ConfigRepositoryListener)this);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Added as a config repository listener.");
                        }
                        break block18;
                    }
                    catch (AdminException e) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Could not get ConfigRepository reference.  Not added as a listener.", e);
                        }
                        break block18;
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Specified cell name \"" + this._cellName + "\" does not match this server's cell name, \"" + this._serverCellName + "\".");
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataAccessorImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMetadataProperties(String nodeName) throws AdminException {
        Properties nodeData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperties", "nodeName=" + nodeName);
        }
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            nodeData = (Properties)this._cache.get(nodeName);
        }
        if (nodeData == null) {
            nodeData = this.extractMetadata(nodeName);
            hashMap = this._cache;
            synchronized (hashMap) {
                this._cache.put(nodeName, nodeData);
            }
        }
        nodeData = (Properties)nodeData.clone();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperties", "props=" + nodeData);
        }
        return nodeData;
    }

    public String getMetadataProperty(String nodeName, String propName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperty", new String[]{"nodeName=" + nodeName, "propName=" + propName});
        }
        Properties nodeData = this.getMetadataProperties(nodeName);
        String propValue = nodeData.getProperty(propName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperty", propName + "=" + propValue);
        }
        return propValue;
    }

    private Properties extractMetadata(String nodeName) throws AdminException {
        Properties metadata2;
        ConfigRepository repo;
        String docURI;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractMetadata", "nodeName=" + nodeName);
        }
        try {
            docURI = ConfigStructureHelper.getURI((String)this._cellName, (String)nodeName, (String)"", (String)"node-metadata.properties");
            Properties rProps = new Properties();
            String pKey = AdminContext.peek();
            if (pKey == null) {
                rProps.setProperty("location", "local");
            } else {
                rProps.setProperty("location", "profilekey");
                rProps.setProperty("profileKey", pKey);
            }
            rProps.setProperty("com.ibm.ws.management.standalone", "true");
            if (this._repoRoot != null) {
                rProps.setProperty("was.repository.root", this._repoRoot);
            }
            if ((repo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)rProps)) == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "extractMetadata: Null ConfigRepository returned.");
                }
                MetadataNotAvailableException me = new MetadataNotAvailableException("Could not obtain a reference to the Config Repository.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "extractMetadata: No Config Repository: ", (Object)me);
                }
                throw me;
            }
        }
        catch (MetadataNotAvailableException me) {
            throw me;
        }
        catch (Throwable t) {
            MetadataNotAvailableException me = new MetadataNotAvailableException(t, "Unexpected exception received while obtaining a reference to the Config Repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: Unexpected exception: ", (Object)me);
            }
            throw me;
        }
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "extractMetadata: Extracting " + docURI);
            }
            DocumentContentSource docContents = repo.extract(docURI);
            InputStream inStream = docContents.getSource();
            metadata2 = new Properties();
            metadata2.load(inStream);
            try {
                inStream.close();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataAccessorImpl.extractMetadata", (String)"257", (Object)this);
            }
        }
        catch (RepositoryException repE) {
            MetadataNotAvailableException me = new MetadataNotAvailableException((Throwable)repE, "Could not obtain managed object metadata from Config Repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: RepositoryException: ", (Object)me);
            }
            throw me;
        }
        catch (Throwable t) {
            MetadataNotAvailableException me = new MetadataNotAvailableException(t, "Unexpected exception received while extracting metadata from the Config Repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: Unexpected exception: ", (Object)me);
            }
            throw me;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractMetadata");
        }
        return metadata2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(String nodeName) {
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removing from cache: nodeName=" + nodeName);
            }
            this._cache.remove(nodeName);
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent event2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "onChangeCompletion");
        }
        ConfigChangeNotifier[] changes = event2.getChanges();
        ArrayList updatedMetadataFiles = new ArrayList();
        String suffix = "/node-metadata.properties";
        for (int i = 0; i < changes.length; ++i) {
            String uri = changes[i].getUri();
            if (!uri.toLowerCase().endsWith("/node-metadata.properties")) continue;
            String nodeName = ConfigStructureHelper.nodeNameForDoc((String)uri);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Metadata file has changed: ", "URI=" + uri + ", nodeName=" + nodeName);
            }
            this.removeFromCache(nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepositoryEpochRefresh() {
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Epoch refresh.  Clearing cache.");
            }
            this._cache.clear();
        }
    }
}

