/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.filetransfer.client;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.filetransfer.FileTransferUtils;
import com.ibm.ws.management.util.AdminCertificateHelper;
import com.ibm.ws.management.util.RSAPropagationHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.auth.kerberos.KerberosThreadManager;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationManager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.util.Base64;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.net.ssl.HttpsURLConnection;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferClientImpl
implements FileTransferClient,
NotificationListener {
    private static TraceComponent tc = Tr.register(FileTransferClientImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static final String CLASSNAME = "com.ibm.ws.management.filetransfer.client.FileTransferClientImpl";
    private static String UTF_ENCODING = "UTF-8";
    private static final String TRANSFER = "/FileTransfer/transfer/";
    private static final String SECURE_CERT = "/FileTransfer/cert/";
    private static final String OPEN_CERT = "/FileTransfer/ocert/";
    private static final long NO_RANGE_VALUE = -99L;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int FILE_BLOCK_SIZE = 0x100000;
    private KerberosPolicy kerberosPolicy = null;
    String transferHost = null;
    int transferPort = 0;
    int transferSecurePort = 0;
    String ftServerName = null;
    boolean securityEnabled = false;
    boolean setAuthHeader = false;
    String protocolToUse = "http";
    int portToUse = 0;
    String serverStagingLocation = null;
    FileTransferConfig ftConfig = null;
    VariableMap vmap = null;
    X509Certificate targetCertificate = null;
    private boolean _deviceMgrAgent = false;
    private Properties jmxConnProps = null;
    private AdminClient adminClient = null;
    private ObjectName ftServerObjName = null;
    private int retryLimit = FileTransferConfigImpl.DEFAULT_RETRIES;
    private int retryWaitTime = FileTransferConfigImpl.DEFAULT_TIMEOUT;
    private RoleBasedAuthorizer roleBasedAuth = null;
    private String userInstallRoot = null;
    private static String downloadPathsNotRestricted = null;
    private static boolean downloadPathsUnrestricted = false;
    private Exception initEx = null;
    private static final String AUTHORIZATION_ENCODING = "Authorization-Encoding";
    private static final String encoding = System.getProperty("file.encoding");

    public void uploadFile(InputStream src, String destPath) throws TransferFailedException {
        this.uploadFile(src, destPath, null);
    }

    public void uploadFile(File srcFile, String destPath) throws TransferFailedException {
        this.uploadFile(srcFile, destPath, null);
    }

    public void uploadFile(InputStream src, String destPath, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        int rc = 0;
        try {
            OutputStreamHandlerForInputStream outputHandler;
            UploadConnectionParams connParams;
            HttpURLConnection conn;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uploadFile (1)", new Object[]{"destPath=" + destPath, "options=" + options});
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createUploadURL(destPath, options);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "upload url=" + url);
            }
            if ((rc = (conn = this.openConnection(url, connParams = new UploadConnectionParams(null, null), outputHandler = new OutputStreamHandlerForInputStream(src, options))).getResponseCode()) != 200) {
                throw new TransferFailedException("File upload to " + destPath + " failed with rc = " + rc);
            }
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, e);
            }
            Tr.service(tc, "ADFS0124", new Object[]{destPath, e});
            throw new TransferFailedException("Error occurred during upload to: " + destPath + ". Exception: " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.uploadFile", (String)"317", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, t);
            }
            Tr.service(tc, "ADFS0124", new Object[]{destPath, t});
            throw new TransferFailedException("Error occurred during upload to: " + destPath + ". Exception: " + t, t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadFile (1) rc=" + rc);
            }
        }
    }

    public void uploadFile(File srcFile, String destPath, FileTransferOptions options) throws TransferFailedException {
        srcFile = this.mapVariables(srcFile);
        this.uploadFile(srcFile, destPath, 0L, srcFile.length(), options);
    }

    public void uploadFile(File srcFile, String destPath, long rangeStart) throws TransferFailedException, IndexOutOfBoundsException {
        srcFile = this.mapVariables(srcFile);
        this.uploadFile(srcFile, destPath, rangeStart, srcFile.length());
    }

    public void uploadFile(File srcFile, String destPath, long rangeStart, FileTransferOptions options) throws TransferFailedException, IndexOutOfBoundsException {
        srcFile = this.mapVariables(srcFile);
        this.uploadFile(srcFile, destPath, rangeStart, srcFile.length(), options);
    }

    public void uploadFile(File srcFile, String destPath, long rangeStart, long rangeEnd) throws TransferFailedException, IndexOutOfBoundsException {
        this.uploadFile(srcFile, destPath, rangeStart, rangeEnd, null);
    }

    public void uploadFile(File srcFile, String destPath, long rangeStart, long rangeEnd, FileTransferOptions options) throws TransferFailedException, IndexOutOfBoundsException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uploadFile (2) from srcFile", new Object[]{"srcFile=" + srcFile, "destPath=" + destPath, "options=" + options});
            }
            if (rangeStart > rangeEnd || rangeStart < 0L) {
                throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + rangeStart + ", " + rangeEnd + "] for " + srcFile.toString() + ".");
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createUploadURL(destPath, options);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "upload url=" + url);
            }
            this.uploadFileInternal(url, srcFile, rangeStart, rangeEnd, options);
        }
        catch (IndexOutOfBoundsException iob) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, iob);
            }
            throw iob;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, e);
            }
            Tr.service(tc, "ADFS0124", new Object[]{destPath, e});
            throw new TransferFailedException("Error occurred during upload to: " + destPath + ". Exception: " + e.toString(), (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.uploadFile", (String)"443", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, destPath, t);
            }
            Tr.service(tc, "ADFS0124", new Object[]{destPath, t});
            throw new TransferFailedException("Error occurred during upload to: " + destPath + ". Exception: " + t.toString(), t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadFile (2)");
            }
        }
    }

    private void uploadFileInternal(URL url, File srcFile, long startRange, long endRange, FileTransferOptions options) throws TransferFailedException, IOException {
        RandomAccessFile src = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadInternal");
        }
        try {
            String srcFileString = this.mapVariables(srcFile.toString());
            srcFile = new File(srcFileString);
            src = new RandomAccessFile(srcFile, "r");
            boolean rc = false;
            if ((startRange != 0L || src.length() != 0L) && startRange >= src.length()) {
                src.close();
                throw new IndexOutOfBoundsException("The rangeStart goes past the end of the file. Nothing will be transferred.  rangeStart=[" + startRange + "] for " + srcFile.toString() + ".");
            }
            options = this.createDefaultOptionsIfNecessary(options);
            long bufferSize = 8192L;
            long currentStart = 0L;
            long currentEnd = 0L;
            int retryCount = 0;
            boolean finished = false;
            while (retryCount <= this.retryLimit) {
                try {
                    src.seek(startRange);
                    currentStart = startRange;
                    currentEnd = endRange > startRange && endRange - startRange < 0x100000L ? endRange : currentStart + 0x100000L;
                    int readBufferSize = (int)Math.min(bufferSize, currentEnd - currentStart);
                    Boolean append = Boolean.FALSE;
                    while (!finished) {
                        StringHolder msgHolder;
                        UploadConnectionParams connParams = new UploadConnectionParams(append, srcFile);
                        OutputStreamHandlerForFile outputHandler = new OutputStreamHandlerForFile(src, currentEnd, readBufferSize, options);
                        HttpURLConnection conn = this.openConnection(url, connParams, outputHandler);
                        int statusCode = this.getResponseCode(conn, msgHolder = new StringHolder(), url);
                        if (statusCode != 200) {
                            throw new TransferFailedException(msgHolder.stringValue + " (for: " + srcFile.toString() + ").");
                        }
                        if (currentEnd >= endRange) {
                            finished = true;
                            continue;
                        }
                        append = Boolean.TRUE;
                        currentStart = currentEnd;
                        if (endRange == 0L || (currentEnd += 0x100000L) <= endRange) continue;
                        currentEnd = endRange;
                    }
                    if (src != null) {
                        src.close();
                    }
                    if (options.isDeleteSourceOnCompletion()) {
                        srcFile.delete();
                    }
                    break;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.uploadFileInternal", (String)"550", (Object)this);
                    if (++retryCount > this.retryLimit) {
                        String msg = "Upload retry limit exceeded for file " + srcFile.toString() + ". Exception: " + e.toString();
                        Tr.error(tc, "ADFS0112", msg + ".");
                        throw new TransferFailedException(msg, (Throwable)e);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file upload for: " + srcFile.toString());
                        Tr.debug(tc, "Exception: " + e.toString());
                    }
                    try {
                        Thread.sleep(this.retryWaitTime * 1000);
                    }
                    catch (Exception intexc) {}
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), iob);
            }
            throw iob;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), e);
            }
            Tr.service(tc, "ADFS0124", new Object[]{url, e});
            throw new TransferFailedException("Error occurred during upload to: " + url.toString() + ". Exception: " + e.toString(), (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.uploadFileInternal", (String)"590", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), t);
            }
            Tr.service(tc, "ADFS0124", new Object[]{url, t});
            throw new TransferFailedException("Error occurred during upload to: " + url.toString() + ". Exception: " + t, t);
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadInternal");
            }
        }
    }

    public InputStream downloadFile(String srcPath, long rangeStart, long rangeEnd) throws TransferFailedException {
        return this.downloadFile(srcPath, rangeStart, rangeEnd, null);
    }

    public void downloadFile(String srcPath, File destFile, long rangeStart, long rangeEnd) throws TransferFailedException {
        this.downloadFile(srcPath, destFile, rangeStart, rangeEnd, null);
    }

    public InputStream downloadFile(String srcPath, long rangeStart, long rangeEnd, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (1)", new Object[]{"srcPath=" + srcPath, "rangeStart=" + rangeStart, "rangeEnd=" + rangeEnd});
            }
            if (rangeStart > rangeEnd || rangeStart < 0L) {
                throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + rangeStart + ", " + rangeEnd + "] for " + srcPath + ".");
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createDownloadURL(srcPath, rangeStart, rangeEnd, options);
            InputStream inputStream = this.download(url, options.isCompress(), null);
            return inputStream;
        }
        catch (IndexOutOfBoundsException iob) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, iob);
            }
            throw iob;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, e);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, e});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"671", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, t);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, t});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + t, t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (1)");
            }
        }
    }

    public void downloadFile(String srcPath, File destFile, long rangeStart, long rangeEnd, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile", new Object[]{"srcPath=" + srcPath, "destFile=" + destFile, "rangeStart=" + rangeStart, "rangeEnd=" + rangeEnd, "options=" + options});
            }
            if (rangeStart > rangeEnd || rangeStart < 0L) {
                throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + rangeStart + ", " + rangeEnd + "] for " + srcPath + ".");
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createDownloadURL(srcPath, rangeStart, rangeEnd, options);
            this.download(url, destFile, options.isCompress(), rangeStart, rangeEnd);
        }
        catch (IndexOutOfBoundsException iob) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, iob);
            }
            throw iob;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"726", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, t);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, t});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + t, t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (2)");
            }
        }
    }

    public InputStream downloadFile(String srcPath, long rangeStart) throws TransferFailedException {
        return this.downloadFile(srcPath, rangeStart, null);
    }

    public void downloadFile(String srcPath, File destFile, long rangeStart) throws TransferFailedException {
        this.downloadFile(srcPath, destFile, rangeStart, null);
    }

    public InputStream downloadFile(String srcPath, long rangeStart, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (3) to InputStream", new Object[]{"srcPath=" + srcPath, "rangeStart=" + rangeStart, "options=" + options});
            }
            if (rangeStart < 0L) {
                throw new IndexOutOfBoundsException("The rangeStart value is not valid [" + rangeStart + "] for " + srcPath + ".");
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createDownloadURL(srcPath, rangeStart, -99L, options);
            InputStream inputStream = this.download(url, options.isCompress(), null);
            return inputStream;
        }
        catch (IndexOutOfBoundsException iob) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, iob);
            }
            throw iob;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, e);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, e});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"806", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, t);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, t});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + t, t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (3)");
            }
        }
    }

    public void downloadFile(String srcPath, File destFile, long rangeStart, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (4) to file", new Object[]{"srcPath=" + srcPath, "destFile=" + destFile, "options=" + options});
            }
            if (rangeStart < 0L) {
                throw new IndexOutOfBoundsException("The rangeStart value is not valid [" + rangeStart + "] for " + srcPath + ".");
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createDownloadURL(srcPath, rangeStart, -99L, options);
            this.download(url, destFile, options.isCompress(), rangeStart, 0L);
        }
        catch (IndexOutOfBoundsException iob) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, iob);
            }
            throw iob;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"857", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, t);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, t});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + t, t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (4)");
            }
        }
    }

    public InputStream downloadFile(String srcPath) throws TransferFailedException {
        return this.downloadFile(srcPath, (FileTransferOptions)null);
    }

    public void downloadFile(String srcPath, File destFile) throws TransferFailedException {
        this.downloadFile(srcPath, destFile, null);
    }

    public InputStream downloadFile(String srcPath, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (5) to InputStream", new Object[]{"srcPath=" + srcPath, "options=" + options});
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createDownloadURL(srcPath, -99L, -99L, options);
            InputStream inputStream = this.download(url, options.isCompress(), null);
            return inputStream;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, e);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, e});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"926", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, t);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, t});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + t, t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (5)");
            }
        }
    }

    public void downloadFile(String srcPath, File destFile, FileTransferOptions options) throws TransferFailedException {
        this.checkInitOK();
        URL url = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (6) to file", new Object[]{"srcPath=" + srcPath, "destFile=" + destFile, "options=" + options});
            }
            options = this.createDefaultOptionsIfNecessary(options);
            url = this.createDownloadURL(srcPath, -99L, -99L, options);
            this.download(url, destFile, options.isCompress(), 0L, 0L);
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, (Object)tfe);
            }
            throw tfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"967", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, srcPath, t);
            }
            Tr.service(tc, "ADFS0125", new Object[]{srcPath, t});
            throw new TransferFailedException("Error occurred during download from: " + srcPath + ". Exception: " + t.toString(), t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (6)");
            }
        }
    }

    public X509Certificate getCert() throws TransferFailedException {
        return this.getProcessRSACert();
    }

    public X509Certificate getProcessRSACert() throws TransferFailedException {
        String METHOD = "getProcessRSACert";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessRSACert");
        }
        InputStream in = null;
        X509Certificate cert = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/ocert/getProcessRSACert");
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            if ((in = this.download(url, false, null)) == null) {
                throw new TransferFailedException("download(URL,boolean,ResultsObject) returned a null InputStream");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (TransferFailedException tfe) {
            if (isDebug) {
                Tr.debug(tc, "getProcessRSACert", (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (isDebug) {
                Tr.debug(tc, "getProcessRSACert", e);
            }
            throw new TransferFailedException((Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getProcessRSACert", (String)"1021", (Object)this);
            throw new TransferFailedException(t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "getProcessRSACert error closing input stream: " + ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessRSACert", cert);
        }
        return cert;
    }

    public byte[] getKerberosPolicy() throws TransferFailedException {
        String METHOD = "getKerberosPolicy";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosPolicy");
        }
        InputStream in = null;
        byte[] policyBytes = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/ocert/getKerberosPolicy");
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            if ((in = this.download(url, false, null)) == null) {
                throw new TransferFailedException("download(URL,boolean,ResultsObject) returned a null InputStream");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int b = in.read();
            while (b > -1) {
                out.write(b);
                b = in.read();
            }
            policyBytes = out.toByteArray();
            if (isDebug) {
                if (policyBytes == null) {
                    Tr.debug(tc, "policyBytes is null");
                } else {
                    Tr.debug(tc, "policyBytes has length " + policyBytes.length);
                }
            }
        }
        catch (IOException e) {
            if (isDebug) {
                Tr.debug(tc, "getKerberosPolicy", e);
            }
            throw new TransferFailedException((Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getKerberosPolicy", (String)"1083", (Object)this);
            throw new TransferFailedException(t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "getKerberosPolicy error closing input stream: " + ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosPolicy");
        }
        return policyBytes;
    }

    public X509Certificate getRootSigner(String type) throws TransferFailedException {
        String METHOD = "getRootSigner";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootSigner type = " + type);
        }
        InputStream in = null;
        X509Certificate cert = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/ocert/getRootSigner?type=" + type);
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            if ((in = this.download(url, false, null)) == null) {
                throw new TransferFailedException("download(URL,boolean,ResultsObject) returned a null InputStream");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (TransferFailedException tfe) {
            if (isDebug) {
                Tr.debug(tc, "getRootSigner", (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (isDebug) {
                Tr.debug(tc, "getRootSigner", e);
            }
            throw new TransferFailedException("I/O error occurred while retrieving root signer: " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getRootSigner", (String)"1135", (Object)this);
            throw new TransferFailedException("Error occurred while retrieving root signer: ", t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "getRootSigner: error closing input stream", ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootSigner", cert);
        }
        return cert;
    }

    public boolean isAdminSecurityEnabled() throws TransferFailedException {
        boolean isEnabled;
        String METHOD = "isAdminSecurityEnabled";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminSecurityEnabled");
        }
        InputStream in = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/cert/isAdminSecurityEnabled");
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            if ((in = this.download(url, false, null)) == null) {
                throw new TransferFailedException("download(URL,boolean,ResultsObject) returned a null InputStream");
            }
            String answer = this.streamToString(in);
            if (answer == null || answer.length() < 1) {
                throw new TransferFailedException("Error getting answer from server (null or empty value returned)");
            }
            if (!"true".equals(answer) && !"false".equals(answer)) {
                throw new TransferFailedException("Unrecognized answer '" + answer + "', expected 'true' or 'false'");
            }
            isEnabled = Boolean.parseBoolean(answer);
        }
        catch (TransferFailedException tfe) {
            if (isDebug) {
                Tr.debug(tc, "isAdminSecurityEnabled", (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (isDebug) {
                Tr.debug(tc, "isAdminSecurityEnabled", e);
            }
            throw new TransferFailedException((Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.isAdminSecurityEnabled", (String)"1194", (Object)this);
            throw new TransferFailedException(t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "isAdminSecurityEnabled error closing input stream " + ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminSecurityEnabled", isEnabled);
        }
        return isEnabled;
    }

    public X509Certificate exchangeSigners(X509Certificate signer, String type) throws TransferFailedException {
        String METHOD = "exchangeSigners";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exchangeSigners signer=" + signer + " type=" + type);
        }
        InputStream in = null;
        X509Certificate cert = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/cert/exchangeSigners?type=" + type);
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            in = this.getSend(url, signer.getEncoded(), true);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (TransferFailedException tfe) {
            if (isDebug) {
                Tr.debug(tc, "exchangeSigners", (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (isDebug) {
                Tr.debug(tc, "exchangeSigners", e);
            }
            throw new TransferFailedException("exchangeSigners " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.exchangeSigners", (String)"1243", (Object)this);
            throw new TransferFailedException("exchangeSigners " + t, t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "exchangeSigners error closing input stream: " + ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exchangeSigners", cert);
        }
        return cert;
    }

    public void removeSigner(X509Certificate signer, String type) throws TransferFailedException {
        String METHOD = "removeSigner";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSigner signer=" + signer + " type=" + type);
        }
        Object cert = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/cert/removeSigner?type=" + type);
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            this.getSend(url, signer.getEncoded(), false);
        }
        catch (TransferFailedException tfe) {
            if (isDebug) {
                Tr.debug(tc, "removeSigner", (Object)tfe);
            }
            throw tfe;
        }
        catch (IOException e) {
            if (isDebug) {
                Tr.debug(tc, "removeSigner", e);
            }
            throw new TransferFailedException((Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.removeSigner", (String)"1282", (Object)this);
            throw new TransferFailedException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSigner");
        }
    }

    private String streamToString(InputStream in) {
        try {
            InputStreamReader reader = new InputStreamReader(in, UTF_ENCODING);
            StringWriter writer = new StringWriter();
            int ch = reader.read();
            while (ch != -1) {
                writer.write(ch);
                ch = reader.read();
            }
            return writer.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("BUG: '" + UTF_ENCODING + "' is not recognized as a valid encoding.", uee);
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.streamToString", (String)"1401", (Object)this);
            return null;
        }
    }

    public Properties enrollWithJobManager(Map<String, Serializable> nodeInfo) throws TransferFailedException {
        String METHOD = "enrollWithJobManager";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enrollWithJobManager nodeInfo=" + nodeInfo);
        }
        InputStream in = null;
        Properties outProps = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/cert/enrollWithJobManager");
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            in = this.getSend(url, FileTransferUtils.map2bytes(nodeInfo), true);
            outProps = FileTransferUtils.stream2prop((InputStream)in);
        }
        catch (TransferFailedException tfe) {
            Tr.debug(tc, "enrollWithJobManager", (Object)tfe);
            throw tfe;
        }
        catch (IOException e) {
            Tr.debug(tc, "enrollWithJobManager", e);
            throw new TransferFailedException("enrollWithJobManager " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.enrollWithJobManager", (String)"1433", (Object)this);
            throw new TransferFailedException("enrollWithJobManager " + t, t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "enrollWithJobManager error closing input stream: " + ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enrollWithJobManager", outProps);
        }
        return outProps;
    }

    public String unenrollFromJobManager(String deviceId) throws TransferFailedException {
        String METHOD = "unenrollFromJobManager";
        boolean isDebug = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unenrollFromJobManager deviceId = " + deviceId);
        }
        InputStream in = null;
        String jobmgrId = null;
        try {
            if (isDebug) {
                Tr.debug(tc, "protocol = " + this.protocolToUse + ", host = " + this.transferHost + ", port = " + this.portToUse);
            }
            URL url = new URL(this.protocolToUse, this.transferHost, this.portToUse, "/FileTransfer/cert/unenrollFromJobManager?deviceid=" + deviceId);
            if (isDebug) {
                Tr.debug(tc, "url = " + url);
            }
            if ((in = this.download(url, false, null)) == null) {
                throw new TransferFailedException("download(URL,boolean,ResultsObject) returned a null InputStream");
            }
            jobmgrId = this.streamToString(in);
        }
        catch (TransferFailedException tfe) {
            Tr.debug(tc, "unenrollFromJobManager", (Object)tfe);
            throw tfe;
        }
        catch (IOException e) {
            Tr.debug(tc, "unenrollFromJobManager", e);
            throw new TransferFailedException("unenrollFromJobManager " + e, (Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.unenrollFromJobManager", (String)"1478", (Object)this);
            throw new TransferFailedException("unenrollFromJobManager " + t, t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    Tr.debug(tc, "unenrollFromJobManager error closing input stream: " + ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unenrollFromJobManager", jobmgrId);
        }
        return jobmgrId;
    }

    protected InputStream download(URL url, boolean compress, ResultsObject handback) throws TransferFailedException, IOException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "download (7)", new Object[]{"url=" + url, "compress=" + compress});
            }
            int retryCount = 0;
            while (retryCount <= this.retryLimit) {
                String msg;
                HttpURLConnection conn;
                block33: {
                    InputStream in;
                    conn = null;
                    DownloadConnectionParams connParams = new DownloadConnectionParams(false);
                    conn = this.openConnection(url, connParams, null);
                    StringHolder msgHolder = new StringHolder();
                    int statusCode = this.getResponseCode(conn, msgHolder, url);
                    msg = msgHolder.stringValue;
                    if (statusCode == 401) {
                        if (!this.securityEnabled) {
                            throw new TransferFailedException("Received HTTP_UNAUTHORIZED but security is not enabled for " + url.toString() + ".");
                        }
                        this.setAuthHeader = true;
                        if (++retryCount <= this.retryLimit) continue;
                        String errMsg = "Can not authorize " + url.toString() + ".";
                        Tr.error(tc, "ADFS0112", errMsg);
                        throw new TransferFailedException(errMsg);
                    }
                    this.populateResultsObject(conn, statusCode, msg, handback);
                    if (statusCode == 416) {
                        throw new IndexOutOfBoundsException("File download failed [" + statusCode + "]." + "Message: " + msg);
                    }
                    if (statusCode > 401) {
                        throw new TransferFailedException("File download failed [" + statusCode + "]." + "Message: " + msg);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "statusCode = " + statusCode);
                    }
                    if ((in = conn.getInputStream()) == null) break block33;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connection Data", new Object[]{"encoding=" + conn.getContentEncoding(), "contentType=" + conn.getContentType(), "contentLength=" + conn.getContentLength()});
                    }
                    in = new DataInputStream(in);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "download(7): available bytes = " + in.available() + " in input stream");
                    }
                    if (compress) {
                        in = new GZIPInputStream(in, 8192);
                    }
                    InputStream inputStream = in;
                    return inputStream;
                }
                try {
                    int rc = conn.getResponseCode();
                    String exMsg = msg + " for " + url.toString() + ".";
                    throw new TransferFailedException("File download failed [" + rc + "]." + "Message: " + exMsg);
                }
                catch (EOFException ee) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EOFException encountered!", ee);
                    }
                    if (conn != null) {
                        int rc = conn.getResponseCode();
                        String msg2 = conn.getResponseMessage();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EOFException: Connection data", new Object[]{"rc=" + rc, "msg=" + msg2});
                        }
                    }
                    InputStream rc = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "download (7)");
                    }
                    return rc;
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.download", (String)"1600", (Object)this);
                    Tr.debug(tc, "Exception occurred", ioe);
                    if (++retryCount > this.retryLimit) {
                        String msg3 = "Download retry limit exceeded for retrieving url " + url.toString() + ".";
                        Tr.error(tc, "ADFS0112", msg3);
                        throw ioe;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrying...", new Object[]{"Wait " + this.retryWaitTime + " seconds and retry file download for: " + url.toString(), "retryCount=" + retryCount});
                    }
                    try {
                        Thread.sleep(this.retryWaitTime * 1000);
                    }
                    catch (Exception intexc) {}
                }
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (TransferFailedException tfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), (Object)tfe);
            }
            throw tfe;
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), e);
            }
            Tr.service(tc, "ADFS0125", new Object[]{url, e});
            throw new TransferFailedException("The file to download was not found on the server or the start range is too large.  URL: " + url, (Throwable)e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "download (7)");
            }
        }
    }

    protected void download(URL url, File destFile, boolean compress, long startRange, long endRange) throws TransferFailedException {
        String destFileString = destFile.toString();
        File tempDestFile = null;
        File savedDestFile = destFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "download (8)", new Object[]{"url=" + url, "destFile=" + destFileString, "compress=" + compress});
        }
        if (destFile.exists()) {
            if (destFile.canWrite()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Destination file already exists: Old Download: " + destFile);
                }
                destFile = tempDestFile = this.getTempFile(destFile);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Destination file already exists: New Download: " + destFile);
                }
                destFileString = destFile.toString();
            } else {
                String msg = "No write access to " + destFile + ". File permissions will not allow download to succeed.";
                Tr.error(tc, "ADFS0112", msg);
                throw new TransferFailedException(msg);
            }
        }
        int retryCount = 0;
        boolean append = false;
        URL originalURL = url;
        if (destFileString.startsWith("${REPROOT}")) {
            destFileString = destFileString.substring("${REPROOT}".length());
            destFileString = this.getRepositoryTempDir() + destFileString.substring(1);
        } else {
            destFileString = this.mapVariables(destFileString);
        }
        destFileString = destFileString.replace('/', File.separatorChar);
        destFileString = destFileString.replace('\\', File.separatorChar);
        if (!destFileString.equals(destFile.toString())) {
            destFile = new File(destFileString);
        }
        if (downloadPathsNotRestricted == null) {
            downloadPathsNotRestricted = "false";
            AdminService as = AdminServiceFactory.getAdminService();
            if (as == null) {
                downloadPathsNotRestricted = "true";
                downloadPathsUnrestricted = true;
            } else {
                String allowed = System.getProperty("com.ibm.websphere.management.filetransfer.downloadPathsNotRestricted");
                if (allowed != null && allowed.equalsIgnoreCase("true")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.websphere.management.filetransfer.downloadPathsNotRestricted=true!");
                    }
                    downloadPathsNotRestricted = "true";
                    downloadPathsUnrestricted = true;
                }
            }
        }
        if (!downloadPathsUnrestricted) {
            this.verifyDestPathChildOfRootInstallPath(destFile);
        }
        long currentStartRange = startRange;
        String firstExcpMsg = null;
        while (retryCount <= this.retryLimit) {
            try {
                this.downloadInternal(url, destFile, compress, append, currentStartRange, endRange);
                if (tempDestFile == null) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Call writeTempBackToOrig(" + destFile + ", " + savedDestFile + ");");
                }
                this.writeTempBackToOrig(destFile, savedDestFile);
                if (!destFile.delete()) {
                    String msg = "Delete of temporary file, " + destFile + ", failed. File should be deleted.";
                    Tr.error(tc, "ADFS0112", msg);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, msg);
                    }
                    throw new TransferFailedException(msg);
                }
                break;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.download", (String)"1764", (Object)this);
                if (firstExcpMsg == null) {
                    firstExcpMsg = e.toString();
                }
                if (++retryCount > this.retryLimit) {
                    String msg;
                    if (tempDestFile != null) {
                        if (!destFile.delete()) {
                            msg = "Delete of temporary file, " + destFile + ", failed. File should be deleted.";
                            Tr.error(tc, "ADFS0112", msg);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, msg);
                            }
                        }
                    } else if (!destFile.delete()) {
                        msg = "Download retry limit exceeded: Delete of partially downloaded file, " + destFile + ", failed (First exception: " + firstExcpMsg + ").";
                        Tr.error(tc, "ADFS0112", msg);
                    }
                    msg = "Download retry limit exceeded for file " + destFile + ". (First exception: " + firstExcpMsg + ").";
                    Tr.error(tc, "ADFS0112", msg);
                    throw new TransferFailedException(msg, (Throwable)e);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file download for: " + destFile);
                    Tr.debug(tc, "Retry count = " + retryCount + "; Exception message: " + e);
                }
                try {
                    Thread.sleep(this.retryWaitTime * 1000);
                }
                catch (Exception intexc) {
                    // empty catch block
                }
                if (!destFile.exists()) continue;
                append = true;
                currentStartRange = startRange + destFile.length();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "download (8)");
        }
    }

    protected void downloadInternal(URL url, File destFile, boolean compress, boolean append, long startRange, long endRange) throws TransferFailedException, IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadInternal", new Object[]{"url=" + url, "destFile=" + destFile, "compress=" + compress});
            }
            long currentStart = startRange;
            long currentEnd = 0L;
            currentEnd = endRange > startRange && endRange - startRange < 0x100000L ? endRange : currentStart + 0x100000L;
            long totalRead = 0L;
            boolean finished = false;
            while (!finished) {
                URL newURL = this.adjustStartEndRange(url, currentStart, currentEnd);
                ResultsObject results = new ResultsObject();
                in = this.download(newURL, compress, results);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "downloadInternal: newURL = " + newURL + "; available bytes = " + in.available());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, results.msg + " : " + results.statusCode + " : " + results.lastModified + " : " + results);
                }
                totalRead = 0L;
                if (!destFile.getParentFile().exists()) {
                    destFile.getParentFile().mkdirs();
                }
                out = new FileOutputStream(destFile.getCanonicalPath(), append);
                byte[] buf = new byte[8192];
                int numRead = in.read(buf);
                while (numRead != -1) {
                    totalRead += (long)numRead;
                    out.write(buf, 0, numRead);
                    numRead = in.read(buf);
                }
                in.close();
                out.flush();
                out.close();
                in = null;
                out = null;
                if (results.lastModified != 0L) {
                    destFile.setLastModified(results.lastModified);
                }
                if (results.eof || endRange != 0L && currentEnd == endRange) {
                    finished = true;
                    continue;
                }
                append = true;
                currentStart = currentEnd;
                if (endRange == 0L || (currentEnd += 0x100000L) <= endRange) continue;
                currentEnd = endRange;
            }
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url.toString(), e);
            }
            Tr.service(tc, "ADFS0125", new Object[]{url, e});
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadInternal");
            }
        }
    }

    private InputStream getSend(URL url, byte[] sendbuf, boolean doReceive) throws TransferFailedException, IOException {
        block44: {
            String METHOD = "getSend";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSend", new Object[]{"url=" + url, "bufLength=" + sendbuf.length, "doReceive=" + doReceive});
            }
            OutputStream out = null;
            try {
                int retryCount = 0;
                while (retryCount <= this.retryLimit) {
                    HttpURLConnection conn;
                    block43: {
                        conn = null;
                        try {
                            DownloadConnectionParams connParams = new DownloadConnectionParams(true);
                            OutputStreamHandlerForGet outputHandler = new OutputStreamHandlerForGet(sendbuf);
                            conn = this.openConnection(url, connParams, outputHandler);
                            StringHolder msgHolder = new StringHolder();
                            int statusCode = this.getResponseCode(conn, msgHolder, url);
                            String msg = msgHolder.stringValue;
                            if (statusCode == 401) {
                                if (!this.securityEnabled) {
                                    throw new TransferFailedException("getSend: Received HTTP_UNAUTHORIZED but security is not enabled for " + url + ".");
                                }
                                this.setAuthHeader = true;
                                if (++retryCount <= this.retryLimit) continue;
                                String errmsg = "Cannot authorize " + url;
                                Tr.error(tc, "ADFS0112", errmsg);
                                throw new TransferFailedException(errmsg);
                            }
                            if (statusCode == 416) {
                                throw new IndexOutOfBoundsException("getSend: Send failed [" + statusCode + "]. Message: " + msg);
                            }
                            if (statusCode > 401) {
                                throw new TransferFailedException("getSend: Send failed [" + statusCode + "]. Message: " + msg);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getSend", " statusCode=" + statusCode);
                            }
                            if (!doReceive) break block43;
                            InputStream in = conn.getInputStream();
                            if (in == null) {
                                throw new TransferFailedException("getSend: Failed [" + conn.getResponseCode() + "]." + "Message: " + conn.getResponseMessage() + " for " + url + ".");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getSend", new Object[]{"encoding=" + conn.getContentEncoding(), "contentType=" + conn.getContentType(), "length=" + conn.getContentLength()});
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getSend", in);
                            }
                            InputStream inputStream = in;
                            return inputStream;
                        }
                        catch (EOFException ee) {
                            if (conn != null) {
                                int rc = conn.getResponseCode();
                                String msg = conn.getResponseMessage();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getSend rc = " + rc + "; msg = " + msg);
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getSend" + ee);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getSend", null);
                            }
                            InputStream rc = null;
                            return rc;
                        }
                        catch (IOException ioe) {
                            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getSend", (String)"2034", (Object)this);
                            Tr.debug(tc, "getSend: IOException", ioe);
                            if (++retryCount > this.retryLimit) {
                                Tr.error(tc, "ADFS0112", "Retry limit exceeded for retrieving url " + url);
                                throw ioe;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getSend", new Object[]{"Wait " + this.retryWaitTime + " seconds and retry for " + url, "retryCount = " + retryCount});
                            }
                            try {
                                Thread.sleep(this.retryWaitTime * 1000);
                            }
                            catch (InterruptedException ie) {}
                            continue;
                        }
                    }
                    int rc = conn.getResponseCode();
                    if (rc != 200) {
                        throw new TransferFailedException("getSend: URL " + url + " failed with rc = " + rc);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSend", "null (doReceive is false)");
                    }
                    InputStream inputStream = null;
                    return inputStream;
                }
                if (!tc.isEntryEnabled()) break block44;
            }
            catch (TransferFailedException tfe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSend: " + url, (Object)tfe);
                }
                throw tfe;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        Tr.debug(tc, "getSend Exception closing output stream: " + ioe);
                    }
                }
            }
            Tr.exit(tc, "getSend", null);
        }
        InputStream inputStream = null;
        return inputStream;
    }

    public String getServerStagingLocation() {
        return this.serverStagingLocation;
    }

    public void setServerStagingLocation(String location) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setServerStagingLocation", location);
        }
        this.serverStagingLocation = location;
    }

    public String getTransferHost() {
        return this.transferHost;
    }

    public void setTransferHost(String transferHost) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferHost", transferHost);
        }
        this.transferHost = transferHost;
    }

    public int getTransferPort() {
        return this.transferPort;
    }

    public void setTransferPort(int transferPort) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferPort", transferPort);
        }
        this.transferPort = transferPort;
        if (!this.isSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using transfer port " + transferPort);
            }
            this.portToUse = transferPort;
        }
    }

    public int getTransferSecurePort() {
        return this.transferSecurePort;
    }

    public void setTransferSecurePort(int transferPort) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferSecurePort", transferPort);
        }
        this.transferSecurePort = transferPort;
        if (this.isSecurityEnabled() && transferPort != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using transfer secure port " + transferPort);
            }
            this.portToUse = this.transferSecurePort;
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private void setSecurityEnabled(boolean enabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSecurityEnabled", enabled);
        }
        this.securityEnabled = enabled;
        if (enabled && this.transferSecurePort != 0) {
            try {
                SSLConfigManager.getInstance().initializeClientSSL();
                this.protocolToUse = "https";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using transfer secure port " + this.transferSecurePort);
                }
                this.portToUse = this.transferSecurePort;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.download", (String)"2193", (Object)this);
                Tr.service(tc, "ADFS0128", e);
            }
        } else {
            this.protocolToUse = "http";
            this.portToUse = this.transferPort;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSecurityEnabled");
        }
    }

    private void setDeviceManagerAgent(boolean isDeviceManagerAgent) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDeviceManagerAgent", isDeviceManagerAgent);
        }
        this._deviceMgrAgent = isDeviceManagerAgent;
    }

    private boolean isDeviceManagerAgent() {
        return this._deviceMgrAgent;
    }

    public void initialize(FileTransferConfig config) {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", config);
            }
            this.initEx = null;
            if (config.getTransferRequestTimeout() != null && config.getTransferRetryCount() != null) {
                this.retryWaitTime = config.getTransferRequestTimeout();
                this.retryLimit = config.getTransferRetryCount();
            }
            if (config.getVariableMap() != null) {
                this.vmap = (VariableMap)config.getVariableMap();
            }
            String type = null;
            String host = null;
            String port = null;
            Properties props = config.getProperties();
            if (props != null) {
                type = props.getProperty("jmx.conn.type");
                host = props.getProperty("cellmgr.host");
                port = props.getProperty("jmx.port");
                this.ftServerName = props.getProperty("server_name");
            }
            if (type != null && host != null && port != null) {
                this.jmxConnProps = new Properties();
                this.jmxConnProps.setProperty("type", type);
                this.jmxConnProps.setProperty("host", host);
                this.jmxConnProps.setProperty("port", port);
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    this.jmxConnProps.setProperty("autoAcceptSignerForThisConnectionOnly", "true");
                }
                try {
                    this.sendGetServerConfigRequest();
                }
                catch (Exception e) {
                    this.initEx = e;
                }
            } else {
                if (this.jmxConnProps == null) {
                    try {
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        String pn = adminService.getProcessName();
                        String node = adminService.getNodeName();
                        if (pn == null) {
                            pn = this.ftServerName;
                        }
                        if (pn != null) {
                            String query = "WebSphere:*,type=Discovery,node=" + node + ",process=" + pn;
                            ObjectName queryName = new ObjectName(query);
                            Set s = adminService.queryNames(queryName, null);
                            Iterator it = s.iterator();
                            queryName = (ObjectName)it.next();
                            adminService.addNotificationListener(queryName, this, null, null);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not register as a listener to DiscoveryMBean");
                        }
                        break block19;
                    }
                    catch (JMException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.initialize", (String)"2310", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "can not register as a listener to DiscoveryMBean", ex);
                        }
                        break block19;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jmxConnProps was not null!");
                    Tr.debug(tc, "jmxConnProps host = " + this.jmxConnProps.getProperty("host"));
                    Tr.debug(tc, "jmxConnProps port = " + this.jmxConnProps.getProperty("port"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.jmxConnProps);
        }
    }

    public void initialize(AdminClient client) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", client);
        }
        this.initEx = null;
        this.adminClient = client;
        try {
            this.sendGetServerConfigRequest();
        }
        catch (Exception e) {
            this.initEx = e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", client);
        }
    }

    public void setVariableMap(Object vmap) {
        if (vmap instanceof VariableMap) {
            this.vmap = (VariableMap)vmap;
        }
    }

    public Object getVariableMap() {
        return this.vmap;
    }

    private String mapVariables(String text) {
        if (this.vmap != null && text != null) {
            text = this.vmap.expand(text);
        }
        return text;
    }

    private File mapVariables(File file) {
        String newFileName;
        String fileName;
        if (this.vmap != null && file != null && (fileName = file.toString()) != (newFileName = this.mapVariables(fileName))) {
            file = new File(newFileName);
        }
        return file;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        if ((type = notification.getType()).equals("websphere.discovery.agent.found")) {
            ServerInfo dmgr = (ServerInfo)notification.getUserData();
            this.dmgrAdded(dmgr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void dmgrAdded(ServerInfo dmgr) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "dmgrAdded");
            }
            try {
                this.adminClient = dmgr.getAdminClient();
                ObjectName on = this.adminClient.getServerMBean();
                String processName = on.getKeyProperty("process");
                Hashtable ht = on.getKeyPropertyList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hashtable=" + ht);
                    Tr.debug(tc, "processName = " + processName);
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.dmgrAdded", (String)"2425", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "unable to obtain the admin client to netmgr", ex);
            }
        }
        try {
            this.sendGetServerConfigRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dmgrAdded");
        }
    }

    private void sendGetServerConfigRequest() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendGetServerConfigRequest");
        }
        boolean accepted = false;
        try {
            final AdminClient adminClient = this.getAdminClient();
            final ObjectName ftServerName = this.getFTServerObjectName();
            String opName = "getServerConfig";
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return adminClient.invoke(ftServerName, "getServerConfig", null, null);
                }
            };
            FileTransferConfig serverConfig = (FileTransferConfig)ContextManagerFactory.getInstance().runAsSystem(action);
            if (serverConfig != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FileTransferConfig from CellMgr: " + serverConfig);
                }
                this.setFileTransferConfig(serverConfig);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not retrieve file transfer server config.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.sendGetServerConfigRequest", (String)"2479", (Object)this);
            Tr.service(tc, "ADFS0109", e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendGetServerConfigRequest", accepted);
        }
    }

    private void checkInitOK() throws TransferFailedException {
        if (this.initEx != null) {
            throw new TransferFailedException((Throwable)new IllegalStateException("Error occurred during FileTransferClient initialization: " + this.initEx, this.initEx));
        }
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig serverConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFileTransferConfig", serverConfig);
        }
        this.ftConfig = serverConfig;
        Properties ftConfigProps = serverConfig.getProperties();
        String prop = ftConfigProps.getProperty("clientIsDeviceManagerAgent");
        if (prop != null) {
            this.setDeviceManagerAgent(Boolean.parseBoolean(prop));
        }
        this.setTransferHost(ftConfigProps.getProperty("host"));
        prop = ftConfigProps.getProperty("port");
        if (prop != null) {
            this.setTransferPort(Integer.parseInt(prop));
        } else {
            this.setTransferPort(FileTransferConfigImpl.DEFAULT_PORT_INT_VALUE);
        }
        prop = ftConfigProps.getProperty("secure_port");
        if (prop != null) {
            this.setTransferSecurePort(Integer.parseInt(prop));
        }
        this.setSecurityEnabled(serverConfig.isSecurityEnabled());
        this.setServerStagingLocation(serverConfig.getStagingLocation());
        if (serverConfig.getTransferRequestTimeout() != null && serverConfig.getTransferRetryCount() != null && this.retryWaitTime == FileTransferConfigImpl.DEFAULT_TIMEOUT && this.retryLimit == FileTransferConfigImpl.DEFAULT_RETRIES) {
            this.retryWaitTime = serverConfig.getTransferRequestTimeout();
            this.retryLimit = serverConfig.getTransferRetryCount();
        }
        if (serverConfig.getVariableMap() != null) {
            this.vmap = (VariableMap)serverConfig.getVariableMap();
        }
        if (tc.isDebugEnabled()) {
            String serverName = ftConfigProps.getProperty("server_name");
            Tr.service(tc, "ADFS0134", new Object[]{this.getTransferHost(), Integer.toString(this.portToUse), this.securityEnabled ? "true" : "false", serverName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFileTransferConfig");
        }
    }

    private AdminClient getAdminClient() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient");
        }
        if (this.adminClient == null) {
            if (this.jmxConnProps != null) {
                try {
                    this.adminClient = AdminClientFactory.createAdminClient(this.jmxConnProps);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getAdminClient", (String)"2595", (Object)this);
                    Tr.service(tc, "ADFS0113", e);
                    throw new AdminException(e, e.toString());
                }
            } else {
                throw new AdminException("No JMX connection properties!");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return this.adminClient;
    }

    private ObjectName getFTServerObjectName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFTServerObjectName");
        }
        String processName = this.ftServerName;
        if (this.ftServerObjName == null) {
            try {
                ObjectName queryName;
                Set s;
                String nodeName = null;
                if (processName == null) {
                    AdminClient adminClient = this.getAdminClient();
                    ObjectName on = adminClient.getServerMBean();
                    nodeName = on.getKeyProperty("node");
                    processName = on.getKeyProperty("process");
                    Hashtable ht = on.getKeyPropertyList();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "hashtable=" + ht);
                        Tr.debug(tc, "processName = " + processName);
                    }
                }
                if ((s = this.adminClient.queryNames(queryName = new ObjectName("WebSphere:*,type=FileTransferServer,node=" + nodeName + ",process=" + processName), null)) != null && s.size() != 0) {
                    if (s.size() != 1 && tc.isDebugEnabled()) {
                        Tr.debug(tc, "There are " + s.size() + " FileTransferServer objects.");
                    }
                    Object[] o = s.toArray();
                    this.ftServerObjName = (ObjectName)o[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ftServer name is " + this.ftServerObjName.getCanonicalName());
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getFTServerObjectName", (String)"2650", (Object)this);
                Tr.service(tc, "ADFS0111", e);
                throw new AdminException(e, e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFTServerObjectName");
        }
        return this.ftServerObjName;
    }

    private String getRepositoryTempDir() {
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        Properties repositoryProps = repository2.getConfig();
        return repositoryProps.getProperty("was.repository.temp");
    }

    private String getRootURI() {
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        Properties repositoryProps = repository2.getConfig();
        return repositoryProps.getProperty("was.repository.root");
    }

    private URL adjustStartEndRange(URL originalURL, long newStartRange, long newEndRange) {
        URL newURL;
        block8: {
            String urlFile = originalURL.getFile();
            StringBuffer newUrlFile = new StringBuffer(urlFile.length() + 20);
            StringTokenizer st = new StringTokenizer(urlFile, "&?", true);
            String nextElement = null;
            boolean foundStartRange = false;
            boolean foundEndRange = false;
            while (st.hasMoreTokens()) {
                nextElement = st.nextToken();
                if (nextElement.startsWith("rangeStart")) {
                    newUrlFile.append("rangeStart");
                    newUrlFile.append("=");
                    newUrlFile.append(new Long(newStartRange).toString());
                    foundStartRange = true;
                    continue;
                }
                if (newEndRange > 0L && nextElement.startsWith("rangeEnd")) {
                    newUrlFile.append("rangeEnd");
                    newUrlFile.append("=");
                    newUrlFile.append(new Long(newEndRange).toString());
                    foundEndRange = true;
                    continue;
                }
                newUrlFile.append(nextElement);
            }
            if (!foundStartRange && newStartRange > 0L) {
                newUrlFile.append("&");
                newUrlFile.append("rangeStart");
                newUrlFile.append("=");
                newUrlFile.append(new Long(newStartRange).toString());
            }
            if (!foundEndRange && newEndRange > 0L) {
                newUrlFile.append("&");
                newUrlFile.append("rangeEnd");
                newUrlFile.append("=");
                newUrlFile.append(new Long(newEndRange).toString());
            }
            newURL = null;
            try {
                newURL = new URL(originalURL.getProtocol(), originalURL.getHost(), originalURL.getPort(), newUrlFile.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adjustStartEndRange", "download url=" + newURL);
                }
            }
            catch (MalformedURLException me) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "adjustStartEndRange: Ignoring exception", me);
            }
        }
        return newURL;
    }

    private HttpURLConnection openConnection(URL url, ConnectionParams connParams, OutputStreamHandler outputHandler) throws IOException, TransferFailedException {
        String METHOD = "openConnection";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openConnection", new Object[]{"url=" + url});
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            connParams.setUpConnection(conn);
            this.addAuthHeader(conn);
            this.connectToServer(conn);
            if (outputHandler != null) {
                outputHandler.handleOutputStream(conn);
            }
        }
        catch (IOException ioe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openConnection", "Rethrowing exception: " + ioe);
            }
            throw ioe;
        }
        catch (TransferFailedException tfe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openConnection", "Rethrowing exception: " + (Object)((Object)tfe));
            }
            throw tfe;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.openConnection", (String)"2762", (Object)this);
            IOException ioe = new IOException(ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openConnection", ioe);
            }
            throw new IOException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openConnection", conn);
        }
        return conn;
    }

    private void connectToServer(HttpURLConnection conn) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectToServer", "URL=" + conn.getURL());
        }
        if (this.protocolToUse.equals("https")) {
            AdminService adminService;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using https protocol.");
            }
            if ((adminService = AdminServiceFactory.getAdminService()) == null) {
                RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
            } else {
                URL url = conn.getURL();
                String port = Integer.toString(url.getPort());
                String host = url.getHost();
                final HashMap<String, String> connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.endPointName", "ADMIN_SOAP");
                if (host != null) {
                    connectionInfo.put("com.ibm.ssl.remoteHost", host);
                }
                if (port != null) {
                    connectionInfo.put("com.ibm.ssl.remotePort", port);
                }
                JSSEHelper.getInstance().setOutboundConnectionInfo(connectionInfo);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Properties ssl_props;
                            String newSoapSslAlias = SecurityHelper.getHelper().getClientSSLAlias();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "sslAlias for file transfer: " + newSoapSslAlias);
                            }
                            if ((ssl_props = JSSEHelper.getInstance().getProperties(newSoapSslAlias, connectionInfo, null)) != null) {
                                JSSEHelper.getInstance().setSSLPropertiesOnThread(ssl_props);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception ex = pae.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Received exception trying to get SSL config.", ex);
                    }
                    IOException ioe = new IOException(ex.getMessage());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "connectToServer", ioe);
                    }
                    throw ioe;
                }
            }
        }
        conn.connect();
        if (this.protocolToUse.equals("https")) {
            IOException ioe;
            try {
                String cipherSuite = this.waitForHandshake(conn);
                if (cipherSuite == null) {
                    conn.connect();
                    cipherSuite = this.waitForHandshake(conn);
                    if (cipherSuite == null) {
                        ioe = new IOException("Cannot connect to server with HttpsURLStreamHandler.");
                        throw ioe;
                    }
                }
            }
            catch (ClassCastException cce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connectToServer: Exception.", cce);
                }
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe2, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.connectToServer", (String)"2860", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectToServer", ioe2);
                }
                throw ioe2;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.connectToServer", (String)"2865", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connectToServer: Exception.", e);
                }
                ioe = new IOException("Exception occurred: " + e.getMessage());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectToServer", ioe);
                }
                throw ioe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectToServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForHandshake(HttpURLConnection conn) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForHandshake");
        }
        int loops = 0;
        do {
            String cipherSuite = null;
            try {
                cipherSuite = ((HttpsURLConnection)conn).getCipherSuite();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (cipherSuite != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake complete.  Cipher suite used: " + cipherSuite);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitForHandshake");
                }
                return cipherSuite;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Waiting 20ms for handshake to complete.");
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
            }
            finally {
                ++loops;
            }
        } while (loops < 5);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForHandshake -> null");
        }
        return null;
    }

    private String encode(String name) {
        String encodedUrl = FileTransferUtils.urlEncodePlus((String)name);
        try {
            encodedUrl = URLEncoder.encode(encodedUrl, UTF_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.encode", (String)"2921", (Object)this);
            Tr.service(tc, "ADFS0119", e);
        }
        return encodedUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void addAuthHeader(HttpURLConnection conn) throws TransferFailedException {
        METHOD = "addAuthHeader";
        if (FileTransferClientImpl.tc.isEntryEnabled()) {
            Tr.entry(FileTransferClientImpl.tc, "addAuthHeader", "conn=" + conn);
        }
        if (!this.securityEnabled) {
            if (FileTransferClientImpl.tc.isEntryEnabled()) {
                Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", "securityEnabled=false");
            }
            return;
        }
        isServer = SecurityContext.isServerProcess();
        if (FileTransferClientImpl.tc.isDebugEnabled()) {
            Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "isServer=" + isServer);
        }
        sub = null;
        try {
            sub = this.getSubject();
            if (FileTransferClientImpl.tc.isDebugEnabled()) {
                Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "subject=" + sub);
            }
        }
        catch (TransferFailedException e) {
            if (FileTransferClientImpl.tc.isEntryEnabled()) {
                Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", (Object)e);
            }
            throw e;
        }
        wsCred = null;
        if (sub != null) {
            wsCred = SubjectHelper.getWSCredentialFromSubject((Subject)sub);
        }
        if (FileTransferClientImpl.tc.isDebugEnabled()) {
            Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "wsCred=" + wsCred);
        }
        isKrb5Auth = false;
        if (wsCred != null) {
            try {
                isKrb5Auth = SecurityHelper.isKrb5Auth(wsCred);
            }
            catch (Exception e) {
                Tr.debug(FileTransferClientImpl.tc, "Exception in SecurityHelper.isKrb5Auth, assuming credentials are NOT Kerberos", e);
            }
        }
        if (wsCred != null && (wsCred.isBasicAuth() || isKrb5Auth)) {
            krbTokenStr = null;
            if (FileTransferClientImpl.tc.isDebugEnabled()) {
                Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Credentials are non-null and either BasicAuth or KRB5");
            }
            if (wsCred.isUnauthenticated()) {
                tfe = new TransferFailedException("Credentials are not authenticated: " + wsCred);
                if (FileTransferClientImpl.tc.isEntryEnabled()) {
                    Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", (Object)tfe);
                }
                throw tfe;
            }
            try {
                if (wsCred.isBasicAuth()) {
                    if (FileTransferClientImpl.tc.isDebugEnabled()) {
                        Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Basic auth");
                    }
                    user = wsCred.getSecurityName();
                    pwToken = wsCred.getCredentialToken();
                    pw = StringBytesConversion.getConvertedString((byte[])pwToken);
                    if (FileTransferClientImpl.tc.isDebugEnabled()) {
                        Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "User=" + user);
                    }
                    encodedAuth = Base64.encode((byte[])(user + ":" + pw).getBytes());
                    conn.setRequestProperty("Authorization", "Basic " + encodedAuth);
                    if (FileTransferClientImpl.encoding != null) {
                        conn.setRequestProperty("Authorization-Encoding", FileTransferClientImpl.encoding);
                    }
                } else {
                    if (FileTransferClientImpl.tc.isDebugEnabled()) {
                        Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Kerberos auth");
                    }
                    if (this.kerberosPolicy == null && !AdminCertificateHelper.getInstance().isRSAPropagationEnabled()) {
                        ktm = KerberosThreadManager.getInstance();
                        if (ktm.isKerberosPolicyRetrievalInProcess().booleanValue()) {
                            if (FileTransferClientImpl.tc.isDebugEnabled()) {
                                Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Cannot get Kerberos policy, isKerberosPolicyRetrievalInProcess = true");
                            }
                        } else {
                            policyBytes = null;
                            try {
                                ktm.setKerberosPolicyRetrievalInProcess();
                                policyBytes = this.getKerberosPolicy();
                            }
                            finally {
                                ktm.unsetKerberosPolicyRetrievalInProcess();
                            }
                            if (policyBytes != null) {
                                this.kerberosPolicy = new KerberosPolicy(policyBytes);
                            } else {
                                Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "policyBytes is null, cannot create Kerberos policy");
                            }
                        }
                    }
                    if (this.kerberosPolicy != null) {
                        krbTokenStr = this.createKrb5Cookie(sub);
                        if (krbTokenStr != null) {
                            conn.setRequestProperty("Cookie", "KRB5Token=" + krbTokenStr);
                        } else {
                            Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "krbTokenStr is null, cookie not set");
                        }
                    } else {
                        Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Kerberos policy is null, cookie not set");
                    }
                }
                if (isServer) ** GOTO lbl166
                if (isKrb5Auth && krbTokenStr == null) {
                    if (!FileTransferClientImpl.tc.isDebugEnabled()) ** GOTO lbl166
                    Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "isKrb5Auth is true but krbTokenStr is null, so addSsoTokens will not be called.");
                }
                this.addSsoTokens(conn);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", (String)"3041", (Object)this);
                tfe = new TransferFailedException("There is a problem with the client credential: " + e, (Throwable)e);
                if (FileTransferClientImpl.tc.isEntryEnabled()) {
                    Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", (Object)tfe);
                }
                throw tfe;
            }
        } else if (isServer) {
            try {
                if (FileTransferClientImpl.tc.isDebugEnabled()) {
                    Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Running in server process.");
                }
                subject = ContextManagerFactory.getInstance().getServerSubject();
                if (FileTransferClientImpl.tc.isDebugEnabled()) {
                    Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "subject=" + subject);
                }
                rsaCookie = null;
                rsaTokenThreadMgr = RSATokenThreadManager.getInstance();
                certRetrievalInProcess = rsaTokenThreadMgr.isCertificateRetrievalInProcess();
                if (!this.isDeviceManagerAgent()) {
                    if (AdminCertificateHelper.getInstance().isRSAPropagationEnabled() && !certRetrievalInProcess) {
                        rsaCookie = this.createRSACookie(subject);
                        if (FileTransferClientImpl.tc.isDebugEnabled()) {
                            Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "rsaCookie=" + rsaCookie);
                        }
                        if (rsaCookie != null) {
                            conn.setRequestProperty("Cookie", rsaCookie.getName() + "=" + rsaCookie.getValue());
                        }
                    }
                } else {
                    try {
                        if (!certRetrievalInProcess) {
                            rsaTokenThreadMgr.setCertificateRetrievalInProcess();
                            this.targetCertificate = this.getProcessRSACert();
                        }
                    }
                    finally {
                        rsaTokenThreadMgr.unsetCertificateRetrievalInProcess();
                    }
                }
                if ((cookie = this.createCookie(subject)) != null) {
                    conn.setRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
                }
                if ((cookie2 = this.createCookie2(subject)) != null) {
                    value = cookie2.getName() + "=" + cookie2.getValue();
                    currentValue = conn.getRequestProperty("Cookie");
                    value = currentValue == null ? value : currentValue + "; " + value;
                    conn.setRequestProperty("Cookie", value);
                }
                if (!this.isDeviceManagerAgent() || !this.isSecurityEnabled()) ** GOTO lbl166
                if (FileTransferClientImpl.tc.isDebugEnabled()) {
                    Tr.debug(FileTransferClientImpl.tc, "Adding RSA auth header.");
                }
                AdminContext.push(null);
                hostName = AdminHelper.getInstance().getHostName();
                AdminContext.pop();
                RSAPropagationHelper.addRSAAuthHeader(conn, this.targetCertificate, hostName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", (String)"3137", (Object)this);
                tfe = new TransferFailedException("An error occurred trying to create the FileTransfer cookie: " + e, (Throwable)e);
                if (FileTransferClientImpl.tc.isEntryEnabled()) {
                    Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", (Object)tfe);
                }
                throw tfe;
            }
        } else {
            if (FileTransferClientImpl.tc.isDebugEnabled()) {
                Tr.debug(FileTransferClientImpl.tc, "addAuthHeader", "Credentials are either null or unrecognized (something other than BasicAuth or KRB5)");
            }
            try {
                foundTokens = this.addSsoTokens(conn);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", (String)"%C", (Object)this);
                tfe = new TransferFailedException("Error getting SSO tokens: " + e, (Throwable)e);
                if (FileTransferClientImpl.tc.isEntryEnabled()) {
                    Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", (Object)tfe);
                }
                throw tfe;
            }
            if (!foundTokens) {
                credMsg = wsCred == null ? "Credentials are null" : "Credentials are non-null but are not of type 'basic auth'";
                tfe = new TransferFailedException("No authorization: " + credMsg + " and there are no SSO tokens.");
                if (FileTransferClientImpl.tc.isEntryEnabled()) {
                    Tr.exit(FileTransferClientImpl.tc, "addAuthHeader", (Object)tfe);
                }
                throw tfe;
            }
        }
lbl166:
        // 8 sources

        if (FileTransferClientImpl.tc.isEntryEnabled()) {
            Tr.exit(FileTransferClientImpl.tc, "addAuthHeader");
        }
    }

    private boolean addSsoTokens(HttpURLConnection conn) {
        boolean ret = false;
        Iterator iter = this.getSingleSignonTokens();
        while (iter != null && iter.hasNext()) {
            Cookie cookie = this.createClientCookie((TokenHolder)iter.next());
            String currentValue = conn.getRequestProperty("Cookie");
            String value = cookie.getName() + "=" + cookie.getValue();
            value = currentValue == null ? value : currentValue + "; " + value;
            conn.setRequestProperty("Cookie", value);
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cookie createRSACookie(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRSACookie");
        }
        String cookieDomain = null;
        Cookie cookie = null;
        try {
            String cookiePath;
            String cookieName;
            boolean isCookieSecure;
            boolean setSSODomain;
            block20: {
                SingleSignonConfig sso;
                SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
                AuthMechanismConfig ltpa = security.getAuthMechanism("LTPA");
                if (ltpa == null) {
                    Tr.warning(tc, "ltpa is null");
                }
                if ((sso = ltpa.getSingleSignon()) == null) {
                    Tr.warning(tc, "ltpa's sso is null");
                }
                if ((cookieDomain = sso.getString("domainName")) != null && cookieDomain.length() > 0 && (cookieDomain = cookieDomain.trim()).charAt(0) != '.') {
                    cookieDomain = "." + cookieDomain;
                }
                if (cookieDomain == null) {
                    cookieDomain = "";
                }
                setSSODomain = sso.getBoolean("security.ltpa.setSSODomain");
                isCookieSecure = sso.getBoolean("requireSSL");
                cookieName = "RSAToken";
                cookiePath = "/";
                RSATokenThreadManager rsaTokenThreadMgr = RSATokenThreadManager.getInstance();
                try {
                    AdminCertificateHelper adminCertHelper = AdminCertificateHelper.getInstance();
                    if (!adminCertHelper.isRSAPropagationEnabled() || rsaTokenThreadMgr.isCertificateRetrievalInProcess().booleanValue()) break block20;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retrieving the admin target certificate.");
                        }
                        rsaTokenThreadMgr.setCertificateRetrievalInProcess();
                        this.targetCertificate = adminCertHelper.retrieveTargetCertificateDuringFileTransfer(this.transferHost, Integer.toString(this.portToUse), this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retrieved the following target certificate.", new Object[]{this.targetCertificate});
                        }
                    }
                    finally {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Finished retrieving the admin target certificate.");
                        }
                        rsaTokenThreadMgr.unsetCertificateRetrievalInProcess();
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception setting up RSA token information.", e);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.createRSACookie", (String)"3295", (Object)this);
                    rsaTokenThreadMgr.setTargetCertificate(null);
                }
            }
            byte[] credTokenBytes = RSAPropagationManager.getInstance().createRSAPropagationToken(this.targetCertificate, subject);
            String cookieValue = Base64.encode((byte[])credTokenBytes);
            cookie = new Cookie(cookieName, cookieValue);
            if (setSSODomain) {
                cookie.setDomain(cookieDomain);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No domain set for " + cookieName + " cookie");
            }
            cookie.setPath(cookiePath);
            cookie.setMaxAge(-1);
            cookie.setSecure(isCookieSecure);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.createRSACookie", (String)"3316", (Object)this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRSACookie");
        }
        return cookie;
    }

    private Cookie createCookie(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie", "subject=" + subject);
        }
        String cookieDomain = null;
        Cookie cookie = null;
        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        try {
            SingleSignonConfig sso;
            SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
            AuthMechanismConfig ltpa = security.getAuthMechanism("LTPA");
            if (ltpa == null) {
                Tr.warning(tc, "ltpa is null");
            }
            if ((sso = ltpa.getSingleSignon()) == null) {
                Tr.warning(tc, "ltpa's sso is null");
            }
            if ((cookieDomain = sso.getString("domainName")) == null) {
                cookieDomain = "";
            }
            if (cookieDomain != null && cookieDomain.length() > 0 && (cookieDomain = cookieDomain.trim()).charAt(0) != '.') {
                cookieDomain = "." + cookieDomain;
            }
            boolean setSSODomain = sso.getBoolean("security.ltpa.setSSODomain");
            boolean isCookieSecure = sso.getBoolean("requireSSL");
            if (cookieDomain.length() < 1) {
                setSSODomain = false;
            }
            String cookieName = "LtpaToken";
            String cookiePath = "/";
            String cookieValue = Base64.encode((byte[])wsCred.getCredentialToken());
            cookie = new Cookie(cookieName, cookieValue);
            if (setSSODomain) {
                cookie.setDomain(cookieDomain);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No domain set for " + cookieName + " cookie");
            }
            cookie.setPath(cookiePath);
            cookie.setMaxAge(-1);
            cookie.setSecure(isCookieSecure);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.createCookie", (String)"3378", (Object)this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie", cookie);
        }
        return cookie;
    }

    private Cookie createCookie2(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie2", subject);
        }
        String cookieDomain = null;
        Cookie cookie = null;
        try {
            Iterator ssoTokensFromSubject = FileTransferClientImpl.getSingleSignonTokensFromSubject(subject);
            while (ssoTokensFromSubject.hasNext()) {
                SingleSignonConfig sso;
                String name;
                SingleSignonToken ssoToken = (SingleSignonToken)ssoTokensFromSubject.next();
                if (ssoToken == null || !(name = ssoToken.getName()).equals("LtpaToken")) continue;
                byte[] ssoTokenBytes = ssoToken.getBytes();
                short version = ssoToken.getVersion();
                String cookieName = name + new Short(version).toString();
                SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
                AuthMechanismConfig ltpa = security.getAuthMechanism("LTPA");
                if (ltpa == null) {
                    Tr.warning(tc, "ltpa is null");
                }
                if ((sso = ltpa.getSingleSignon()) == null) {
                    Tr.warning(tc, "ltpa's sso is null");
                }
                if ((cookieDomain = sso.getString("domainName")) == null) {
                    cookieDomain = "";
                }
                if (cookieDomain != null && cookieDomain.length() > 0 && (cookieDomain = cookieDomain.trim()).charAt(0) != '.') {
                    cookieDomain = "." + cookieDomain;
                }
                boolean setSSODomain = sso.getBoolean("security.ltpa.setSSODomain");
                boolean isCookieSecure = sso.getBoolean("requireSSL");
                String cookiePath = "/";
                String cookieValue = Base64.encode((byte[])ssoTokenBytes);
                cookie = new Cookie(cookieName, cookieValue);
                if (setSSODomain) {
                    cookie.setDomain(cookieDomain);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No domain set for " + cookieName + " cookie");
                }
                cookie.setPath(cookiePath);
                cookie.setMaxAge(-1);
                cookie.setSecure(isCookieSecure);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.createCookie2", (String)"3454", (Object)this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie2", cookie);
        }
        return cookie;
    }

    private Cookie createClientCookie(TokenHolder holder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientCookie", holder);
        }
        String cookieValue = Base64.encode((byte[])holder.getBytes());
        String cookieName = holder.getName();
        if (holder.getVersion() >= 0) {
            cookieName = cookieName + holder.getVersion();
        }
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        cookie.setSecure(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientCookie", cookie);
        }
        return cookie;
    }

    private String createKrb5Cookie(Subject sub) {
        String METHOD = "createKrb5Cookie";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKrb5Cookie");
        }
        String krbTokenStr = null;
        if (this.kerberosPolicy == null) {
            Tr.debug(tc, "createKrb5Cookie", "kerberosPolicy is null, cannot get Kerberos token or create cookie");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createKrb5Cookie", null);
            }
            return null;
        }
        String realm = this.kerberosPolicy.get_realm_name();
        String spn = this.kerberosPolicy.get_spn_name();
        if (spn == null || realm == null || spn.length() < 1 || realm.length() < 1) {
            Tr.debug(tc, "createKrb5Cookie", "spn or realm in Kerberos policy is null or empty, cannot create cookie. spn = '" + spn + "', realm = '" + realm + "'");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createKrb5Cookie", null);
            }
            return null;
        }
        byte[] token = SecurityHelper.getKerberosServiceTicket(sub, spn, realm);
        krbTokenStr = Base64.encode((byte[])token);
        if (krbTokenStr != null) {
            AdminDataHolder.setData((Object)"krb5TokenStr", (Object)krbTokenStr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKrb5Cookie", krbTokenStr);
        }
        return krbTokenStr;
    }

    private static Iterator getSingleSignonTokensFromSubject(Subject subject) {
        String METHOD = "getSingleSignonTokensFromSubject";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleSignonTokensFromSubject");
        }
        try {
            ArrayList ssoArrayList = new ArrayList();
            if (subject != null) {
                Set<SingleSignonToken> privateCredentials = null;
                Set<SingleSignonToken> publicCredentials = null;
                HashSet<SingleSignonToken> newSet = new HashSet<SingleSignonToken>();
                try {
                    privateCredentials = subject.getPrivateCredentials(SingleSignonToken.class);
                    if (privateCredentials != null && privateCredentials.size() > 0) {
                        newSet.addAll(privateCredentials);
                    }
                    if ((publicCredentials = subject.getPublicCredentials(SingleSignonToken.class)) != null && publicCredentials.size() > 0) {
                        newSet.addAll(publicCredentials);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject");
                    }
                    return newSet.iterator();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getSingleSignonTokensFromSubject", (String)"3549");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{e});
                    }
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject: (null)");
            }
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getSingleSignonTokensFromSubject", (String)"3560");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{e});
            }
            return null;
        }
    }

    private Iterator getSingleSignonTokens() {
        Iterator iter;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSingleSignonTokens");
            }
            iter = null;
            try {
                ObjectName queryString;
                Set set;
                ObjectName securityAdmin;
                TokenHolder[] ssoTokens;
                AdminClient client = this.getAdminClient();
                ObjectName serverMBean = client.getServerMBean();
                String node = serverMBean.getKeyProperty("node");
                String process = serverMBean.getKeyProperty("process");
                if (client != null && (ssoTokens = (TokenHolder[])client.invoke(securityAdmin = (ObjectName)((set = client.queryNames(queryString = new ObjectName("WebSphere:*,type=SecurityAdmin,node=" + node + ",process=" + process), null)).isEmpty() ? null : set.iterator().next()), "getSingleSignonTokens", new Object[0], new String[0])) != null) {
                    HashSet<TokenHolder> tokens = new HashSet<TokenHolder>(Arrays.asList(ssoTokens));
                    iter = tokens.iterator();
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.event(tc, "Unable to acquire SSO tokens", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSingleSignonTokens", iter);
        }
        return iter;
    }

    private Subject getSubject() throws TransferFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject");
        }
        Object o = AdminDataHolder.getData((String)"wsSubject");
        Subject subject = null;
        if (o instanceof Subject) {
            subject = (Subject)o;
        }
        if (subject == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The subject is not set up in AdminDataHolder");
                }
                if (!SecurityContext.isServerProcess()) {
                    subject = ContextManagerFactory.getInstance().getInvocationSubject();
                    if (subject != null) {
                        AdminDataHolder.setData((Object)"wsSubject", (Object)subject);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Client Code ... No subject in AdminDataHolder");
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getSubject", (String)"3631", (Object)this);
                TransferFailedException tfe = new TransferFailedException("Exception getting subject: " + e, (Throwable)e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSubject", e);
                }
                throw tfe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject");
        }
        return subject;
    }

    private void getUserInstallRoot() throws TransferFailedException {
        String searchStr = null;
        String node = null;
        if (this.userInstallRoot == null) {
            searchStr = "${USER_INSTALL_ROOT}";
            this.userInstallRoot = System.getProperty("user.install.root");
            if (this.userInstallRoot == null) {
                try {
                    if (this.ftServerName == null) {
                        ObjectName on = this.adminClient.getServerMBean();
                        this.ftServerName = on.getKeyProperty("process");
                        node = on.getKeyProperty("node");
                    }
                    String query = "*:*,type=AdminOperations,node=" + node + ",process=" + this.ftServerName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Query string = " + query);
                    }
                    ObjectName adminOps = (ObjectName)this.adminClient.queryNames(new ObjectName(query), null).iterator().next();
                    this.userInstallRoot = (String)this.adminClient.invoke(adminOps, "expandVariable", new Object[]{searchStr}, new String[]{"java.lang.String"});
                }
                catch (Exception e) {
                    throw new TransferFailedException("Unable to resolve USER_INSTALL_ROOT: " + e, (Throwable)e);
                }
            }
        }
    }

    private boolean isDestinationFileChildOfDirectory(File file, String dir) throws TransferFailedException {
        String dirPath;
        String path;
        block5: {
            path = null;
            dirPath = null;
            try {
                path = file.getCanonicalPath();
                dirPath = new File(dir).getCanonicalPath();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "abs " + path);
                }
            }
            catch (Exception e) {
                path = file.toString();
                if (dirPath != null) break block5;
                dirPath = dir;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dirPath = " + dirPath);
        }
        String s1 = path.replace('\\', '/').toLowerCase();
        String s2 = dirPath.replace('\\', '/').toLowerCase();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "path1 = " + s1 + ": path2 = " + s2);
        }
        return s1.startsWith(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getWebServerInstallRoot() throws TransferFailedException {
        int wsCount = -1;
        String[] wsInstRoots = null;
        try {
            int i;
            AdminService adminService;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWebServerInstallRoot");
            }
            if ((adminService = AdminServiceFactory.getAdminService()) == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String type = "ws-server";
            String cell = adminService.getCellName();
            String node = adminService.getNodeName();
            ConfigService configService = ConfigServiceFactory.createConfigService((String)this.getRootURI(), (String)cell, (String)node, null);
            ConfigObject[] serverEntries = null;
            Object serverIndexResource = null;
            ConfigScope configScope = configService.createScope(3);
            ConfigObject serverIndex = (ConfigObject)configService.getDocumentObjects(configScope, "serverindex.xml").get(0);
            List entries = serverIndex.getObjectList("serverEntries");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found " + entries.size() + " server entries... now see if any are webservers!");
            }
            Vector<ConfigObject> v = new Vector<ConfigObject>();
            for (i = 0; i < entries.size(); ++i) {
                ConfigObject se = (ConfigObject)entries.get(i);
                if (!se.getString("serverType", "__null__").equals("WEB_SERVER")) continue;
                v.add(se);
            }
            serverEntries = new ConfigObject[v.size()];
            for (i = 0; i < v.size(); ++i) {
                serverEntries[i] = (ConfigObject)v.get(i);
            }
            if (serverEntries == null || serverEntries.length == 0) {
                wsCount = 0;
                String[] i2 = null;
                return i2;
            }
            wsInstRoots = new String[serverEntries.length * 2];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found " + serverEntries.length + " webserver entries...");
            }
            wsCount = 0;
            for (i = 0; i < serverEntries.length; ++i) {
                configScope.setDepth(4);
                configScope.set(4, serverEntries[i].getString("serverName", "__null__"));
                List list = configService.getDocumentObjects(configScope, "server.xml");
                block10: for (int j = 0; j < list.size(); ++j) {
                    ConfigObject obj;
                    ConfigObject svr = obj = (ConfigObject)list.get(j);
                    List comps = svr.getObjectList("components");
                    for (int k = 0; k < comps.size(); ++k) {
                        ConfigObject resource = (ConfigObject)comps.get(k);
                        if (!resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/webserver.xmi", "WebServer")) continue;
                        ConfigObject webSvr = resource;
                        String root = webSvr.getString("webserverInstallRoot", "__null__");
                        String webServerName = webSvr.getString("name", "__null__");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, webServerName + ": WebServerInstallRoot = " + root);
                        }
                        if (root != null) {
                            wsInstRoots[wsCount++] = root;
                        }
                        String uefname = webSvr.getUnexpandedString("configurationFilename", "__null__");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unexpanded config file name = " + uefname);
                        }
                        VariableMap vmap = VariableMapFactory.createVariableMap((ConfigService)ConfigServiceFactory.createConfigService((String)configService.getPath(), (String)configScope.get(0), (String)configScope.get(3), (String)configScope.get(4)));
                        vmap.initialize(null);
                        String cfgFileName = vmap.expand(uefname);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, webServerName + ": Config filename = " + cfgFileName);
                        }
                        if (cfgFileName == null) continue block10;
                        cfgFileName = File.separatorChar == '\\' ? cfgFileName.replace('/', '\\') : cfgFileName.replace('\\', '/');
                        String pathname = cfgFileName.substring(0, cfgFileName.lastIndexOf(File.separatorChar) - 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, webServerName + ": Config file path = " + pathname);
                        }
                        wsInstRoots[wsCount++] = pathname;
                        continue block10;
                    }
                }
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getWebServerInstallRoot", (String)"3806", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred in getWebServerInstallRoot: " + e);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                if (wsCount < 0) {
                    Tr.exit(tc, "getWebServerInstallRoot: Exception!");
                } else if (wsCount == 0) {
                    Tr.exit(tc, "getWebServerInstallRoot: No webservers!");
                } else {
                    Tr.exit(tc, "getWebServerInstallRoot: " + wsCount + " webservers!");
                }
            }
        }
        return wsInstRoots;
    }

    private void verifyDestPathChildOfRootInstallPath(File destFile) throws TransferFailedException {
        this.getUserInstallRoot();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "(1)Parent path = " + this.userInstallRoot + ": file = " + destFile);
        }
        String[] webSrvs = null;
        int totalLen = this.userInstallRoot.length();
        boolean isValid = this.isDestinationFileChildOfDirectory(destFile, this.userInstallRoot);
        if (!isValid && (webSrvs = this.getWebServerInstallRoot()) != null) {
            for (int i = 0; i < webSrvs.length && webSrvs[i] != null; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "(" + (i + 2) + ")Parent path = " + webSrvs[i] + ": file = " + destFile);
                }
                if (!this.isDestinationFileChildOfDirectory(destFile, webSrvs[i])) continue;
                totalLen += webSrvs[i].length();
                isValid = true;
                break;
            }
        }
        if (!isValid) {
            if (webSrvs != null) {
                StringBuffer strBuf = new StringBuffer(totalLen * 2);
                strBuf.append(this.userInstallRoot);
                for (int i = 0; i < webSrvs.length; ++i) {
                    strBuf.append(", " + webSrvs[i].toString());
                }
                throw new TransferFailedException(destFile.toString() + " is not a child of: " + strBuf.toString());
            }
            throw new TransferFailedException(destFile.toString() + " is not a child of: " + this.userInstallRoot);
        }
    }

    private File getTempFile(File destFile) throws TransferFailedException {
        File tempFileDest = null;
        File sameDirPath = null;
        try {
            sameDirPath = new File(destFile.getParent());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sameDirPath=" + sameDirPath);
            }
            tempFileDest = File.createTempFile(destFile.getName(), null, sameDirPath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tempFileDest = " + tempFileDest);
            }
        }
        catch (Exception e) {
            String msg = "EXCEPTION trying to create temporary file in: " + sameDirPath + " : " + e;
            Tr.error(tc, "ADFS0112", msg);
            throw new TransferFailedException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The temp download file is: " + tempFileDest);
        }
        if (tempFileDest.canWrite()) {
            return tempFileDest;
        }
        String msg = "No write access to " + tempFileDest + ". File permissions will not allow download to succeed.";
        Tr.error(tc, "ADFS0112", msg);
        throw new TransferFailedException(msg);
    }

    private void writeTempBackToOrig(File srcFile, File destFile) throws TransferFailedException {
        FileInputStream src = null;
        FileOutputStream tgt = null;
        if (srcFile.length() < 1L) {
            String msg = srcFile.toString() + " contains no data!";
            Tr.error(tc, "ADFS0112", msg);
            throw new TransferFailedException(msg);
        }
        try {
            src = new FileInputStream(srcFile);
        }
        catch (Exception e) {
            String msg = "EXCEPTION: " + e + "; FILE: " + srcFile + ".";
            Tr.error(tc, "ADFS0112", msg);
            throw new TransferFailedException(msg);
        }
        try {
            tgt = new FileOutputStream(destFile);
        }
        catch (Exception e) {
            String msg = "EXCEPTION: " + e + "; FILE: " + destFile + ".";
            Tr.error(tc, "ADFS0112", msg);
            throw new TransferFailedException(msg);
        }
        try {
            byte[] buf = new byte[8192];
            int numRead = src.read(buf);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, src.toString() + " : numRead = " + numRead);
            }
            while (numRead != -1) {
                tgt.write(buf, 0, numRead);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Write to: " + tgt);
                }
                numRead = src.read(buf);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, src.toString() + " : numRead = " + numRead);
            }
            src.close();
            tgt.close();
        }
        catch (IOException ioe) {
            String msg = "IOException copying " + srcFile + " to " + destFile + ".";
            Tr.error(tc, "ADFS0112", msg);
            throw new TransferFailedException(msg);
        }
    }

    private URL createUploadURL(String path, FileTransferOptions options) throws TransferFailedException {
        URL url;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUploadURL");
        }
        try {
            options = this.createDefaultOptionsIfNecessary(options);
            if (path.startsWith("\\") || path.startsWith("/")) {
                path = path.substring(1);
            }
            this.checkAccessPermission(path);
            StringBuilder urlBuff = new StringBuilder(256);
            urlBuff.append(TRANSFER);
            urlBuff.append(this.encode(path));
            urlBuff.append("?");
            urlBuff.append("overwrite");
            urlBuff.append("=");
            urlBuff.append(String.valueOf(options.isOverwrite()));
            urlBuff.append("&");
            urlBuff.append("compress");
            urlBuff.append("=");
            urlBuff.append(String.valueOf(options.isCompress()));
            this.addUUID(urlBuff);
            url = new URL(this.protocolToUse, this.transferHost, this.portToUse, urlBuff.toString());
        }
        catch (TransferFailedException tfe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUploadURL", "Rethrowing exception: " + (Object)((Object)tfe));
            }
            throw tfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.createUploadURL", (String)"3993", (Object)this);
            Tr.service(tc, "ADFS0124", new Object[]{path, t});
            TransferFailedException tfe = new TransferFailedException("Error occurred during upload to: " + path + ". Exception: " + t, t);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUploadURL", (Object)tfe);
            }
            throw tfe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUploadURL", url);
        }
        return url;
    }

    private URL createDownloadURL(String path, long rangeStart, long rangeEnd, FileTransferOptions options) throws TransferFailedException {
        URL url;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDownloadURL");
        }
        try {
            options = this.createDefaultOptionsIfNecessary(options);
            if (path.startsWith("\\") || path.startsWith("/")) {
                path = path.substring(1);
            }
            this.checkAccessPermission(path);
            StringBuilder urlBuff = new StringBuilder(256);
            urlBuff.append(TRANSFER);
            urlBuff.append(this.encode(path));
            urlBuff.append("?");
            if (rangeStart != -99L) {
                urlBuff.append("rangeStart");
                urlBuff.append("=");
                urlBuff.append(rangeStart);
                if (rangeEnd != -99L) {
                    urlBuff.append("&");
                    urlBuff.append("rangeEnd");
                    urlBuff.append("=");
                    urlBuff.append(rangeEnd);
                }
                urlBuff.append("&");
            }
            urlBuff.append("compress");
            urlBuff.append("=");
            urlBuff.append(String.valueOf(options.isCompress()));
            urlBuff.append("&");
            urlBuff.append("deleteOnCompletion");
            urlBuff.append("=");
            urlBuff.append(String.valueOf(options.isDeleteSourceOnCompletion()));
            this.addUUID(urlBuff);
            url = new URL(this.protocolToUse, this.transferHost, this.portToUse, urlBuff.toString());
        }
        catch (TransferFailedException tfe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDownloadURL", "Rethrowing exception: " + (Object)((Object)tfe));
            }
            throw tfe;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.createDownloadURL", (String)"4058", (Object)this);
            Tr.service(tc, "ADFS0125", new Object[]{path, t});
            TransferFailedException tfe = new TransferFailedException("Error occurred during download from: " + path + ". Exception: " + t, t);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDownloadURL", (Object)tfe);
            }
            throw tfe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDownloadURL", url);
        }
        return url;
    }

    private void addUUID(StringBuilder buf) {
        String uuid;
        if (this.ftConfig != null && (uuid = this.ftConfig.getProperties().getProperty("uuid")) != null) {
            buf.append("&uuid=" + uuid);
        }
    }

    private void checkAccessPermission(String docURI) throws TransferFailedException {
        boolean restricted;
        if (this.securityEnabled && SecurityContext.isServerProcess() && (restricted = RestrictedAccess.isRestricted((String)docURI))) {
            RoleBasedAuthorizer auth;
            try {
                auth = this.getAuthorizer();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.checkAccessPermission", (String)"4104", (Object)this);
                throw new TransferFailedException("Unable to get caller's security role: " + t, t);
            }
            if (!auth.isCallerInRole("administrator")) {
                throw new TransferFailedException("Caller is not in the required role to access restricted document: " + docURI);
            }
        }
    }

    private RoleBasedAuthorizer getAuthorizer() throws TransferFailedException {
        if (this.roleBasedAuth == null) {
            try {
                Class<?> securityHelperClass = Class.forName("com.ibm.ws.management.util.SecurityHelper");
                Method getHandler = securityHelperClass.getMethod("getHelper", new Class[0]);
                Object securityHelperInstance = getHandler.invoke(null, new Object[0]);
                Method getConfigurator = securityHelperClass.getMethod("getConfigurator", new Class[0]);
                Object configurator = getConfigurator.invoke(securityHelperInstance, new Object[0]);
                this.roleBasedAuth = ((RoleBasedConfigurator)configurator).getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception e) {
                throw new TransferFailedException("The security Authorizer can not be resolved: " + e, (Throwable)e);
            }
        }
        return this.roleBasedAuth;
    }

    private int getResponseCode(HttpURLConnection conn, StringHolder msgHolder, URL url) throws IOException {
        int statusCode;
        String headerField0 = conn.getHeaderField(0);
        if (headerField0 != null) {
            StringTokenizer stringTok = new StringTokenizer(headerField0, " ");
            String httpVer = stringTok.nextToken();
            String statusCodeString = stringTok.nextToken();
            statusCode = Integer.parseInt(statusCodeString);
            try {
                msgHolder.stringValue = headerField0.substring(headerField0.indexOf(statusCodeString));
            }
            catch (NoSuchElementException e1) {
                msgHolder.stringValue = "No such element exception for " + url + ".";
            }
        } else {
            try {
                statusCode = conn.getResponseCode();
                msgHolder.stringValue = conn.getResponseMessage();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.filetransfer.client.FileTransferClientImpl.getResponseCode", (String)"4167", (Object)this);
                throw ioe;
            }
        }
        return statusCode;
    }

    private FileTransferOptions createDefaultOptionsIfNecessary(FileTransferOptions options) {
        if (options == null) {
            options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default file transfer options.", options);
            }
        }
        return options;
    }

    private void populateResultsObject(HttpURLConnection conn, int statusCode, String msg, ResultsObject resultsObject) {
        String METHOD = "populateResultsObject";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "populateResultsObject", new Object[]{"statusCode=" + statusCode, "msg=" + msg});
        }
        if (resultsObject == null) {
            return;
        }
        String eof = null;
        try {
            eof = conn.getHeaderField("file-at-end");
            if (eof == null) {
                eof = Boolean.FALSE.toString();
            }
        }
        catch (NoSuchElementException e2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NoSuchElementException caught!");
            }
            eof = Boolean.FALSE.toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "eof=" + eof);
        }
        long lastModified = 0L;
        String time = null;
        try {
            time = conn.getHeaderField("file-timestamp");
            if (time != null) {
                lastModified = Long.parseLong(time);
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception encountered getting time out of file header!", ex);
            }
            lastModified = 0L;
        }
        if (time != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "time = " + time);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "time is null!");
        }
        resultsObject.eof = eof.equals(Boolean.TRUE.toString());
        resultsObject.statusCode = statusCode;
        resultsObject.msg = msg;
        resultsObject.lastModified = lastModified;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "populateResultsObject");
        }
    }

    class StringHolder {
        String stringValue = null;

        StringHolder() {
        }
    }

    class ResultsObject {
        boolean eof = false;
        int statusCode = 0;
        String msg = null;
        long lastModified = 0L;

        ResultsObject() {
        }
    }

    static class OutputStreamHandlerForGet
    extends OutputStreamHandler {
        private static TraceComponent _tc_osh_g = Tr.register(OutputStreamHandlerForFile.class, "Admin", "com.ibm.ws.management.resources.fileservice");
        private byte[] _sendBuff;

        public OutputStreamHandlerForGet(byte[] sendBuff) {
            if (_tc_osh_g.isEntryEnabled()) {
                Tr.entry(tc, "OutputStreamHandlerForGet", new Object[]{"sendBuff=" + sendBuff});
            }
            this._sendBuff = sendBuff;
            if (_tc_osh_g.isEntryEnabled()) {
                Tr.exit(tc, "OutputStreamHandlerForGet");
            }
        }

        public OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
            return conn.getOutputStream();
        }

        public void doHandleOutputStream(HttpURLConnection conn) throws IOException {
            if (_tc_osh_g.isEntryEnabled()) {
                Tr.entry(tc, "doHandleOutputStream", new Object[]{"conn=" + conn});
            }
            this._out.write(this._sendBuff);
            if (_tc_osh_g.isEntryEnabled()) {
                Tr.exit(tc, "doHandleOutputStream");
            }
        }
    }

    static class OutputStreamHandlerForFile
    extends OutputStreamHandler {
        private static TraceComponent _tc_osh_f = Tr.register(OutputStreamHandlerForFile.class, "Admin", "com.ibm.ws.management.resources.fileservice");
        private final RandomAccessFile _sourceFile;
        private final long _outputEnd;
        private final int _readBufferSize;
        private final FileTransferOptions _options;
        private final boolean _compress;

        public OutputStreamHandlerForFile(RandomAccessFile sourceFile, long outputEnd, int readBufferSize, FileTransferOptions options) {
            if (_tc_osh_f.isEntryEnabled()) {
                Tr.entry(tc, "OutputStreamHandlerForFile", new Object[]{"sourceFile=" + sourceFile, "outputEnd=" + outputEnd, "readBufferSize=" + readBufferSize, "options=" + options});
            }
            this._sourceFile = sourceFile;
            this._outputEnd = outputEnd;
            this._readBufferSize = readBufferSize;
            this._options = options;
            this._compress = options.isCompress();
            if (_tc_osh_f.isDebugEnabled()) {
                Tr.debug(tc, "compress=" + this._compress);
            }
            if (_tc_osh_f.isEntryEnabled()) {
                Tr.exit(tc, "OutputStreamHandlerForFile");
            }
        }

        public OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
            FilterOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (this._compress) {
                out = new GZIPOutputStream(out);
            }
            return out;
        }

        public void doHandleOutputStream(HttpURLConnection conn) throws IOException {
            if (_tc_osh_f.isEntryEnabled()) {
                Tr.entry(tc, "doHandleOutputStream", new Object[]{"conn=" + conn});
            }
            byte[] buf = new byte[this._readBufferSize];
            int numRead = this._sourceFile.read(buf);
            while (numRead != -1) {
                this._out.write(buf, 0, numRead);
                if (this._sourceFile.getFilePointer() < this._outputEnd) {
                    if (this._outputEnd - this._sourceFile.getFilePointer() < (long)this._readBufferSize) {
                        int bytesToRead = (int)(this._outputEnd - this._sourceFile.getFilePointer());
                        numRead = this._sourceFile.read(buf, 0, bytesToRead);
                        continue;
                    }
                    numRead = this._sourceFile.read(buf);
                    continue;
                }
                numRead = -1;
            }
            if (this._compress) {
                ((GZIPOutputStream)this._out).finish();
            }
            this._out.flush();
            if (_tc_osh_f.isEntryEnabled()) {
                Tr.exit(tc, "doHandleOutputStream");
            }
        }
    }

    static class OutputStreamHandlerForInputStream
    extends OutputStreamHandler {
        private static TraceComponent _tc_osh_is = Tr.register(OutputStreamHandlerForInputStream.class, "Admin", "com.ibm.ws.management.resources.fileservice");
        private final InputStream _sourceInputStream;
        private final FileTransferOptions _options;
        private final boolean _compress;

        public OutputStreamHandlerForInputStream(InputStream sourceInputStream, FileTransferOptions options) {
            if (_tc_osh_is.isEntryEnabled()) {
                Tr.entry(tc, "OutputStreamHandlerForInputStream", new Object[]{"sourceInputStream=" + sourceInputStream});
            }
            this._sourceInputStream = sourceInputStream;
            this._options = options;
            this._compress = options.isCompress();
            if (_tc_osh_is.isDebugEnabled()) {
                Tr.debug(tc, "compress=" + this._compress);
            }
            if (_tc_osh_is.isEntryEnabled()) {
                Tr.exit(tc, "OutputStreamHandlerForInputStream");
            }
        }

        public OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
            FilterOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (this._compress) {
                out = new GZIPOutputStream(out);
            }
            return out;
        }

        public void doHandleOutputStream(HttpURLConnection conn) throws IOException {
            if (_tc_osh_is.isEntryEnabled()) {
                Tr.entry(tc, "doHandleOutputStream", new Object[]{"conn=" + conn});
            }
            boolean exceptionOccurred = false;
            byte[] buf = new byte[8192];
            int numRead = this._sourceInputStream.read(buf);
            while (numRead != -1) {
                this._out.write(buf, 0, numRead);
                numRead = this._sourceInputStream.read(buf);
            }
            this._sourceInputStream.close();
            this._out.flush();
            if (_tc_osh_is.isEntryEnabled()) {
                Tr.exit(tc, "doHandleOutputStream");
            }
        }
    }

    static abstract class OutputStreamHandler {
        private static TraceComponent _tc_osh = Tr.register(OutputStreamHandler.class, "Admin", "com.ibm.ws.management.resources.fileservice");
        OutputStream _out;

        OutputStreamHandler() {
        }

        public void handleOutputStream(HttpURLConnection conn) throws IOException {
            if (_tc_osh.isEntryEnabled()) {
                Tr.entry(tc, "handleOutputStream", new Object[]{"conn=" + conn});
            }
            boolean exceptionOccurred = false;
            try {
                this._out = this.getOutputStream(conn);
                this.doHandleOutputStream(conn);
            }
            catch (IOException ex) {
                exceptionOccurred = true;
                if (_tc_osh.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutputStream", ex);
                }
                throw ex;
            }
            finally {
                block16: {
                    try {
                        if (this._out != null) {
                            this._out.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!exceptionOccurred) {
                            if (_tc_osh.isEntryEnabled()) {
                                Tr.exit(tc, "handleOutputStream", ex);
                            }
                            throw ex;
                        }
                        if (!_tc_osh.isDebugEnabled()) break block16;
                        Tr.debug(tc, "handleOutputStream: Exception closing output stream", ex);
                    }
                }
            }
            if (_tc_osh.isEntryEnabled()) {
                Tr.exit(tc, "handleOutputStream");
            }
        }

        public abstract OutputStream getOutputStream(HttpURLConnection var1) throws IOException;

        public abstract void doHandleOutputStream(HttpURLConnection var1) throws IOException;
    }

    class DownloadConnectionParams
    extends ConnectionParams {
        private boolean _doOutput;

        public DownloadConnectionParams(boolean doOutput) {
            this._doOutput = doOutput;
        }

        public void setUpConnection(HttpURLConnection conn) throws Exception {
            conn.setRequestMethod("GET");
            conn.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
            conn.setDoOutput(this._doOutput);
            conn.setDoInput(true);
        }
    }

    class UploadConnectionParams
    extends ConnectionParams {
        private Boolean _append;
        private File _srcFile;

        public UploadConnectionParams(Boolean append, File srcFile) {
            this._append = append;
            this._srcFile = srcFile;
        }

        public void setUpConnection(HttpURLConnection conn) throws Exception {
            conn.setRequestMethod("PUT");
            conn.setDoOutput(true);
            conn.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
            if (this._append != null) {
                conn.setRequestProperty("file-append", this._append.toString());
            }
            if (this._srcFile != null) {
                conn.setRequestProperty("file-timestamp", Long.toString(this._srcFile.lastModified()));
            }
        }
    }

    abstract class ConnectionParams {
        ConnectionParams() {
        }

        public abstract void setUpConnection(HttpURLConnection var1) throws Exception;
    }
}

