/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.fileservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.fileservice.FileBrowser;
import com.ibm.websphere.management.fileservice.FileServiceException;
import com.ibm.websphere.management.fileservice.RemoteFile;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.variable.VariableExpansionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class FileBrowserImpl
implements FileBrowser {
    private static TraceComponent tc = Tr.register(FileBrowserImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static Properties fileSystemProperties = null;
    private VariableMap vMap = null;

    public FileBrowserImpl() {
    }

    public FileBrowserImpl(VariableMap vMap) {
        this.vMap = vMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile mkdir(String directory) throws FileServiceException {
        RemoteFile remoteFile;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mkdir");
            }
            RemoteFile resultFile = null;
            boolean folderCreated = false;
            File newFolder = null;
            newFolder = new File(directory = this.expand(directory));
            folderCreated = newFolder.mkdir();
            if (folderCreated) {
                resultFile = this.getFileProperties(newFolder);
            } else {
                Tr.service(tc, "ADFS0103", new Object[]{directory});
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "create directory : " + directory);
            }
            remoteFile = resultFile;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var7_7 = null;
                if (!tc.isEntryEnabled()) break block7;
                Tr.exit(tc, "mkdir");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mkdir");
        }
        return remoteFile;
    }

    public String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public String getWASHome() {
        return System.getProperty("server.root");
    }

    public Properties getRemoteFileSystemProperties() {
        if (fileSystemProperties == null) {
            fileSystemProperties = new Properties();
        }
        fileSystemProperties.put("file.separator", this.getFileSeparator());
        fileSystemProperties.put("path.separator", this.getPathSeparator());
        if (this.getWASHome() != null) {
            fileSystemProperties.put("server.root", this.getWASHome());
        }
        return fileSystemProperties;
    }

    public Boolean exists(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists", fileName);
        }
        fileName = this.expand(fileName);
        File file = new File(fileName);
        boolean exists = file.exists();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists", fileName);
        }
        return new Boolean(exists);
    }

    public Boolean rename(String existingName, String newName) {
        throw new UnsupportedOperationException("FileBrowser MBean rename method is not supported!");
    }

    public synchronized RemoteFile[] listRoots() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listRoots");
        }
        File[] roots = File.listRoots();
        ArrayList<RemoteFile> list = new ArrayList<RemoteFile>(roots.length);
        RemoteFile rf = null;
        for (int i = 0; i < roots.length; ++i) {
            try {
                rf = this.getFileProperties(roots[i]);
                if (rf == null) continue;
                list.add(rf);
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.listRoots", (String)"213", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception trying to get file properties");
            }
        }
        RemoteFile[] result = new RemoteFile[list.size()];
        list.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listRoots", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] listRemoteFiles(String dir) throws FileServiceException {
        RemoteFile[] remoteFileArray;
        Vector<File> filesToList;
        File directory;
        RemoteFile[] result;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listRemoteFiles", " Dir : " + dir);
            }
            dir = this.expand(dir);
            result = null;
            directory = new File(dir);
            filesToList = new Vector<File>();
            if (!directory.exists()) {
                throw new FileServiceException("Directory " + directory + " does not exist");
            }
            boolean canShow = this.canShowFilesForThisDir(dir);
            if (canShow) break block9;
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "listRemotrFiles: " + dir + " is a child of " + this.getWASHome());
            }
            RemoteFile[] remoteFileArray2 = null;
            Object var11_8 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listRemoteFiles");
            }
            return remoteFileArray2;
        }
        try {
            File[] files = directory.listFiles();
            int numFiles = files == null ? 0 : files.length;
            for (int i = 0; i < numFiles; ++i) {
                File f = files[i];
                if (!f.isFile() && !f.isDirectory() || f.isHidden()) continue;
                filesToList.addElement(f);
            }
            remoteFileArray = result = this.filesToRemoteFileArray(filesToList);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var11_10 = null;
                if (!tc.isEntryEnabled()) break block10;
                Tr.exit(tc, "listRemoteFiles");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listRemoteFiles");
        }
        return remoteFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteFile getRemoteFileProperties(String containingDir, String fileName) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteFileProperties1", containingDir + File.separator + fileName);
        }
        containingDir = this.expand(containingDir);
        fileName = this.expand(fileName);
        RemoteFile result = null;
        try {
            File newFile = new File(containingDir, fileName);
            if (newFile.exists()) {
                result = this.getFileProperties(newFile);
            }
            remoteFile = result;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var7_7 = null;
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "getRemoteFileProperties1", result);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteFileProperties1", result);
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteFile getRemoteFileProperties(String pathname) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteFileProperties2", pathname);
        }
        pathname = this.expand(pathname);
        RemoteFile result = null;
        try {
            pathname = pathname.equals("HOME_DIR") ? System.getProperty("user.home") : pathname;
            File newFile = new File(pathname);
            if (newFile.exists()) {
                result = this.getFileProperties(newFile);
            }
            remoteFile = result;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "getRemoteFileProperties2", result);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteFileProperties2", result);
        }
        return remoteFile;
    }

    private RemoteFile getFileProperties(File file) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileProperties", file);
        }
        if (file.getPath().equals("A:\\") || file.getPath().equals("B:\\")) {
            throw new FileServiceException(file.getPath() + " is not a valid selection.");
        }
        try {
            RemoteFile result = new RemoteFile();
            result.setName(file.getName());
            result.setAbsolutePath(file.getAbsolutePath());
            if (file.isDirectory()) {
                result.setType("Directory");
            } else {
                result.setType("NormalFile");
            }
            String parentDir = file.getParent();
            if (parentDir != null) {
                result.setParentDirectory(parentDir);
            }
            result.setSeparator(File.separator);
            remoteFile = result;
            Object var6_6 = null;
        }
        catch (Exception ex) {
            try {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.getFileProperties", (String)"383", (Object)this);
                Tr.service(tc, "ADFS0104", new Object[]{ex.getMessage()});
                throw new FileServiceException((Throwable)ex, "");
            }
            catch (Throwable throwable) {
                block10: {
                    Object var6_7 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    Tr.exit(tc, "getFileProperties:");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileProperties:");
        }
        return remoteFile;
    }

    private RemoteFile[] filesToRemoteFileArray(Vector files) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filesToRemoteFileArray", files);
        }
        ArrayList<RemoteFile> list = new ArrayList<RemoteFile>(files.size());
        for (int i = 0; i < files.size(); ++i) {
            try {
                list.add(this.getFileProperties((File)files.elementAt(i)));
                continue;
            }
            catch (FileServiceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.filesToRemoteFileArray", (String)"411", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception: ", (Object)e);
            }
        }
        RemoteFile[] result = new RemoteFile[list.size()];
        list.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filesToRemoteFileArray", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength(String filename) throws FileServiceException {
        long l;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileLength", filename);
        }
        try {
            long size;
            filename = this.expand(filename);
            File srcFile = new File(filename);
            if (!srcFile.exists()) {
                throw new FileServiceException((Throwable)new FileNotFoundException(filename), filename + " not found.");
            }
            l = size = srcFile.length();
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var8_6 = null;
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "getLineCount");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLineCount");
        }
        return l;
    }

    /*
     * Loose catch block
     */
    public long getLineCount(String filename) throws FileServiceException {
        long l;
        BufferedReader input;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLineCount", filename);
            }
            filename = this.expand(filename);
            input = null;
            String line = null;
            long n = 0L;
            input = new BufferedReader(new FileReader(filename));
            line = input.readLine();
            while (line != null) {
                ++n;
                line = input.readLine();
            }
            l = n;
            Object var9_7 = null;
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException io) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "error closing input file", io);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLineCount");
        }
        return l;
        catch (Exception e) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getLineCount failed", e);
                }
                throw new FileServiceException((Throwable)e, "getLineCount failed with an exception");
            }
            catch (Throwable throwable) {
                block15: {
                    block14: {
                        Object var9_8 = null;
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException io) {
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug(tc, "error closing input file", io);
                        }
                    }
                    if (!tc.isEntryEnabled()) break block15;
                    Tr.exit(tc, "getLineCount");
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long[] translateLineNumbersToOffsets(String filename, long[] lineNumbers) throws FileServiceException {
        long[] lArray;
        RandomAccessFile src;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertLineNumbersToBytes", filename);
            }
            if (lineNumbers == null || lineNumbers.length == 0) {
                throw new FileServiceException("lineNumbers array is empty");
            }
            int i = 0;
            for (i = 0; i < lineNumbers.length - 1; ++i) {
                if (lineNumbers[i] <= lineNumbers[i + 1]) continue;
                throw new FileServiceException("The lineNumbers input are not ascending");
            }
            filename = this.expand(filename);
            String line = null;
            long lineNumber = 0L;
            long[] byteOffsets = new long[lineNumbers.length];
            i = 0;
            src = null;
            src = new RandomAccessFile(filename, "r");
            line = src.readLine();
            for (i = 0; i < lineNumbers.length && (lineNumbers[i] == 0L || lineNumbers[i] == 1L); ++i) {
                byteOffsets[i] = 0L;
            }
            while (line != null && i < lineNumbers.length) {
                if (lineNumbers[i] == ++lineNumber + 1L) {
                    byteOffsets[i] = src.getFilePointer();
                    if (++i < lineNumbers.length && lineNumbers[i] == lineNumbers[i - 1]) {
                        byteOffsets[i] = byteOffsets[i - 1];
                        ++i;
                    }
                }
                line = src.readLine();
            }
            while (i < lineNumbers.length) {
                byteOffsets[i] = src.length();
                ++i;
            }
            src.close();
            lArray = byteOffsets;
            Object var11_10 = null;
            try {
                if (src != null) {
                    src.close();
                }
            }
            catch (IOException io) {
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "error closing input file", io);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLineCount");
        }
        return lArray;
        catch (Exception e) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "convertLineNumbersToBytes failed", e);
                }
                throw new FileServiceException((Throwable)e, "convertLineNumbersToBytes failed with an exception");
            }
            catch (Throwable throwable) {
                block21: {
                    block20: {
                        Object var11_11 = null;
                        try {
                            if (src != null) {
                                src.close();
                            }
                        }
                        catch (IOException io) {
                            if (!tc.isDebugEnabled()) break block20;
                            Tr.debug(tc, "error closing input file", io);
                        }
                    }
                    if (!tc.isEntryEnabled()) break block21;
                    Tr.exit(tc, "getLineCount");
                }
                throw throwable;
            }
        }
    }

    public String getName() {
        return "FileBrowser";
    }

    private String expand(String variable) {
        if (this.vMap != null) {
            try {
                variable = this.vMap.expand(variable);
            }
            catch (VariableExpansionException vae) {
                IllegalArgumentException iae = new IllegalArgumentException(vae.getMessage());
                iae.setStackTrace(vae.getStackTrace());
                throw iae;
            }
        }
        variable = variable.replace('\\', File.separatorChar);
        variable = variable.replace('/', File.separatorChar);
        return variable;
    }

    private boolean canShowFilesForThisDir(String dir) throws FileServiceException {
        String cmp2;
        String repRoot = this.getRepositoryRoot().replace('\\', '/');
        String cmp1 = dir.toLowerCase().replace('\\', '/');
        if (cmp1.startsWith(cmp2 = repRoot.toLowerCase())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot show files in " + dir + " because it points into " + repRoot);
            }
            return false;
        }
        return true;
    }

    private String getRepositoryRoot() throws FileServiceException {
        String repositoryRoot = null;
        try {
            ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
            Properties repositoryProps = repository2.getConfig();
            repositoryRoot = repositoryProps.getProperty("was.repository.root");
            if (repositoryRoot.endsWith(File.separator)) {
                repositoryRoot = repositoryRoot.substring(0, repositoryRoot.length() - 1);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.getRepositoryRoot", (String)"138", (Object)this);
            throw new FileServiceException((Throwable)e, "Unable to get repository temporary directory.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The repository root=[" + repositoryRoot + "]");
        }
        return repositoryRoot;
    }
}

