/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.ServantAdminService;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushToControlNotificationSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZServantNotificationManager
implements DownstreamProcessManager {
    private static TraceComponent tc = Tr.register(ZServantNotificationManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map filterMap;
    private Map servantMap;

    public ZServantNotificationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.filterMap = new HashMap();
        this.servantMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void addDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDownstreamProcess", serverInfo);
        }
        DSMEntry entry = null;
        if (this.isFilterAdded()) {
            entry = this.createDSMEntry(serverInfo);
        }
        this.servantMap.put(serverInfo, entry);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDownstreamProcess");
        }
    }

    private DSMEntry createDSMEntry(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDSMEntry", serverInfo);
        }
        ConsolidatedFilter newFilter = this.createFilter(serverInfo);
        DSMEntry newEntry = null;
        if (!newFilter.isEmpty()) {
            ListenerIdentifier id = this.addRemoteListener(serverInfo, newFilter);
            newEntry = new DSMEntry(newFilter, id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDSMEntry", newEntry);
        }
        return newEntry;
    }

    private ConsolidatedFilter createFilter(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFilter", serverInfo);
        }
        ConsolidatedFilter filter = new ConsolidatedFilter();
        Iterator i = this.filterMap.values().iterator();
        while (i.hasNext()) {
            filter.appendFilterEntries((ConsolidatedFilter)i.next(), serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFilter", filter);
        }
        return filter;
    }

    private ListenerIdentifier addRemoteListener(ServerInfo serverInfo, ConsolidatedFilter filter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoteListener", new Object[]{serverInfo, filter});
        }
        RemoteNotificationBroadcaster rnb = this.getRemoteProxy(serverInfo);
        PushToControlNotificationSender listener = new PushToControlNotificationSender();
        ListenerIdentifier id = rnb.addNotificationListener(filter, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoteListener", id);
        }
        return id;
    }

    private void updateRemoteListener(ServerInfo serverInfo, DSMEntry dsmEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRemoteListener", new Object[]{serverInfo, dsmEntry});
        }
        RemoteNotificationBroadcaster rnb = this.getRemoteProxy(serverInfo);
        rnb.resetFilter(dsmEntry.listenerId, dsmEntry.filter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRemoteListener");
        }
    }

    private void removeRemoteListener(ServerInfo serverInfo, DSMEntry dsmEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRemoteListener", new Object[]{serverInfo, dsmEntry});
        }
        RemoteNotificationBroadcaster rnb = this.getRemoteProxy(serverInfo);
        rnb.removeNotificationListener(dsmEntry.listenerId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRemoteListener");
        }
    }

    private RemoteNotificationBroadcaster getRemoteProxy(ServerInfo serverInfo) throws ConnectorException {
        ServantAdminService proxy = Utils.getServantAdminService();
        proxy.setServantToken(serverInfo.getName());
        return proxy;
    }

    public synchronized void removeDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        this.servantMap.remove(serverInfo);
    }

    public synchronized void setFilter(Object id, ConsolidatedFilter filter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilter", new Object[]{id, filter});
        }
        if (AdminHelper.getPlatformHelper().isServerShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setFilter", "server shutdown");
            }
            return;
        }
        this.filterMap.put(id, filter);
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    public synchronized void unsetFilter(Object id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetFilter", id);
        }
        if (AdminHelper.getPlatformHelper().isServerShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setFilter", "server shutdown");
            }
            return;
        }
        this.filterMap.remove(id);
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetFilter");
        }
    }

    private boolean isFilterAdded() {
        return !this.filterMap.isEmpty();
    }

    private void updateServerListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerListeners");
        }
        Iterator i = this.servantMap.keySet().iterator();
        while (i.hasNext()) {
            try {
                DSMEntry entry;
                ServerInfo serverInfo = (ServerInfo)i.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "examining server " + serverInfo);
                }
                if ((entry = (DSMEntry)this.servantMap.get(serverInfo)) == null) {
                    if (!this.isFilterAdded()) continue;
                    entry = this.createDSMEntry(serverInfo);
                    this.servantMap.put(serverInfo, entry);
                    continue;
                }
                RemoteNotificationBroadcaster server = this.getRemoteProxy(serverInfo);
                if (this.isFilterAdded()) {
                    ConsolidatedFilter updatedFilter = this.createFilter(serverInfo);
                    if (updatedFilter.equals(entry.filter)) continue;
                    entry.filter = updatedFilter;
                    this.updateRemoteListener(serverInfo, entry);
                    continue;
                }
                this.removeRemoteListener(serverInfo, entry);
                this.servantMap.put(serverInfo, null);
            }
            catch (ReceiverNotFoundException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.DownstreamProcessManager.updateServerListeners", (String)"206", (Object)this);
            }
            catch (ConnectorException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.DownstreamProcessManager.updateServerListeners", (String)"210", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServerListeners");
        }
    }

    class DSMEntry {
        ConsolidatedFilter filter;
        ListenerIdentifier listenerId;

        DSMEntry(ConsolidatedFilter filter, ListenerIdentifier listenerId) {
            this.filter = filter;
            this.listenerId = listenerId;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

